/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container.status;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.controller.api.model.events.ServerInstanceDeleted;
import org.kie.server.controller.api.model.events.ServerInstanceUpdated;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.workbench.common.screens.server.management.client.container.status.card.ContainerCardPresenter;
import org.slf4j.Logger;

@Dependent
public class ContainerRemoteStatusPresenter {
    private final Logger logger;
    private final View view;
    private final ManagedInstance<ContainerCardPresenter> cardPresenterProvider;
    private final Map<String, Map<String, ContainerCardPresenter>> index = new HashMap<String, Map<String, ContainerCardPresenter>>();
    private ContainerSpec containerSpec;

    @Inject
    public ContainerRemoteStatusPresenter(Logger logger, View view, ManagedInstance<ContainerCardPresenter> cardPresenterProvider) {
        this.logger = logger;
        this.view = view;
        this.cardPresenterProvider = cardPresenterProvider;
    }

    @PostConstruct
    public void init() {
    }

    public View getView() {
        return this.view;
    }

    public void onServerInstanceUpdated(@Observes ServerInstanceUpdated serverInstanceUpdated) {
        if (serverInstanceUpdated != null && serverInstanceUpdated.getServerInstance() != null) {
            String updatedServerInstanceKey = serverInstanceUpdated.getServerInstance().getServerInstanceId();
            if (this.index.containsKey(updatedServerInstanceKey)) {
                HashMap<String, ContainerCardPresenter> oldIndex = new HashMap<String, ContainerCardPresenter>(this.index.remove(updatedServerInstanceKey));
                HashMap<String, ContainerCardPresenter> newIndexIndex = new HashMap<String, ContainerCardPresenter>(serverInstanceUpdated.getServerInstance().getContainers().size());
                this.index.put(updatedServerInstanceKey, newIndexIndex);
                for (Container container : serverInstanceUpdated.getServerInstance().getContainers()) {
                    ContainerCardPresenter presenter = (ContainerCardPresenter)oldIndex.remove(container.getContainerName());
                    if (container.getStatus().equals((Object)KieContainerStatus.STOPPED)) continue;
                    if (presenter != null) {
                        presenter.updateContent((ServerInstanceKey)serverInstanceUpdated.getServerInstance(), container);
                    } else {
                        presenter = this.buildContainer(container);
                    }
                    newIndexIndex.put(container.getContainerName(), presenter);
                }
                for (ContainerCardPresenter presenter : oldIndex.values()) {
                    presenter.delete();
                }
            } else {
                for (Container container : serverInstanceUpdated.getServerInstance().getContainers()) {
                    if (!container.getServerTemplateId().equals(this.containerSpec.getServerTemplateKey().getId()) || !container.getContainerSpecId().equals(this.containerSpec.getId())) continue;
                    this.buildAndIndexContainer(container);
                }
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void onDelete(@Observes ServerInstanceDeleted serverInstanceDeleted) {
        if (serverInstanceDeleted != null && serverInstanceDeleted.getServerInstanceId() != null) {
            Map<String, ContainerCardPresenter> oldIndex;
            String deletedServerInstanceId = serverInstanceDeleted.getServerInstanceId();
            if (this.index.containsKey(deletedServerInstanceId) && (oldIndex = this.index.remove(deletedServerInstanceId)) != null) {
                for (ContainerCardPresenter presenter : oldIndex.values()) {
                    presenter.delete();
                }
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    public void setup(ContainerSpec containerSpec, Collection<Container> containers) {
        this.containerSpec = containerSpec;
        this.view.clear();
        for (Container container : containers) {
            if (container.getStatus().equals((Object)KieContainerStatus.STOPPED)) continue;
            this.buildAndIndexContainer(container);
        }
    }

    private void buildAndIndexContainer(Container container) {
        this.index(container, this.buildContainer(container));
    }

    private ContainerCardPresenter buildContainer(Container container) {
        ContainerCardPresenter cardPresenter = (ContainerCardPresenter)this.cardPresenterProvider.get();
        cardPresenter.setup(container.getServerInstanceKey(), container);
        this.view.addCard((IsWidget)cardPresenter.getView().asWidget());
        return cardPresenter;
    }

    private void index(Container container, ContainerCardPresenter cardPresenter) {
        if (!this.index.containsKey(container.getServerInstanceKey().getServerInstanceId())) {
            this.index.put(container.getServerInstanceKey().getServerInstanceId(), new HashMap());
        }
        this.index.get(container.getServerInstanceKey().getServerInstanceId()).put(container.getContainerName(), cardPresenter);
    }

    public static interface View
    extends IsWidget {
        public void addCard(IsWidget var1);

        public void clear();
    }
}

