/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.container.status.card;

import com.google.gwt.user.client.ui.IsWidget;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.runtime.ServerInstanceKey;
import org.kie.workbench.common.screens.server.management.client.events.ServerInstanceSelected;
import org.kie.workbench.common.screens.server.management.client.widget.card.CardPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.body.BodyPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.footer.FooterPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.title.LinkTitlePresenter;
import org.uberfire.mvp.Command;

@Dependent
public class ContainerCardPresenter {
    private final View view;
    private final ManagedInstance<Object> presenterProvider;
    private final Event<ServerInstanceSelected> remoteServerSelectedEvent;
    private LinkTitlePresenter linkTitlePresenter;
    private BodyPresenter bodyPresenter;
    private FooterPresenter footerPresenter;

    @Inject
    public ContainerCardPresenter(View view, ManagedInstance<Object> presenterProvider, Event<ServerInstanceSelected> remoteServerSelectedEvent) {
        this.view = view;
        this.presenterProvider = presenterProvider;
        this.remoteServerSelectedEvent = remoteServerSelectedEvent;
    }

    public View getView() {
        return this.view;
    }

    public void setup(ServerInstanceKey serverInstanceKey, Container container) {
        this.linkTitlePresenter = (LinkTitlePresenter)this.presenterProvider.select(LinkTitlePresenter.class, new Annotation[0]).get();
        this.bodyPresenter = (BodyPresenter)this.presenterProvider.select(BodyPresenter.class, new Annotation[0]).get();
        this.footerPresenter = (FooterPresenter)this.presenterProvider.select(FooterPresenter.class, new Annotation[0]).get();
        this.updateContent(serverInstanceKey, container);
        CardPresenter card = (CardPresenter)this.presenterProvider.select(CardPresenter.class, new Annotation[0]).get();
        card.addTitle(this.linkTitlePresenter);
        card.addBody(this.bodyPresenter);
        card.addFooter(this.footerPresenter);
        this.view.setCard(card.getView());
    }

    public void delete() {
        this.view.delete();
    }

    public void updateContent(final ServerInstanceKey serverInstanceKey, Container container) {
        this.linkTitlePresenter.setup(serverInstanceKey.getServerName(), new Command(){

            public void execute() {
                ContainerCardPresenter.this.remoteServerSelectedEvent.fire((Object)new ServerInstanceSelected(serverInstanceKey));
            }
        });
        this.bodyPresenter.setup(container.getMessages());
        this.footerPresenter.setup(container.getUrl(), container.getResolvedReleasedId().getVersion());
    }

    public static interface View
    extends IsWidget {
        public void setCard(CardPresenter.View var1);

        public void delete();
    }
}

