/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.remote;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.user.client.ui.Composite;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Heading;
import org.gwtbootstrap3.client.ui.constants.HeadingSize;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.EventHandler;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.remote.RemotePresenter;
import org.kie.workbench.common.screens.server.management.client.remote.RemoteStatusPresenter;
import org.kie.workbench.common.screens.server.management.client.remote.empty.RemoteEmptyPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.Div;

@Dependent
@Templated
public class RemoteView
extends Composite
implements RemotePresenter.View {
    private RemotePresenter presenter;
    private TranslationService translationService;
    @Inject
    @DataField(value="remote-content")
    Div remoteContent;
    @Inject
    @DataField
    Button refresh;
    @Inject
    @DataField
    Button remove;
    @DataField(value="server-name")
    Heading serverName = new Heading(HeadingSize.H3);
    @Inject
    @DataField
    Anchor url;

    @Inject
    public RemoteView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(RemotePresenter presenter) {
        this.presenter = presenter;
    }

    @Override
    public void setServerName(String serverName) {
        this.serverName.setText(serverName);
    }

    @Override
    public void setServerURL(String url) {
        this.url.setHref(url);
        this.url.setText(url);
    }

    @Override
    public void setEmptyView(RemoteEmptyPresenter.View view) {
        this.clear();
        this.remoteContent.add(view.asWidget());
    }

    @Override
    public void setStatusPresenter(RemoteStatusPresenter.View view) {
        this.clear();
        this.remoteContent.add(view.asWidget());
    }

    @Override
    public void clear() {
        this.remoteContent.clear();
    }

    @EventHandler(value={"refresh"})
    public void onRefresh(ClickEvent event) {
        this.presenter.refresh();
    }

    @EventHandler(value={"remove"})
    public void onRemove(ClickEvent event) {
        this.presenter.remove();
    }

    @Override
    public String getRemoteInstanceRemoveSuccessMessage() {
        return this.translationService.format("RemoteView.RemoteInstanceRemoveSuccess", new Object[0]);
    }

    @Override
    public String getRemoteInstanceRemoveErrorMessage() {
        return this.translationService.format("RemoteView.RemoteInstanceRemoveError", new Object[0]);
    }
}

