/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.remote.card;

import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.server.controller.api.model.runtime.Container;
import org.kie.server.controller.api.model.spec.ContainerSpecKey;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.workbench.common.screens.server.management.client.container.status.card.ContainerCardPresenter;
import org.kie.workbench.common.screens.server.management.client.events.ContainerSpecSelected;
import org.kie.workbench.common.screens.server.management.client.widget.card.CardPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.body.BodyPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.footer.FooterPresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.title.InfoTitlePresenter;
import org.kie.workbench.common.screens.server.management.client.widget.card.title.LinkTitlePresenter;
import org.uberfire.mvp.Command;

@Dependent
public class ContainerCardPresenter {
    private final ManagedInstance<Object> presenterProvider;
    private final ContainerCardPresenter.View view;
    private final Event<ContainerSpecSelected> containerSpecSelectedEvent;

    @Inject
    public ContainerCardPresenter(ManagedInstance<Object> presenterProvider, ContainerCardPresenter.View view, Event<ContainerSpecSelected> containerSpecSelectedEvent) {
        this.presenterProvider = presenterProvider;
        this.view = view;
        this.containerSpecSelectedEvent = containerSpecSelectedEvent;
    }

    public ContainerCardPresenter.View getView() {
        return this.view;
    }

    public void setup(final Container container) {
        LinkTitlePresenter linkTitlePresenter = (LinkTitlePresenter)this.presenterProvider.select(LinkTitlePresenter.class, new Annotation[0]).get();
        linkTitlePresenter.setup(container.getContainerName(), new Command(){

            public void execute() {
                ContainerCardPresenter.this.containerSpecSelectedEvent.fire((Object)new ContainerSpecSelected(ContainerCardPresenter.this.buildContainerSpecKey(container)));
            }
        });
        InfoTitlePresenter infoTitlePresenter = (InfoTitlePresenter)this.presenterProvider.select(InfoTitlePresenter.class, new Annotation[0]).get();
        infoTitlePresenter.setup(container.getResolvedReleasedId());
        BodyPresenter bodyPresenter = (BodyPresenter)this.presenterProvider.select(BodyPresenter.class, new Annotation[0]).get();
        bodyPresenter.setup(container.getMessages());
        FooterPresenter footerPresenter = (FooterPresenter)this.presenterProvider.select(FooterPresenter.class, new Annotation[0]).get();
        footerPresenter.setup(container.getUrl(), container.getResolvedReleasedId().getVersion());
        CardPresenter card = (CardPresenter)this.presenterProvider.select(CardPresenter.class, new Annotation[0]).get();
        card.addTitle(linkTitlePresenter);
        card.addTitle(infoTitlePresenter);
        card.addBody(bodyPresenter);
        card.addFooter(footerPresenter);
        this.view.setCard(card.getView());
    }

    private ContainerSpecKey buildContainerSpecKey(Container container) {
        return new ContainerSpecKey(container.getContainerSpecId(), container.getContainerName(), new ServerTemplateKey(container.getServerInstanceKey().getServerTemplateId(), ""));
    }
}

