/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.util;

import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.kie.workbench.common.screens.server.management.model.ContainerRuntimeOperation;
import org.uberfire.commons.validation.PortablePreconditions;

public enum ClientContainerRuntimeOperation {
    START_CONTAINER("ClientContainerRuntimeOperation.StartContainer", ContainerRuntimeOperation.START_CONTAINER),
    STOP_CONTAINER("ClientContainerRuntimeOperation.StopContainer", ContainerRuntimeOperation.STOP_CONTAINER),
    UPGRADE_CONTAINER("ClientContainerRuntimeOperation.UpgradeContainer", ContainerRuntimeOperation.UPGRADE_CONTAINER),
    SCAN("ClientContainerRuntimeOperation.Scan", ContainerRuntimeOperation.SCAN),
    START_SCANNER("ClientContainerRuntimeOperation.StartScanner", ContainerRuntimeOperation.START_SCANNER),
    STOP_SCANNER("ClientContainerRuntimeOperation.StopScanner", ContainerRuntimeOperation.STOP_SCANNER);

    private final String valueTranslationKey;
    private final ContainerRuntimeOperation containerRuntimeOperation;

    private ClientContainerRuntimeOperation(String valueTranslationKey, ContainerRuntimeOperation containerRuntimeOperation) {
        this.valueTranslationKey = PortablePreconditions.checkNotEmpty((String)"valueTranslationKey", (String)valueTranslationKey);
        this.containerRuntimeOperation = (ContainerRuntimeOperation)PortablePreconditions.checkNotNull((String)"containerRuntimeOperation", (Object)containerRuntimeOperation);
    }

    public ContainerRuntimeOperation getContainerRuntimeOperation() {
        return this.containerRuntimeOperation;
    }

    public String getValue(TranslationService translationService) {
        return translationService.format(this.valueTranslationKey, new Object[0]);
    }

    public static ClientContainerRuntimeOperation convert(ContainerRuntimeOperation containerRuntimeOperation) {
        switch (containerRuntimeOperation) {
            case START_CONTAINER: {
                return START_CONTAINER;
            }
            case STOP_CONTAINER: {
                return STOP_CONTAINER;
            }
            case UPGRADE_CONTAINER: {
                return UPGRADE_CONTAINER;
            }
            case SCAN: {
                return SCAN;
            }
            case START_SCANNER: {
                return START_SCANNER;
            }
            case STOP_SCANNER: {
                return STOP_SCANNER;
            }
        }
        throw new RuntimeException("Invalid parameter");
    }
}

