/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.widget.artifact;

import com.google.gwt.cell.client.Cell;
import com.google.gwt.cell.client.FieldUpdater;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.guvnor.m2repo.client.widgets.ArtifactListView;
import org.guvnor.m2repo.model.JarListPageRow;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Row;
import org.gwtbootstrap3.client.ui.TextBox;
import org.gwtbootstrap3.client.ui.constants.ButtonSize;
import org.gwtbootstrap3.client.ui.gwt.ButtonCell;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.widget.artifact.ArtifactListWidgetPresenter;

@Dependent
@Templated
public class ArtifactListWidgetView
extends Composite
implements ArtifactListWidgetPresenter.View {
    private ArtifactListWidgetPresenter presenter;
    private TranslationService translationService;
    @Inject
    @DataField(value="row-place-list")
    Row panel;
    @Inject
    @DataField
    TextBox filter;
    @Inject
    @DataField
    Button search;

    @Inject
    public ArtifactListWidgetView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(final ArtifactListWidgetPresenter presenter) {
        this.presenter = presenter;
        this.search.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                presenter.search(ArtifactListWidgetView.this.filter.getText());
            }
        });
        ArtifactListView artifactListView = presenter.getArtifactListView();
        artifactListView.addColumn(this.buildSelectColumn(), this.getSelectColumnLabel());
        artifactListView.setContentHeight("200px");
        Style style = artifactListView.asWidget().getElement().getStyle();
        style.setMarginLeft(0.0, Style.Unit.PX);
        style.setMarginRight(0.0, Style.Unit.PX);
        this.panel.add((IsWidget)artifactListView);
    }

    private Column<JarListPageRow, String> buildSelectColumn() {
        return new Column<JarListPageRow, String>((Cell)new ButtonCell(ButtonSize.EXTRA_SMALL)){
            {
                this.setFieldUpdater((FieldUpdater)new FieldUpdater<JarListPageRow, String>(){

                    public void update(int index, JarListPageRow row, String value) {
                        ArtifactListWidgetView.this.presenter.onSelect(row.getPath());
                    }
                });
            }

            public String getValue(JarListPageRow row) {
                return ArtifactListWidgetView.this.getSelectColumnLabel();
            }
        };
    }

    private String getSelectColumnLabel() {
        return this.translationService.format("ArtifactListWidgetView.SelectColumnLabel", new Object[0]);
    }

    @Override
    public void clear() {
        this.filter.setText("");
    }
}

