/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.widget.config.process;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.TextBox;
import org.jboss.errai.ui.client.local.spi.TranslationService;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.kie.workbench.common.screens.server.management.client.widget.config.process.ProcessConfigPresenter;

@Dependent
@Templated
public class ProcessConfigView
extends Composite
implements ProcessConfigPresenter.View {
    private ProcessConfigPresenter presenter;
    private TranslationService translationService;
    @DataField(value="container-config-runtime-strategy-label")
    Element runtimeStrategyLabel = DOM.createLabel();
    @Inject
    @DataField(value="container-config-runtime-strategy-button")
    Button runtimeStrategy;
    @Inject
    @DataField(value="container-config-runtime-strategy-dropdown-menu")
    DropDownMenu runtimeStrategyDropdown;
    @DataField(value="container-config-kbase-name-form")
    Element kbaseForm = DOM.createDiv();
    @DataField(value="container-config-kbase-name-label")
    Element kbaseLabel = DOM.createLabel();
    @Inject
    @DataField(value="container-config-kbase-name-textbox")
    TextBox kbase;
    @DataField(value="container-config-ksession-name-form")
    Element ksessionForm = DOM.createDiv();
    @DataField(value="container-config-ksession-name-label")
    Element ksessionLabel = DOM.createLabel();
    @Inject
    @DataField(value="container-config-ksession-name-textbox")
    TextBox ksession;
    @DataField(value="container-config-merge-mode-label")
    Element mergeModeLabel = DOM.createLabel();
    @Inject
    @DataField(value="container-config-merge-mode-button")
    Button mergeMode;
    @Inject
    @DataField(value="container-config-merge-mode-dropdown-menu")
    DropDownMenu mergeModeDropdown;

    @Inject
    public ProcessConfigView(TranslationService translationService) {
        this.translationService = translationService;
    }

    public void init(ProcessConfigPresenter presenter) {
        this.presenter = presenter;
        List<String> runtimeStrategies = presenter.getRuntimeStrategies();
        this.runtimeStrategy.setText(runtimeStrategies.get(0));
        for (final String strategy : runtimeStrategies) {
            this.runtimeStrategyDropdown.add((Widget)new AnchorListItem(strategy){
                {
                    super(x0);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            ProcessConfigView.this.runtimeStrategy.setText(strategy);
                        }
                    });
                }
            });
        }
        List<String> mergeModes = presenter.getMergeModes();
        this.mergeMode.setText(mergeModes.get(0));
        for (final String merge : mergeModes) {
            this.mergeModeDropdown.add((Widget)new AnchorListItem(){
                {
                    this.setText(merge);
                    this.addClickHandler(new ClickHandler(){

                        public void onClick(ClickEvent event) {
                            ProcessConfigView.this.mergeMode.setText(merge);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void setContent(String runtimeStrategy, String kbase, String ksession, String mergeMode) {
        this.runtimeStrategy.setText(runtimeStrategy);
        this.kbase.setText(kbase);
        this.ksession.setText(ksession);
        this.mergeMode.setText(mergeMode);
        this.runtimeStrategy.setEnabled(true);
        this.kbase.setEnabled(true);
        this.ksession.setEnabled(true);
        this.mergeMode.setEnabled(true);
    }

    @Override
    public String getRuntimeStrategy() {
        return this.runtimeStrategy.getText();
    }

    @Override
    public void disable() {
        this.runtimeStrategy.setEnabled(false);
        this.kbase.setEnabled(false);
        this.ksession.setEnabled(false);
        this.mergeMode.setEnabled(false);
    }

    @Override
    public void clear() {
        this.kbase.setText("");
        this.ksession.setText("");
        this.runtimeStrategy.setText(this.presenter.getRuntimeStrategies().get(0));
        this.mergeMode.setText(this.presenter.getMergeModes().get(0));
    }

    @Override
    public String getKBase() {
        return this.kbase.getText();
    }

    @Override
    public String getKSession() {
        return this.ksession.getText();
    }

    @Override
    public String getMergeMode() {
        return this.mergeMode.getText();
    }

    @Override
    public TranslationService getTranslationService() {
        return this.translationService;
    }

    @Override
    public String getConfigPageTitle() {
        return this.translationService.format("ProcessConfigView.ConfigPageTitle", new Object[0]);
    }
}

