/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.wizard;

import java.util.ArrayList;
import java.util.HashMap;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.server.api.model.KieScannerStatus;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.RuleConfig;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.workbench.common.screens.server.management.client.events.ServerTemplateListRefresh;
import org.kie.workbench.common.screens.server.management.client.util.ContentChangeHandler;
import org.kie.workbench.common.screens.server.management.client.wizard.AbstractMultiPageWizard;
import org.kie.workbench.common.screens.server.management.client.wizard.config.process.ProcessConfigPagePresenter;
import org.kie.workbench.common.screens.server.management.client.wizard.container.NewContainerFormPresenter;
import org.kie.workbench.common.screens.server.management.client.wizard.template.NewTemplatePresenter;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.workbench.events.NotificationEvent;

@ApplicationScoped
public class NewServerTemplateWizard
extends AbstractMultiPageWizard {
    private NewTemplatePresenter newTemplatePresenter;
    private NewContainerFormPresenter newContainerFormPresenter;
    private ProcessConfigPagePresenter processConfigPagePresenter;
    private Caller<SpecManagementService> specManagementService;
    private Event<NotificationEvent> notification;
    private Event<ServerTemplateListRefresh> serverTemplateListRefreshEvent;

    public NewServerTemplateWizard() {
    }

    @Inject
    public NewServerTemplateWizard(final NewTemplatePresenter newTemplatePresenter, final NewContainerFormPresenter newContainerFormPresenter, ProcessConfigPagePresenter processConfigPagePresenter, Caller<SpecManagementService> specManagementService, Event<NotificationEvent> notification, Event<ServerTemplateListRefresh> serverTemplateListRefreshEvent) {
        this.newTemplatePresenter = newTemplatePresenter;
        this.newContainerFormPresenter = newContainerFormPresenter;
        this.processConfigPagePresenter = processConfigPagePresenter;
        this.specManagementService = specManagementService;
        this.notification = notification;
        this.serverTemplateListRefreshEvent = serverTemplateListRefreshEvent;
        ContentChangeHandler changePages = new ContentChangeHandler(){

            @Override
            public void onContentChange() {
                int currentSelectedPage = NewServerTemplateWizard.this.getSelectedPage();
                if (newTemplatePresenter.hasProcessCapability() && !newContainerFormPresenter.isEmpty()) {
                    if (NewServerTemplateWizard.this.pages.size() != 3) {
                        NewServerTemplateWizard.this.pages.clear();
                        NewServerTemplateWizard.this.pages.add(NewServerTemplateWizard.this.newTemplatePresenter);
                        NewServerTemplateWizard.this.pages.add(NewServerTemplateWizard.this.newContainerFormPresenter);
                        NewServerTemplateWizard.this.pages.add(NewServerTemplateWizard.this.processConfigPagePresenter);
                        NewServerTemplateWizard.this.view.setPageTitles(NewServerTemplateWizard.this.getPages());
                        NewServerTemplateWizard.this.checkPagesState();
                        NewServerTemplateWizard.this.view.selectPage(currentSelectedPage);
                    }
                } else if (NewServerTemplateWizard.this.pages.size() != 2) {
                    NewServerTemplateWizard.this.pages.clear();
                    NewServerTemplateWizard.this.pages.add(NewServerTemplateWizard.this.newTemplatePresenter);
                    NewServerTemplateWizard.this.pages.add(NewServerTemplateWizard.this.newContainerFormPresenter);
                    NewServerTemplateWizard.this.view.setPageTitles(NewServerTemplateWizard.this.getPages());
                    NewServerTemplateWizard.this.checkPagesState();
                    NewServerTemplateWizard.this.view.selectPage(currentSelectedPage > 1 ? 1 : currentSelectedPage);
                }
            }
        };
        this.newTemplatePresenter.addContentChangeHandler(changePages);
        this.newContainerFormPresenter.addContentChangeHandler(changePages);
        this.pages.add(this.newTemplatePresenter);
        this.pages.add(this.newContainerFormPresenter);
    }

    public void start() {
        this.newContainerFormPresenter.initialise();
        super.start();
    }

    public String getTitle() {
        return this.newTemplatePresenter.getView().getNewServerTemplateWizardTitle();
    }

    public int getPreferredHeight() {
        return 550;
    }

    public int getPreferredWidth() {
        return 800;
    }

    public void clear() {
        this.newTemplatePresenter.clear();
        this.newContainerFormPresenter.clear();
        this.processConfigPagePresenter.clear();
        this.pages.clear();
        this.pages.add(this.newTemplatePresenter);
        this.pages.add(this.newContainerFormPresenter);
    }

    public void close() {
        super.close();
        this.clear();
    }

    public void complete() {
        final ServerTemplate newServerTemplate = this.buildServerTemplate();
        ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<Void>(){

            public void callback(Void o) {
                NewServerTemplateWizard.this.notification.fire((Object)new NotificationEvent(NewServerTemplateWizard.this.newTemplatePresenter.getView().getNewServerTemplateWizardSaveSuccess(), NotificationEvent.NotificationType.SUCCESS));
                NewServerTemplateWizard.this.clear();
                NewServerTemplateWizard.super.complete();
                NewServerTemplateWizard.this.serverTemplateListRefreshEvent.fire((Object)new ServerTemplateListRefresh(newServerTemplate.getId()));
            }
        }, (ErrorCallback)new ErrorCallback<Object>(){

            public boolean error(Object o, Throwable throwable) {
                NewServerTemplateWizard.this.notification.fire((Object)new NotificationEvent(NewServerTemplateWizard.this.newTemplatePresenter.getView().getNewServerTemplateWizardSaveError(), NotificationEvent.NotificationType.ERROR));
                NewServerTemplateWizard.this.pageSelected(0);
                NewServerTemplateWizard.this.start();
                return false;
            }
        })).saveServerTemplate(newServerTemplate);
    }

    private ServerTemplate buildServerTemplate() {
        ArrayList<String> capabilities = new ArrayList<String>();
        HashMap capabilityConfig = new HashMap();
        HashMap<Capability, ContainerConfig> capabilityContainerConfig = new HashMap<Capability, ContainerConfig>();
        ArrayList<ContainerSpec> containersSpec = new ArrayList<ContainerSpec>();
        if (this.newTemplatePresenter.isProcessCapabilityChecked()) {
            capabilities.add(Capability.PROCESS.toString());
            if (!this.newContainerFormPresenter.isEmpty()) {
                capabilityContainerConfig.put(Capability.PROCESS, (ContainerConfig)this.processConfigPagePresenter.buildProcessConfig());
            }
        }
        capabilityContainerConfig.put(Capability.RULE, (ContainerConfig)new RuleConfig(null, KieScannerStatus.STOPPED));
        if (this.newTemplatePresenter.isRuleCapabilityChecked()) {
            capabilities.add(Capability.RULE.toString());
        }
        if (this.newTemplatePresenter.isPlanningCapabilityChecked()) {
            capabilities.add(Capability.PLANNING.toString());
        }
        if (!this.newContainerFormPresenter.isEmpty()) {
            containersSpec.add(this.newContainerFormPresenter.buildContainerSpec(this.newTemplatePresenter.getTemplateName(), capabilityContainerConfig));
        }
        return new ServerTemplate(this.newTemplatePresenter.getTemplateName(), this.newTemplatePresenter.getTemplateName(), capabilities, capabilityConfig, containersSpec);
    }
}

