/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.wizard.container;

import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.guvnor.common.services.project.model.GAV;
import org.guvnor.m2repo.service.M2RepoService;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.server.api.model.KieContainerStatus;
import org.kie.server.api.model.ReleaseId;
import org.kie.server.controller.api.model.spec.Capability;
import org.kie.server.controller.api.model.spec.ContainerConfig;
import org.kie.server.controller.api.model.spec.ContainerSpec;
import org.kie.server.controller.api.model.spec.ServerTemplate;
import org.kie.server.controller.api.model.spec.ServerTemplateKey;
import org.kie.workbench.common.screens.server.management.client.events.DependencyPathSelectedEvent;
import org.kie.workbench.common.screens.server.management.client.util.ContentChangeHandler;
import org.kie.workbench.common.screens.server.management.client.widget.artifact.ArtifactListWidgetPresenter;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.slf4j.Logger;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class NewContainerFormPresenter
implements WizardPage {
    private final Logger logger;
    private final View view;
    private final Caller<M2RepoService> m2RepoService;
    private final Caller<SpecManagementService> specManagementService;
    private final Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;
    private final ManagedInstance<ArtifactListWidgetPresenter> artifactListWidgetPresenterProvider;
    private ArtifactListWidgetPresenter artifactListWidgetPresenter;
    private ServerTemplate serverTemplate;
    private Mode mode = Mode.OPTIONAL;

    @Inject
    public NewContainerFormPresenter(Logger logger, View view, ManagedInstance<ArtifactListWidgetPresenter> artifactListWidgetPresenterProvider, Caller<M2RepoService> m2RepoService, Caller<SpecManagementService> specManagementService, Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent) {
        this.logger = logger;
        this.view = view;
        this.artifactListWidgetPresenterProvider = artifactListWidgetPresenterProvider;
        this.m2RepoService = m2RepoService;
        this.specManagementService = specManagementService;
        this.wizardPageStatusChangeEvent = wizardPageStatusChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
        this.view.addContentChangeHandler(new ContentChangeHandler(){

            @Override
            public void onContentChange() {
                NewContainerFormPresenter.this.wizardPageStatusChangeEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)NewContainerFormPresenter.this));
            }
        });
    }

    public void addContentChangeHandler(ContentChangeHandler contentChangeHandler) {
        this.view.addContentChangeHandler((ContentChangeHandler)PortablePreconditions.checkNotNull((String)"contentChangeHandler", (Object)contentChangeHandler));
    }

    public String getTitle() {
        return this.view.getTitle();
    }

    public void isComplete(final Callback<Boolean> callback) {
        if (this.isValid()) {
            if (this.serverTemplate == null) {
                callback.callback((Object)true);
            } else {
                ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<Boolean>(){

                    public void callback(Boolean result) {
                        if (result.equals(Boolean.FALSE)) {
                            NewContainerFormPresenter.this.view.errorOnContainerName(NewContainerFormPresenter.this.view.getInvalidErrorMessage());
                        }
                        callback.callback((Object)result);
                    }
                })).isContainerIdValid(this.serverTemplate.getId(), this.view.getContainerName());
            }
        } else {
            callback.callback((Object)false);
        }
    }

    public void initialise() {
        if (this.artifactListWidgetPresenter != null) {
            this.artifactListWidgetPresenter.clear();
        }
    }

    public void prepareView() {
    }

    public Mode getMode() {
        return this.mode;
    }

    public Widget asWidget() {
        if (this.artifactListWidgetPresenter == null) {
            this.artifactListWidgetPresenter = (ArtifactListWidgetPresenter)this.artifactListWidgetPresenterProvider.get();
            this.view.setArtifactListWidgetView(this.artifactListWidgetPresenter.getView());
        }
        return this.view.asWidget();
    }

    public void setServerTemplate(ServerTemplate serverTemplate) {
        this.serverTemplate = serverTemplate;
        this.mode = Mode.MANDATORY;
    }

    public void clear() {
        this.serverTemplate = null;
        this.mode = Mode.OPTIONAL;
        this.view.clear();
    }

    void onDependencyPathSelectedEvent(@Observes DependencyPathSelectedEvent event) {
        if (event != null && event.getContext() != null && event.getPath() != null) {
            if (event.getContext().equals(this.artifactListWidgetPresenter)) {
                ((M2RepoService)this.m2RepoService.call((RemoteCallback)new RemoteCallback<GAV>(){

                    public void callback(GAV gav) {
                        NewContainerFormPresenter.this.setAValidContainerName(gav.toString());
                        NewContainerFormPresenter.this.view.setGroupId(gav.getGroupId());
                        NewContainerFormPresenter.this.view.setArtifactId(gav.getArtifactId());
                        NewContainerFormPresenter.this.view.setVersion(gav.getVersion());
                        NewContainerFormPresenter.this.wizardPageStatusChangeEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)NewContainerFormPresenter.this));
                    }
                })).loadGAVFromJar(event.getPath());
            }
        } else {
            this.logger.warn("Illegal event argument.");
        }
    }

    private void setAValidContainerName(String containerId) {
        if (this.view.getContainerName().isEmpty()) {
            ((SpecManagementService)this.specManagementService.call(validContainerId -> {
                this.view.setContainerName((String)validContainerId);
                this.wizardPageStatusChangeEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)this));
            })).validContainerId(this.serverTemplate.getId(), containerId);
        }
    }

    public boolean isContainerNameValid() {
        if (this.mode.equals((Object)Mode.OPTIONAL) && this.isEmpty()) {
            return true;
        }
        return !this.view.getContainerName().trim().isEmpty();
    }

    public boolean isGroupIdValid() {
        if (this.mode.equals((Object)Mode.OPTIONAL) && this.isEmpty()) {
            return true;
        }
        return !this.view.getGroupId().trim().isEmpty();
    }

    public boolean isArtifactIdValid() {
        if (this.mode.equals((Object)Mode.OPTIONAL) && this.isEmpty()) {
            return true;
        }
        return !this.view.getArtifactId().trim().isEmpty();
    }

    public boolean isVersionValid() {
        if (this.mode.equals((Object)Mode.OPTIONAL) && this.isEmpty()) {
            return true;
        }
        return !this.view.getVersion().trim().isEmpty();
    }

    public boolean isValid() {
        if (this.mode.equals((Object)Mode.OPTIONAL) && this.isEmpty()) {
            this.view.noErrors();
            return true;
        }
        boolean hasError = false;
        if (this.isContainerNameValid()) {
            this.view.noErrorOnContainerName();
        } else {
            this.view.errorOnContainerName();
            hasError = true;
        }
        if (this.isGroupIdValid()) {
            this.view.noErrorOnGroupId();
        } else {
            this.view.errorOnGroupId();
            hasError = true;
        }
        if (this.isArtifactIdValid()) {
            this.view.noErrorOnArtifactId();
        } else {
            this.view.errorOnArtifactId();
            hasError = true;
        }
        if (this.isVersionValid()) {
            this.view.noErrorOnVersion();
        } else {
            this.view.errorOnVersion();
            hasError = true;
        }
        return !hasError;
    }

    public boolean isEmpty() {
        return this.view.getContainerName().trim().isEmpty() && this.view.getGroupId().trim().isEmpty() && this.view.getArtifactId().trim().isEmpty() && this.view.getVersion().trim().isEmpty();
    }

    public ServerTemplate getServerTemplate() {
        return this.serverTemplate;
    }

    public ContainerSpec buildContainerSpec(String serverTemplateId, Map<Capability, ContainerConfig> configs) {
        return new ContainerSpec(this.view.getContainerName(), this.view.getContainerAlias(), new ServerTemplateKey(serverTemplateId, null), new ReleaseId(this.view.getGroupId(), this.view.getArtifactId(), this.view.getVersion()), KieContainerStatus.STOPPED, configs);
    }

    public View getView() {
        return this.view;
    }

    public static enum Mode {
        OPTIONAL,
        MANDATORY;

    }

    public static interface View
    extends UberView<NewContainerFormPresenter> {
        public String getTitle();

        public void addContentChangeHandler(ContentChangeHandler var1);

        public void setGroupId(String var1);

        public void setArtifactId(String var1);

        public void setVersion(String var1);

        public void setContainerName(String var1);

        public String getContainerName();

        public String getContainerAlias();

        public String getGroupId();

        public String getArtifactId();

        public String getVersion();

        public void errorOnContainerName();

        public void errorOnContainerName(String var1);

        public void errorOnGroupId();

        public void errorOnArtifactId();

        public void errorOnVersion();

        public void setArtifactListWidgetView(ArtifactListWidgetPresenter.View var1);

        public void clear();

        public void noErrors();

        public void noErrorOnContainerName();

        public void noErrorOnGroupId();

        public void noErrorOnArtifactId();

        public void noErrorOnVersion();

        public String getInvalidErrorMessage();

        public String getNewContainerWizardTitle();

        public String getNewContainerWizardSaveSuccess();

        public String getNewContainerWizardSaveError();
    }
}

