/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.screens.server.management.client.wizard.template;

import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.kie.workbench.common.screens.server.management.client.util.ContentChangeHandler;
import org.kie.workbench.common.screens.server.management.service.SpecManagementService;
import org.uberfire.client.callbacks.Callback;
import org.uberfire.client.mvp.UberView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.ext.widgets.core.client.wizards.WizardPage;
import org.uberfire.ext.widgets.core.client.wizards.WizardPageStatusChangeEvent;

@Dependent
public class NewTemplatePresenter
implements WizardPage {
    private final View view;
    private final Caller<SpecManagementService> specManagementService;
    private final Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent;

    public boolean hasProcessCapability() {
        return this.view.getProcessCapabilityCheck();
    }

    public String getTemplateName() {
        return this.view.getTemplateName();
    }

    @Inject
    public NewTemplatePresenter(View view, Caller<SpecManagementService> specManagementService, Event<WizardPageStatusChangeEvent> wizardPageStatusChangeEvent) {
        this.view = view;
        this.specManagementService = specManagementService;
        this.wizardPageStatusChangeEvent = wizardPageStatusChangeEvent;
    }

    @PostConstruct
    public void init() {
        this.view.init(this);
    }

    public String getTitle() {
        return this.view.getTitle();
    }

    public void isComplete(final Callback<Boolean> callback) {
        if (this.isValid()) {
            ((SpecManagementService)this.specManagementService.call((RemoteCallback)new RemoteCallback<Boolean>(){

                public void callback(Boolean result) {
                    if (result.equals(Boolean.FALSE)) {
                        NewTemplatePresenter.this.view.errorOnTemplateName(NewTemplatePresenter.this.view.getInvalidErrorMessage());
                        callback.callback((Object)false);
                    } else {
                        callback.callback((Object)true);
                    }
                }
            })).isNewServerTemplateIdValid(this.view.getTemplateName());
        } else {
            callback.callback((Object)false);
        }
    }

    public void addContentChangeHandler(final ContentChangeHandler contentChangeHandler) {
        PortablePreconditions.checkNotNull((String)"contentChangeHandler", (Object)contentChangeHandler);
        this.view.addContentChangeHandler(new ContentChangeHandler(){

            @Override
            public void onContentChange() {
                contentChangeHandler.onContentChange();
                NewTemplatePresenter.this.wizardPageStatusChangeEvent.fire((Object)new WizardPageStatusChangeEvent((WizardPage)NewTemplatePresenter.this));
            }
        });
    }

    public void initialise() {
    }

    public void prepareView() {
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public boolean isValid() {
        boolean hasError = false;
        if (this.isTemplateNameValid()) {
            this.view.noErrorOnTemplateName();
        } else {
            this.view.errorOnTemplateName();
            hasError = true;
        }
        if (this.isCapabilityValid()) {
            this.view.noErrorOnCapability();
        } else {
            this.view.errorCapability();
            hasError = true;
        }
        return !hasError;
    }

    public boolean isTemplateNameValid() {
        String templateName = this.view.getTemplateName();
        return templateName == null ? false : !templateName.trim().isEmpty();
    }

    public boolean isCapabilityValid() {
        if (this.view.isPlanningCapabilityChecked() && this.view.isRuleCapabilityChecked()) {
            return true;
        }
        return this.view.isProcessCapabilityChecked() || this.view.isRuleCapabilityChecked();
    }

    public void clear() {
        this.view.clear();
    }

    public boolean isRuleCapabilityChecked() {
        return this.view.isRuleCapabilityChecked();
    }

    public boolean isProcessCapabilityChecked() {
        return this.view.isProcessCapabilityChecked();
    }

    public boolean isPlanningCapabilityChecked() {
        return this.view.isPlanningCapabilityChecked();
    }

    public View getView() {
        return this.view;
    }

    public static interface View
    extends UberView<NewTemplatePresenter> {
        public String getTitle();

        public void clear();

        public void addContentChangeHandler(ContentChangeHandler var1);

        public boolean getProcessCapabilityCheck();

        public String getTemplateName();

        public boolean isRuleCapabilityChecked();

        public boolean isProcessCapabilityChecked();

        public boolean isPlanningCapabilityChecked();

        public void errorOnTemplateName();

        public void errorOnTemplateName(String var1);

        public void noErrorOnTemplateName();

        public void errorCapability();

        public void noErrorOnCapability();

        public void noErrors();

        public String getInvalidErrorMessage();

        public String getNewServerTemplateWizardTitle();

        public String getNewServerTemplateWizardSaveSuccess();

        public String getNewServerTemplateWizardSaveError();
    }
}

