/*
 * Decompiled with CFR 0.152.
 */
package org.kikermo.bleserver.bluez.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.bluez.GattApplication1;
import org.bluez.GattCharacteristic1;
import org.bluez.GattManager1;
import org.bluez.GattService1;
import org.bluez.LEAdvertisingManager1;
import org.freedesktop.dbus.DBusPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.dbus.interfaces.DBus;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.interfaces.ObjectManager;
import org.freedesktop.dbus.interfaces.Properties;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.types.Variant;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kikermo.bleserver.BLECharacteristic;
import org.kikermo.bleserver.BLEConnectionListener;
import org.kikermo.bleserver.BLEService;
import org.kikermo.bleserver.bluez.internal.BluezBLEConnector;
import org.kikermo.bleserver.internal.BLEPropertiesKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 )2\u00020\u0001:\u0001)B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u00112\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017J&\u0010\u0018\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J.\u0010\u001b\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0011H\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0013H\u0002J\u000e\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0013J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0013H\u0002J\u001e\u0010%\u001a\u00020&2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0014\u001a\u00020\u0013H\u0002J\b\u0010'\u001a\u00020\u0013H\u0002J\u0012\u0010(\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/kikermo/bleserver/bluez/internal/BluezBLEConnector;", "", "<init>", "()V", "dbusConnector", "Lorg/freedesktop/dbus/connections/impl/DBusConnection;", "kotlin.jvm.PlatformType", "Lorg/freedesktop/dbus/connections/impl/DBusConnection;", "interfacesAddedSignalHandler", "Lorg/freedesktop/dbus/interfaces/DBusSigHandler;", "Lorg/freedesktop/dbus/interfaces/ObjectManager$InterfacesAdded;", "interfacesRemovedSignalHandler", "Lorg/freedesktop/dbus/interfaces/ObjectManager$InterfacesRemoved;", "startServices", "", "bleServices", "", "Lorg/kikermo/bleserver/BLEService;", "adapterAlias", "", "serverName", "primaryService", "listener", "Lorg/kikermo/bleserver/BLEConnectionListener;", "registerAdvertisement", "advertisementManager", "Lorg/bluez/LEAdvertisingManager1;", "registerGattService", "gattManager", "Lorg/bluez/GattManager1;", "applicationName", "gattService1", "Lorg/bluez/GattService1;", "bleService", "stopServices", "unRegisterAdvertisement", "path", "getAdvertisementProperties", "Lorg/freedesktop/dbus/interfaces/DBusInterface;", "findAdapterPath", "initInterfacesHandler", "Companion", "ble-server-bluez"})
@SourceDebugExtension(value={"SMAP\nBluezBLEConnector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BluezBLEConnector.kt\norg/kikermo/bleserver/bluez/internal/BluezBLEConnector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,347:1\n1863#2:348\n1863#2,2:349\n1864#2:351\n1863#2:352\n1863#2,2:353\n1864#2:355\n774#2:360\n865#2,2:361\n1863#2,2:363\n13346#3,2:356\n13346#3,2:358\n*S KotlinDebug\n*F\n+ 1 BluezBLEConnector.kt\norg/kikermo/bleserver/bluez/internal/BluezBLEConnector\n*L\n105#1:348\n116#1:349,2\n105#1:351\n140#1:352\n142#1:353,2\n140#1:355\n328#1:360\n328#1:361,2\n328#1:363,2\n205#1:356,2\n210#1:358,2\n*E\n"})
public final class BluezBLEConnector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final DBusConnection dbusConnector = DBusConnectionBuilder.forSystemBus().build();
    private DBusSigHandler<ObjectManager.InterfacesAdded> interfacesAddedSignalHandler;
    private DBusSigHandler<ObjectManager.InterfacesRemoved> interfacesRemovedSignalHandler;
    @NotNull
    private static final String DBUS_BUSNAME = "org.freedesktop.DBus";
    @NotNull
    private static final String BLUEZ_DBUS_BUS_NAME = "org.bluez";
    @NotNull
    private static final String BLUEZ_GATT_INTERFACE = "org.bluez.GattManager1";
    @NotNull
    private static final String BLUEZ_LE_ADV_INTERFACE = "org.bluez.LEAdvertisingManager1";
    @NotNull
    private static final String BLUEZ_ADAPTER_INTERFACE = "org.bluez.Adapter1";
    @NotNull
    private static final String BLUEZ_DEVICE_INTERFACE = "org.bluez.Device1";
    @NotNull
    private static final String PATH_DBUS_DIVIDER = "/";
    @NotNull
    private static final String PATH_ADVERTISEMENT_SUFFIX = "/advertisement";
    @NotNull
    private static final String GATT_SERVICE_INTERFACE = "org.bluez.GattService1";

    public final void startServices(@NotNull List<BLEService> bleServices, @Nullable String adapterAlias, @NotNull String serverName, @NotNull BLEService primaryService, @Nullable BLEConnectionListener listener) {
        Intrinsics.checkNotNullParameter(bleServices, (String)"bleServices");
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        Intrinsics.checkNotNullParameter((Object)primaryService, (String)"primaryService");
        String adapterPath = this.findAdapterPath();
        DBusInterface dBusInterface = this.dbusConnector.getRemoteObject(BLUEZ_DBUS_BUS_NAME, adapterPath, Properties.class);
        Intrinsics.checkNotNull((Object)dBusInterface, (String)"null cannot be cast to non-null type org.freedesktop.dbus.interfaces.Properties");
        Properties adapterProperties = (Properties)dBusInterface;
        adapterProperties.Set(BLUEZ_ADAPTER_INTERFACE, "Powered", (Object)new Variant((Object)true));
        if (adapterAlias != null) {
            adapterProperties.Set(BLUEZ_ADAPTER_INTERFACE, "Alias", (Object)new Variant((Object)adapterAlias));
        }
        DBusInterface dBusInterface2 = this.dbusConnector.getRemoteObject(BLUEZ_DBUS_BUS_NAME, adapterPath, GattManager1.class);
        Intrinsics.checkNotNull((Object)dBusInterface2, (String)"null cannot be cast to non-null type org.bluez.GattManager1");
        GattManager1 gattManager = (GattManager1)dBusInterface2;
        DBusInterface dBusInterface3 = this.dbusConnector.getRemoteObject(BLUEZ_DBUS_BUS_NAME, adapterPath, LEAdvertisingManager1.class);
        Intrinsics.checkNotNull((Object)dBusInterface3, (String)"null cannot be cast to non-null type org.bluez.LEAdvertisingManager1");
        LEAdvertisingManager1 advManager = (LEAdvertisingManager1)dBusInterface3;
        this.registerAdvertisement(bleServices, serverName, advManager);
        this.registerGattService(bleServices, gattManager, serverName, primaryService);
        this.initInterfacesHandler(listener);
    }

    public static /* synthetic */ void startServices$default(BluezBLEConnector bluezBLEConnector, List list, String string, String string2, BLEService bLEService, BLEConnectionListener bLEConnectionListener, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        bluezBLEConnector.startServices(list, string, string2, bLEService, bLEConnectionListener);
    }

    private final void registerAdvertisement(List<BLEService> bleServices, String serverName, LEAdvertisingManager1 advertisementManager) {
        DBusInterface advertisementProperties = this.getAdvertisementProperties(bleServices, serverName);
        this.dbusConnector.exportObject(advertisementProperties);
        advertisementManager.RegisterAdvertisement(advertisementProperties, MapsKt.emptyMap());
    }

    private final void registerGattService(List<BLEService> bleServices, GattManager1 gattManager, String applicationName, BLEService primaryService) {
        Map map;
        Map $this$registerGattService_u24lambda_u242 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        Iterable $this$forEach$iv = bleServices;
        boolean bl2 = false;
        for (Object element$iv : $this$forEach$iv) {
            BLEService bleService = (BLEService)element$iv;
            boolean bl22 = false;
            DBusPath servicePath = BLEPropertiesKt.toPath(bleService, applicationName);
            boolean isPrimaryService = Intrinsics.areEqual((Object)bleService, (Object)primaryService);
            $this$registerGattService_u24lambda_u242.put(servicePath, BLEPropertiesKt.toProperties(bleService, isPrimaryService, applicationName));
            Iterable $this$forEach$iv2 = bleService.getCharacteristics();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                BLECharacteristic bleCharacteristic = (BLECharacteristic)element$iv2;
                boolean bl3 = false;
                String string = servicePath.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                DBusPath dBusPath = new DBusPath(BLEPropertiesKt.toPath(bleCharacteristic, string));
                String string2 = servicePath.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
                $this$registerGattService_u24lambda_u242.put(dBusPath, BLEPropertiesKt.toProperties(bleCharacteristic, string2));
            }
        }
        Map managedObject = MapsKt.build((Map)map);
        GattApplication1 gattApplication2 = new GattApplication1(applicationName, managedObject){
            final /* synthetic */ String $applicationName;
            final /* synthetic */ Map<DBusPath, Map<String, Map<String, Variant<?>>>> $managedObject;
            {
                this.$applicationName = $applicationName;
                this.$managedObject = $managedObject;
            }

            public boolean isRemote() {
                return false;
            }

            public String getObjectPath() {
                return "/" + this.$applicationName;
            }

            public Map<DBusPath, Map<String, Map<String, Variant<?>>>> GetManagedObjects() {
                System.out.println((Object)"Application -> GetManagedObjects");
                return this.$managedObject;
            }
        };
        Iterable $this$forEach$iv3 = bleServices;
        boolean $i$f$forEach3 = false;
        for (Object t : $this$forEach$iv3) {
            BLEService bleService = (BLEService)t;
            boolean bl4 = false;
            GattService1 gattService = this.gattService1(bleService, applicationName);
            Iterable $this$forEach$iv4 = bleService.getCharacteristics();
            boolean $i$f$forEach4 = false;
            for (Object element$iv3 : $this$forEach$iv4) {
                BLECharacteristic bleCharacteristic = (BLECharacteristic)element$iv3;
                boolean bl5 = false;
                String string = gattService.getObjectPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getObjectPath(...)");
                Map<String, Map<String, Variant<?>>> characteristicProperties = BLEPropertiesKt.toProperties(bleCharacteristic, string);
                GattCharacteristic1 gattCharacteristic2 = new GattCharacteristic1(bleCharacteristic, bleService, applicationName, characteristicProperties, this){
                    final /* synthetic */ BLECharacteristic $bleCharacteristic;
                    final /* synthetic */ BLEService $bleService;
                    final /* synthetic */ String $applicationName;
                    final /* synthetic */ Map<String, Map<String, Variant<?>>> $characteristicProperties;
                    final /* synthetic */ BluezBLEConnector this$0;
                    {
                        this.$bleCharacteristic = $bleCharacteristic;
                        this.$bleService = $bleService;
                        this.$applicationName = $applicationName;
                        this.$characteristicProperties = $characteristicProperties;
                        this.this$0 = $receiver;
                    }

                    public String getObjectPath() {
                        String string = BLEPropertiesKt.toPath(this.$bleService, this.$applicationName).getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                        return BLEPropertiesKt.toPath(this.$bleCharacteristic, string);
                    }

                    public <A> A Get(String p0, String p1) {
                        Map<String, Variant<?>> map = this.$characteristicProperties.get(p0);
                        Object object = map != null && (map = map.get(p1)) != null ? map.getValue() : null;
                        if (object == null) {
                            throw new RuntimeException("No characteristic");
                        }
                        return (A)object;
                    }

                    public <A> void Set(String p0, String p1, A p2) {
                    }

                    public Map<String, Variant<?>> GetAll(String interfaceName) {
                        Intrinsics.checkNotNullParameter((Object)interfaceName, (String)"interfaceName");
                        if (Intrinsics.areEqual((Object)"org.bluez.GattCharacteristic1", (Object)interfaceName)) {
                            Map<String, Variant<?>> map = this.$characteristicProperties.get("org.bluez.GattCharacteristic1");
                            if (map == null) {
                                throw new RuntimeException("Interface [interface_name=" + interfaceName + "]");
                            }
                            return map;
                        }
                        throw new RuntimeException("Interface [interface_name=" + interfaceName + "]");
                    }

                    public byte[] ReadValue(Map<String, Variant<Object>> option) {
                        return this.$bleCharacteristic.getValue();
                    }

                    public void WriteValue(byte[] value, Map<String, Variant<Object>> option) {
                        block1: {
                            if (value == null) {
                                return;
                            }
                            BLECharacteristic.AccessType.Write write = this.$bleCharacteristic.getWriteAccess();
                            if (write == null) break block1;
                            BLECharacteristic.AccessType.Write it = write;
                            boolean bl = false;
                            it.getOnValueChangedListener().invoke((Object)value);
                        }
                    }

                    public void StartNotify() {
                        if (this.$bleCharacteristic.getNotifyAccess() == null) {
                            return;
                        }
                        this.$bleCharacteristic.setOnValueChanged(arg_0 -> registerGattService.1.1.gattCharacteristic.1.StartNotify$lambda$1(this, this.this$0, arg_0));
                    }

                    public void StopNotify() {
                        this.$bleCharacteristic.setOnValueChanged(null);
                    }

                    private static final Unit StartNotify$lambda$1(registerGattService.1.1.gattCharacteristic.1 this$0, BluezBLEConnector this$1, byte[] value) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)this$1, (String)"this$1");
                        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                        Properties.PropertiesChanged signal = new Properties.PropertiesChanged(this$0.getObjectPath(), "org.bluez.GattCharacteristic1", MapsKt.mapOf((Pair)TuplesKt.to((Object)"Value", (Object)new Variant((Object)value))), CollectionsKt.emptyList());
                        BluezBLEConnector.access$getDbusConnector$p(this$1).sendMessage((Message)signal);
                        return Unit.INSTANCE;
                    }
                };
                this.dbusConnector.exportObject((DBusInterface)gattCharacteristic2);
            }
            this.dbusConnector.exportObject((DBusInterface)gattService);
        }
        this.dbusConnector.exportObject((DBusInterface)gattApplication2);
        Method[] methodArray = gattApplication2.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"getMethods(...)");
        Object[] $this$forEach$iv2 = methodArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Method it = (Method)element$iv;
            boolean bl6 = false;
            System.out.println((Object)it.getName());
            System.out.println((Object)it.toString());
        }
        Method[] methodArray2 = gattManager.getClass().getMethods();
        Intrinsics.checkNotNullExpressionValue((Object)methodArray2, (String)"getMethods(...)");
        $this$forEach$iv2 = methodArray2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv2) {
            Method it = (Method)element$iv;
            boolean bl7 = false;
            System.out.println((Object)it.getName());
            System.out.println((Object)it.toString());
        }
        gattManager.RegisterApplication(gattApplication2, new LinkedHashMap());
    }

    private final GattService1 gattService1(BLEService bleService, String applicationName) {
        String servicePath = BLEPropertiesKt.toPath(bleService, applicationName).getPath();
        Map<String, Map<String, Variant<?>>> serviceProperties = BLEPropertiesKt.toProperties(bleService, true, applicationName);
        return new GattService1(servicePath, serviceProperties){
            final /* synthetic */ String $servicePath;
            final /* synthetic */ Map<String, Map<String, Variant<?>>> $serviceProperties;
            {
                this.$servicePath = $servicePath;
                this.$serviceProperties = $serviceProperties;
            }

            public String getObjectPath() {
                String string = this.$servicePath;
                Intrinsics.checkNotNull((Object)string);
                return string;
            }

            public <A> A Get(String p0, String p1) {
                Map<String, Variant<?>> map = this.$serviceProperties.get(p0);
                Object object = map != null && (map = map.get(p1)) != null ? map.getValue() : null;
                if (object == null) {
                    throw new RuntimeException("Property not found on service");
                }
                return (A)object;
            }

            public <A> void Set(String p0, String p1, A p2) {
            }

            public Map<String, Variant<?>> GetAll(String interfaceName) {
                Intrinsics.checkNotNullParameter((Object)interfaceName, (String)"interfaceName");
                if (Intrinsics.areEqual((Object)"org.bluez.GattService1", (Object)interfaceName)) {
                    Map<String, Variant<?>> map = this.$serviceProperties.get("org.bluez.GattService1");
                    if (map == null) {
                        throw new RuntimeException("No org.bluez.GattService1 found on service");
                    }
                    return map;
                }
                throw new RuntimeException("Interface " + interfaceName + " doesn't match org.bluez.GattService1");
            }
        };
    }

    public final void stopServices(@NotNull String serverName) {
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        String path = PATH_DBUS_DIVIDER + serverName;
        this.unRegisterAdvertisement(path);
    }

    private final void unRegisterAdvertisement(String path) {
        this.dbusConnector.unExportObject(path);
    }

    private final DBusInterface getAdvertisementProperties(List<BLEService> bleServices, String serverName) {
        return (DBusInterface)new Properties(bleServices, serverName){
            private final Map<String, Map<String, Variant<?>>> properties;
            final /* synthetic */ String $serverName;
            {
                this.$serverName = $serverName;
                this.properties = BLEPropertiesKt.toAdvertisementProperties($bleServices, $serverName);
            }

            public final Map<String, Map<String, Variant<?>>> getProperties() {
                return this.properties;
            }

            public String getObjectPath() {
                return "/" + this.$serverName + "/advertisement";
            }

            public void Release() {
                System.out.println((Object)"Release LE Server");
            }

            public <A> A Get(String interfaceName, String propertyName) {
                Intrinsics.checkNotNullParameter((Object)interfaceName, (String)"interfaceName");
                Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                Map<String, Variant<?>> map = this.properties.get(interfaceName);
                Variant<?> variant = map != null ? map.get(propertyName) : null;
                if (variant == null) {
                    variant = null;
                }
                if (variant == null) {
                    throw new RuntimeException("Incompatible types");
                }
                return (A)variant;
            }

            public <A> void Set(String interfaceName, String propertyName, A propertyValue) {
                block1: {
                    Intrinsics.checkNotNullParameter((Object)interfaceName, (String)"interfaceName");
                    Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
                    if (!(propertyValue instanceof Variant)) break block1;
                    Map<String, Variant<?>> map = this.properties.get(interfaceName);
                    if (map != null) {
                        map.put(propertyName, (Variant<?>)propertyValue);
                    }
                }
            }

            public Map<String, Variant<?>> GetAll(String interfaceName) {
                Intrinsics.checkNotNullParameter((Object)interfaceName, (String)"interfaceName");
                Map<String, Variant<?>> map = this.properties.get(interfaceName);
                if (map == null) {
                    throw new RuntimeException("Wrong interface [interface_name=" + interfaceName + "]");
                }
                return map;
            }
        };
    }

    private final String findAdapterPath() {
        DBusPath dBusPath;
        Object v1;
        Object object;
        block2: {
            DBusInterface dBusInterface = this.dbusConnector.getRemoteObject(BLUEZ_DBUS_BUS_NAME, PATH_DBUS_DIVIDER, ObjectManager.class);
            Intrinsics.checkNotNull((Object)dBusInterface, (String)"null cannot be cast to non-null type org.freedesktop.dbus.interfaces.ObjectManager");
            ObjectManager bluezObjectManager = (ObjectManager)dBusInterface;
            object = bluezObjectManager.GetManagedObjects().entrySet();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Object t = iterator.next();
                Map.Entry entry = (Map.Entry)t;
                boolean bl = false;
                if (!(((Map)entry.getValue()).containsKey(BLUEZ_LE_ADV_INTERFACE) && ((Map)entry.getValue()).containsKey(BLUEZ_GATT_INTERFACE))) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        Map.Entry entry = v1;
        if (entry == null || (dBusPath = (DBusPath)entry.getKey()) == null || (object = dBusPath.getPath()) == null) {
            throw new RuntimeException("No BLE adapter found");
        }
        return object;
    }

    private final void initInterfacesHandler(BLEConnectionListener listener) {
        DBusInterface dBusInterface = this.dbusConnector.getRemoteObject(DBUS_BUSNAME, "/or/freedesktop/DBus", DBus.class);
        Intrinsics.checkNotNullExpressionValue((Object)dBusInterface, (String)"getRemoteObject(...)");
        DBus dbus = (DBus)dBusInterface;
        String string = dbus.GetNameOwner(BLUEZ_DBUS_BUS_NAME);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"GetNameOwner(...)");
        String bluezDbusBusName = string;
        ObjectManager bluezObjectManager = (ObjectManager)this.dbusConnector.getRemoteObject(BLUEZ_DBUS_BUS_NAME, PATH_DBUS_DIVIDER, ObjectManager.class);
        this.interfacesAddedSignalHandler = arg_0 -> BluezBLEConnector.initInterfacesHandler$lambda$9(listener, arg_0);
        this.interfacesRemovedSignalHandler = arg_0 -> BluezBLEConnector.initInterfacesHandler$lambda$12(listener, arg_0);
        DBusInterface dBusInterface2 = (DBusInterface)bluezObjectManager;
        DBusSigHandler<ObjectManager.InterfacesAdded> dBusSigHandler = this.interfacesAddedSignalHandler;
        if (dBusSigHandler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"interfacesAddedSignalHandler");
            dBusSigHandler = null;
        }
        this.dbusConnector.addSigHandler(ObjectManager.InterfacesAdded.class, bluezDbusBusName, dBusInterface2, dBusSigHandler);
        DBusInterface dBusInterface3 = (DBusInterface)bluezObjectManager;
        DBusSigHandler<ObjectManager.InterfacesRemoved> dBusSigHandler2 = this.interfacesRemovedSignalHandler;
        if (dBusSigHandler2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"interfacesRemovedSignalHandler");
            dBusSigHandler2 = null;
        }
        this.dbusConnector.addSigHandler(ObjectManager.InterfacesRemoved.class, bluezDbusBusName, dBusInterface3, dBusSigHandler2);
    }

    private static final void initInterfacesHandler$lambda$9(BLEConnectionListener $listener, ObjectManager.InterfacesAdded signal) {
        block1: {
            Map iamap;
            Map map = iamap = (Map)signal.interfaces.get(BLUEZ_DEVICE_INTERFACE);
            if (map == null) break block1;
            Map it = map;
            boolean bl = false;
            Object v = it.get("Address");
            Intrinsics.checkNotNull(v, (String)"null cannot be cast to non-null type org.freedesktop.dbus.types.Variant<kotlin.String>");
            Variant address = (Variant)v;
            Object v2 = it.get("Alias");
            Intrinsics.checkNotNull(v2, (String)"null cannot be cast to non-null type org.freedesktop.dbus.types.Variant<kotlin.String>");
            Variant alias = (Variant)v2;
            if ($listener != null) {
                Object object = address.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getValue(...)");
                String string = (String)object;
                Object object2 = alias.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getValue(...)");
                String string2 = (String)object2;
                $listener.onDeviceConnected(string2, string);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void initInterfacesHandler$lambda$12(BLEConnectionListener $listener, ObjectManager.InterfacesRemoved signal) {
        void $this$filterTo$iv$iv;
        System.out.println((Object)signal.getName());
        List list = signal.interfaces;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"interfaces");
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)list, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        List list2 = signal.interfaces;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"interfaces");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it, (Object)BLUEZ_DEVICE_INTERFACE)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String ir = (String)element$iv;
            boolean bl = false;
            BLEConnectionListener bLEConnectionListener = $listener;
            if (bLEConnectionListener == null) continue;
            bLEConnectionListener.onDeviceDisconnected();
        }
    }

    public static final /* synthetic */ DBusConnection access$getDbusConnector$p(BluezBLEConnector $this) {
        return $this.dbusConnector;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/kikermo/bleserver/bluez/internal/BluezBLEConnector$Companion;", "", "<init>", "()V", "DBUS_BUSNAME", "", "BLUEZ_DBUS_BUS_NAME", "BLUEZ_GATT_INTERFACE", "BLUEZ_LE_ADV_INTERFACE", "BLUEZ_ADAPTER_INTERFACE", "BLUEZ_DEVICE_INTERFACE", "PATH_DBUS_DIVIDER", "PATH_ADVERTISEMENT_SUFFIX", "GATT_SERVICE_INTERFACE", "ble-server-bluez"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

