/*
 * Decompiled with CFR 0.152.
 */
package org.kikermo.bleserver;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kikermo.bleserver.BLEConnectionListener;
import org.kikermo.bleserver.BLEServerConnector;
import org.kikermo.bleserver.BLEService;
import org.kikermo.bleserver.exception.BLENoServicesException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R$\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u00068F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lorg/kikermo/bleserver/BLEServer;", "", "serverName", "", "services", "", "Lorg/kikermo/bleserver/BLEService;", "connectionListener", "Lorg/kikermo/bleserver/BLEConnectionListener;", "bleServerConnector", "Lorg/kikermo/bleserver/BLEServerConnector;", "<init>", "(Ljava/lang/String;Ljava/util/List;Lorg/kikermo/bleserver/BLEConnectionListener;Lorg/kikermo/bleserver/BLEServerConnector;)V", "selectedPrimaryService", "value", "primaryService", "getPrimaryService", "()Lorg/kikermo/bleserver/BLEService;", "setPrimaryService", "(Lorg/kikermo/bleserver/BLEService;)V", "start", "", "stop", "ble-server"})
public final class BLEServer {
    @NotNull
    private final String serverName;
    @NotNull
    private final List<BLEService> services;
    @Nullable
    private final BLEConnectionListener connectionListener;
    @NotNull
    private final BLEServerConnector bleServerConnector;
    @Nullable
    private BLEService selectedPrimaryService;

    public BLEServer(@NotNull String serverName, @NotNull List<BLEService> services, @Nullable BLEConnectionListener connectionListener, @NotNull BLEServerConnector bleServerConnector) {
        Intrinsics.checkNotNullParameter((Object)serverName, (String)"serverName");
        Intrinsics.checkNotNullParameter(services, (String)"services");
        Intrinsics.checkNotNullParameter((Object)bleServerConnector, (String)"bleServerConnector");
        this.serverName = serverName;
        this.services = services;
        this.connectionListener = connectionListener;
        this.bleServerConnector = bleServerConnector;
    }

    public /* synthetic */ BLEServer(String string, List list, BLEConnectionListener bLEConnectionListener, BLEServerConnector bLEServerConnector, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bLEConnectionListener = null;
        }
        this(string, list, bLEConnectionListener, bLEServerConnector);
    }

    @NotNull
    public final BLEService getPrimaryService() {
        BLEService bLEService = this.selectedPrimaryService;
        if (bLEService == null && (bLEService = (BLEService)CollectionsKt.firstOrNull(this.services)) == null) {
            throw new BLENoServicesException();
        }
        return bLEService;
    }

    public final void setPrimaryService(@NotNull BLEService value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.selectedPrimaryService = value;
    }

    public final void start() {
        BLEServerConnector bLEServerConnector = this.bleServerConnector;
        List<BLEService> list = this.services;
        BLEService bLEService = this.getPrimaryService();
        String string = this.serverName;
        BLEConnectionListener bLEConnectionListener = this.connectionListener;
        BLEServerConnector.DefaultImpls.startServices$default(bLEServerConnector, list, null, string, bLEService, bLEConnectionListener, 2, null);
    }

    public final void stop() {
        this.bleServerConnector.stopServices(this.serverName);
    }
}

