package org.kink_lang.kink.hostfun.graph.impl;

import org.kink_lang.kink.*;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToRecv;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToArgs;
import org.kink_lang.kink.hostfun.graph.GraphFacade;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.hostfun.HostContext;

/**
 * The implementation of GraphFacade.
 */
public class GraphFacadeImpl implements GraphFacade {

    /** The vm. */
    private final Vm vm;

    /** The sym handle of "format". */
    private int formatHandle;

    /** The sym handle of "repr". */
    private int reprHandle;

    /** The sym handle of "raise". */
    private int raiseHandle;

    /**
     * Constructs the facade with the vm.
     *
     * @param vm the vm.
     */
    public GraphFacadeImpl(Vm vm) {
        this.vm = vm;
    }

    /**
     * Initializses the facade.
     */
    public void init() {
        this.formatHandle = vm.sym.handleFor("format");
        this.reprHandle = vm.sym.handleFor("repr");
        this.raiseHandle = vm.sym.handleFor("raise");
    }

    @Override
    public GraphNode of(Val val) {
        return new ValGraphNode(val);
    }

    @Override
    public CallGraphNodeToRecv call(FunVal fun) {
        return new DirectCallGraph(vm, fun, vm.graph.of(vm.nada), new GraphNode[0]);
    }

    @Override
    public CallGraphNodeToRecv call(GraphNode owner, int symHandle) {
        return MethodCallGraph.withOwnerRecv(vm, owner, symHandle, new GraphNode[0]);
    }

    @Override
    public CallGraphNodeToArgs call(String modName, int symHandle) {
        return new ModCallGraph(vm, modName, symHandle, new GraphNode[0]);
    }

    @Override
    public GraphNode repr(Val val) {
        return call(of(val), reprHandle);
    }

    @Override
    public GraphNode format(String template, GraphNode... args) {
        GraphNode templateGraph = of(vm.str.of(template));
        return call(templateGraph, formatHandle).args(args);
    }

    @Override
    public GraphNode raiseFormat(String template, GraphNode... args) {
        GraphNode msgGraph = format(template, args);
        Val binding = vm.binding.newBinding();
        FunVal fun = vm.fun.make().action(
                c -> c.call(call(of(binding), raiseHandle).args(msgGraph)));
        // wrap the fun so that it is called as non-tail call,
        // in order to ensure that the stack trace is not overwritten
        FunVal caller = vm.fun.make().action(c -> c.call(fun).on(GraphFacadeImpl::id));
        return call(caller);
    }

    /**
     * Returns r.
     */
    static HostResult id(HostContext c, Val r) {
        return r;
    }

}

// vim: et sw=4 sts=4 fdm=marker
