package org.kink_lang.kink.internal.callstack;

/**
 * A position on a program; used in stack traces.
 *
 * @param programName the name of the program.
 * @param programText the program text.
 * @param pos         the pos on the program; adjusted to the range of the program text.
 */
public record Location(String programName, String programText, int pos) {

    /**
     * Constructs a location.
     *
     * @param programName the name of the program.
     * @param programText the program text.
     * @param pos         the pos on the program; adjusted to the range of the program text.
     */
    public Location {
        pos = Math.max(0, Math.min(pos, programText.length()));
    }

    /** Location with empty programName, empty programText and pos=0. */
    public static final Location EMPTY = new Location("", "", 0);

}

// vim: et sw=4 sts=4 fdm=marker
