package org.kink_lang.kink.internal.intrinsicsupport;

import java.util.Set;

import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;

/**
 * Accessor to preloaded funs.
 */
public final class PreloadedFuns {

    /**
     * Cannot instantiate.
     */
    private PreloadedFuns() {
    }

    /**
     * Returns the syms of control funs.
     *
     * <p>It must not contain "repr".
     * Because it is modified for the top level binding of mods.</p>
     *
     * @return the syms of control funs.
     */
    public static Set<String> controlSyms() {
        return Set.of(
                "if", "branch", "true", "false", "op_lognot", "op_logor", "op_logand", "new_val",
                "nada", "require", "raise", "stdin", "stdout", "stderr");
    }

    /**
     * Returns a preloaded fun.
     *
     * Precondition: the specified var must be a preloaded fun.
     *
     * @param vm the vm.
     * @param sym the sym of the var.
     * @return the var.
     */
    public static Val preloadedFun(Vm vm, String sym) {
        int symHandle = vm.sym.handleFor(sym);
        Val binding = vm.binding.newBinding();
        return binding.getVar(symHandle);
    }

}

// vim: et sw=4 sts=4 fdm=marker
