package org.kink_lang.kink.internal.program.ast;

/**
 * An elem of vec bodies or actual args.
 */
public sealed interface Elem permits Elem.Spread, Expr {

    /**
     * An element of a vec body spreading the expression.
     *
     * @param expr the expression in the elem.
     * @param pos the pos of the elem on the program text.
     */
    record Spread(Expr expr, int pos) implements Elem {}

    /**
     * Returns the pos of the elem on the program text.
     *
     * @return the pos of the elem on the program text.
     */
    int pos();

}

// vim: et sw=4 sts=4 fdm=marker
