package org.kink_lang.kink.internal.program.ast;

import java.util.List;

/**
 * An attributional call expression with an explicit recv.
 *
 * @param owner the owner-recv.
 * @param sym   the sym.
 * @param recv  the actual recv.
 * @param args  the actual args.
 * @param pos   the start pos of the node.
 */
public record RcallExpr(Expr owner, String sym,
                        Expr recv,
                        List<Elem> args, int pos) implements Expr {

    /**
     * Constructs an attributional call expression with an explicit recv.
     *
     * @param owner the owner-recv.
     * @param sym   the sym.
     * @param recv  the actual recv.
     * @param args  the actual args.
     * @param pos   the start pos of the node.
     */
    public RcallExpr {
        args = List.copyOf(args);
    }

    @Override
    public <T> T accept(ExprVisitor<T> visitor) {
        return visitor.visitRcall(this);
    }

}

// vim: et sw=4 sts=4 fdm=marker
