package org.kink_lang.kink.internal.program.itree;

import java.util.function.Function;

/**
 * An itree visitor with a default make.
 *
 * <p>The visit methods are supposed to be overridden by subclasses
 * where the default make is not appropriate.</p>
 *
 * @param <T> the type of the result.
 */
public class SkeltonItreeVisitor<T> implements ItreeVisitor<T> {

    /** The default make of the visitor. */
    private final Function<Itree, T> defaultAction;

    /**
     * Constructs a visitor.
     *
     * @param defaultAction the default make of visitor methods.
     */
    public SkeltonItreeVisitor(Function<Itree, T> defaultAction) {
        this.defaultAction = defaultAction;
    }

    @Override
    public T visit(BindingItree binding) {
        return defaultAction.apply(binding);
    }

    @Override
    public T visit(RecvItree recv) {
        return defaultAction.apply(recv);
    }

    @Override
    public T visit(ArgVecItree argVec) {
        return defaultAction.apply(argVec);
    }

    @Override
    public T visit(NumItree num) {
        return defaultAction.apply(num);
    }

    @Override
    public T visit(StrItree str) {
        return defaultAction.apply(str);
    }

    @Override
    public T visit(NadaItree nada) {
        return defaultAction.apply(nada);
    }

    @Override
    public T visit(SeqItree seq) {
        return defaultAction.apply(seq);
    }

    @Override
    public T visit(SlowFunItree fun) {
        return defaultAction.apply(fun);
    }

    @Override
    public T visit(FastFunItree fun) {
        return defaultAction.apply(fun);
    }

    @Override
    public T visit(VecItree vec) {
        return defaultAction.apply(vec);
    }

    @Override
    public T visit(DerefItree deref) {
        return defaultAction.apply(deref);
    }

    @Override
    public T visit(LderefItree lderef) {
        return defaultAction.apply(lderef);
    }

    @Override
    public T visit(VarrefItree varref) {
        return defaultAction.apply(varref);
    }

    @Override
    public T visit(LetRecItree letrec) {
        return defaultAction.apply(letrec);
    }

    @Override
    public T visit(AssignmentItree assignment) {
        return defaultAction.apply(assignment);
    }

    @Override
    public T visit(OptVecAssignmentItree assignment) {
        return defaultAction.apply(assignment);
    }

    @Override
    public T visit(OptRestVecAssignmentItree assignment) {
        return defaultAction.apply(assignment);
    }

    @Override
    public T visit(RestVecAssignmentItree assignment) {
        return defaultAction.apply(assignment);
    }

    @Override
    public T visit(NestedVecAssignmentItree assignment) {
        return defaultAction.apply(assignment);
    }

    @Override
    public T visit(VarrefVecAssignmentItree assignment) {
        return defaultAction.apply(assignment);
    }

    @Override
    public T visit(LstoreItree lstore) {
        return defaultAction.apply(lstore);
    }

    @Override
    public T visit(StoreItree store) {
        return defaultAction.apply(store);
    }

    @Override
    public T visit(ArgsPassingItree argsPassing) {
        return defaultAction.apply(argsPassing);
    }

    @Override
    public T visit(NestedArgsPassingItree nestedArgsPassing) {
        return defaultAction.apply(nestedArgsPassing);
    }

    @Override
    public T visit(BiArithmeticItree arithmetic) {
        return defaultAction.apply(arithmetic);
    }

    @Override
    public T visit(NoTraitNewValItree newVal) {
        return defaultAction.apply(newVal);
    }

    @Override
    public T visit(TraitNewValItree newVal) {
        return defaultAction.apply(newVal);
    }

    @Override
    public T visit(IfItree preloadedIf) {
        return defaultAction.apply(preloadedIf);
    }

    @Override
    public T visit(BranchItree branch) {
        return defaultAction.apply(branch);
    }

    @Override
    public T visit(BranchWithElseItree branch) {
        return defaultAction.apply(branch);
    }

    @Override
    public T visit(McallItree mcall) {
        return defaultAction.apply(mcall);
    }

    @Override
    public T visit(SymcallItree scall) {
        return defaultAction.apply(scall);
    }

}

// vim: et sw=4 sts=4 fdm=marker
