package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.function.Function;

import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;

/**
 * Factory of optimizers knowing enclosing fast fun environment.
 */
class FastFunAwareOptimizerFactory implements OptimizerFactory {

    /** The optimizer. */
    private final Function<? super Itree, ? extends Itree> optimizer;

    /** Makes an optimizer under an enclosing indexed fun. */
    private final
        Function<FastFunItree, ? extends Function<? super Itree, ? extends Itree>> makeSub;

    /**
     * Constructs a factory.
     */
    FastFunAwareOptimizerFactory(
            Function<? super Itree, ? extends Itree> optimizer,
            Function<FastFunItree, ? extends Function<? super Itree, ? extends Itree>> makeSub) {
        this.optimizer = optimizer;
        this.makeSub = makeSub;
    }

    @Override
    public OptimizerFactory makeFactory(FastFunItree enclosing) {
        Function<? super Itree, ? extends Itree> subOpt = makeSub.apply(enclosing);
        return new FastFunAwareOptimizerFactory(subOpt, makeSub);
    }

    @Override
    public Function<? super Itree, ? extends Itree> makeOptimizer() {
        return this.optimizer;
    }

}

// vim: et sw=4 sts=4 fdm=marker
