package org.kink_lang.kink.internal.program.itreeoptimize;

import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.OptRestVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.RestVecAssignmentItree;

/**
 * Optimizes {@code [:Rest.rest] <- xxx}  to RestVecAssignmentItree.
 */
public class RestVecAssignmentOptimizer extends BaseOptimizer {

    @Override
    public Itree visit(OptRestVecAssignmentItree itree) {
        return itree.mandatory().isEmpty() && itree.opt().isEmpty()
            ? new RestVecAssignmentItree(
                    itree.rest(), itree.rhs(), itree.pos())
            : itree;
    }

}

// vim: et sw=4 sts=4 fdm=marker
