package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.List;
import java.util.stream.Collectors;

import org.kink_lang.kink.internal.program.itree.*;

/**
 * Optimizes an assignment in the form {@code [X:Foo Y:Bar] <- Rhs} to VarrefVecAssignmentItree.
 */
public class VarrefVecAssignmentInliner extends BaseOptimizer {

    @Override
    public Itree visit(AssignmentItree assignment) {
        Itree lhs = assignment.lhs();
        if (! (lhs instanceof VecItree)) {
            return assignment;
        }

        VecItree lhsVec = (VecItree) lhs;
        List<ItreeElem> lhsElems = lhsVec.elems();
        if (! lhsElems.stream().allMatch(ItreeElem::isSingle)) {
            return assignment;
        }

        List<Itree> lhsExprs = lhsElems.stream()
            .map(ItreeElem::expr)
            .collect(Collectors.toList());
        if (! lhsExprs.stream().allMatch(expr -> expr instanceof VarrefItree)) {
            return assignment;
        }

        List<VarrefParam> params = lhsExprs.stream()
            .map(expr -> (VarrefItree) expr)
            .map(varref -> new GenericVar(varref.owner(), varref.sym()))
            .collect(Collectors.toList());
        return new VarrefVecAssignmentItree(params, assignment.rhs(), assignment.pos());
    }

}

// vim: et sw=4 sts=4 fdm=marker
