/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.kink_lang.kink.BindingVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.intrinsicsupport.BranchSupport;
import org.kink_lang.kink.internal.intrinsicsupport.IfSupport;
import org.kink_lang.kink.internal.intrinsicsupport.NewValSupport;

public class BindingHelper {
    private final Vm vm;
    SharedVars sharedVars;
    private static final String BRANCH_DESC = "branch(...[$cond1 $then1 $cond2 $then2 ,,,])";

    BindingHelper(Vm vm) {
        this.vm = vm;
    }

    void init() {
        int stdoutHandle = this.vm.sym.handleFor("stdout");
        int stdinHandle = this.vm.sym.handleFor("stdin");
        int stderrHandle = this.vm.sym.handleFor("stderr");
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        vars.put(this.vm.sym.handleFor("nada"), this.vm.fun.constant(this.vm.nada));
        vars.put(this.vm.sym.handleFor("true"), this.vm.fun.constant(this.vm.bool.trueVal));
        vars.put(this.vm.sym.handleFor("false"), this.vm.fun.constant(this.vm.bool.falseVal));
        vars.put(this.vm.sym.handleFor("new_val"), this.vm.fun.make("new_val(...[Sym1 Val1 Sym2 Val2 ,,,])").action(this::newValFun));
        vars.put(this.vm.sym.handleFor("require"), this.vm.fun.make("require(Mod_name ...[$config])").takeMinMax(1, 2).action(this::requireFun));
        vars.put(this.vm.sym.handleFor("raise"), this.vm.fun.make("raise(Msg)").take(1).action(this::raiseFun));
        vars.put(this.vm.sym.handleFor("op_lognot"), this.vm.fun.make("op_lognot(Bool)").take(1).action(this::opLogNotFun));
        vars.put(this.vm.sym.handleFor("op_logor"), this.vm.fun.make("op_logor(Bool $thunk)").take(2).action(this::opLogOrFun));
        vars.put(this.vm.sym.handleFor("op_logand"), this.vm.fun.make("op_logand(Bool $thunk)").take(2).action(this::opLogAndFun));
        vars.put(this.vm.sym.handleFor("if"), this.vm.fun.make("if(Bool $true_cont ...[$false_cont={}])").takeMinMax(2, 3).action(this::ifFun));
        vars.put(this.vm.sym.handleFor("branch"), this.vm.fun.make(BRANCH_DESC).action(this::branchFun));
        vars.put(stdinHandle, this.vm.fun.make("stdin").take(0).action(c -> c.call("kink/_io/STDIO", stdinHandle)));
        vars.put(stdoutHandle, this.vm.fun.make("stdout").take(0).action(c -> c.call("kink/_io/STDIO", stdoutHandle)));
        vars.put(stderrHandle, this.vm.fun.make("stderr").take(0).action(c -> c.call("kink/_io/STDIO", stderrHandle)));
        vars.put(this.vm.sym.handleFor("repr"), this.vm.fun.make("Binding.repr").take(0).action(c -> this.vm.str.of(String.format(Locale.ROOT, "(binding val_id=%d)", c.recv().identity()))));
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    public BindingVal newBinding() {
        return new BindingVal(this.vm);
    }

    private HostResult newValFun(CallContext c) {
        int argCount = c.argCount();
        if (argCount % 2 != 0) {
            return c.call(NewValSupport.oddNumbefOfArgs(this.vm, argCount));
        }
        Val val = this.vm.newVal();
        for (int i = 0; i < argCount; i += 2) {
            Val symVal = c.arg(i);
            if (!(symVal instanceof StrVal)) {
                return c.call(NewValSupport.symNotStr(this.vm, i, symVal));
            }
            StrVal sym = (StrVal)symVal;
            val.setVar(this.vm.sym.handleFor(sym.string()), c.arg(i + 1));
        }
        return val;
    }

    private HostResult requireFun(CallContext c) throws Throwable {
        Val modNameVal = c.arg(0);
        if (!(modNameVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("require(Mod_name ...[$config]): Mod_name must be a str, but got {}", this.vm.graph.repr(modNameVal)));
        }
        String modName = ((StrVal)modNameVal).string();
        if (c.argCount() == 1) {
            return this.vm.mod.require(c, modName, null, null, null);
        }
        Val config = c.arg(1);
        FunVal cont = this.vm.fun.make().take(3).action(cc -> this.requireWithConts(cc, modName, cc.arg(0), cc.arg(1), cc.arg(2)));
        int readConf = this.vm.sym.handleFor("read_conf");
        return c.call("kink/_mod/REQUIRE_AUX", readConf).args(modNameVal, config, (Val)cont);
    }

    HostResult requireWithConts(HostContext c, String modName, Val successCont, Val notFoundCont, Val compileErrorCont) throws Throwable {
        if (!(successCont instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("require(Mod_name ...[$config]): success cont is not a fun but {}", this.vm.graph.repr(successCont)));
        }
        if (!(notFoundCont instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("require(Mod_name ...[$config]): not found cont is not a fun but {}", this.vm.graph.repr(notFoundCont)));
        }
        if (!(compileErrorCont instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("require(Mod_name ...[$config]): compile error cont is not a fun but {}", this.vm.graph.repr(compileErrorCont)));
        }
        return this.vm.mod.require(c, modName, (FunVal)successCont, (FunVal)notFoundCont, (FunVal)compileErrorCont);
    }

    private HostResult raiseFun(CallContext c) {
        Val msgVal = c.arg(0);
        if (!(msgVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("raise(Msg): Msg must be a str, but got {}", this.vm.graph.repr(msgVal)));
        }
        String msg = ((StrVal)msgVal).string();
        return c.raise(msg);
    }

    private HostResult opLogNotFun(CallContext c) {
        Val arg = c.arg(0);
        if (arg == this.vm.bool.trueVal) {
            return this.vm.bool.falseVal;
        }
        if (arg == this.vm.bool.falseVal) {
            return this.vm.bool.trueVal;
        }
        return c.call(this.vm.graph.raiseFormat("op_lognot(Bool): Bool must be bool, but got {}", this.vm.graph.repr(arg)));
    }

    private HostResult opLogOrFun(CallContext c) {
        Val first = c.arg(0);
        Val second = c.arg(1);
        if (!this.vm.bool.isBool(first)) {
            return c.call(this.vm.graph.raiseFormat("op_logor(Bool $thunk): Bool must be bool, but got {}", this.vm.graph.repr(first)));
        }
        if (!(second instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("op_logor(Bool $thunk): $thunk must be fun, but got {}", this.vm.graph.repr(second)));
        }
        return first == this.vm.bool.trueVal ? this.vm.bool.trueVal : c.call((FunVal)second);
    }

    private HostResult opLogAndFun(CallContext c) {
        Val first = c.arg(0);
        Val second = c.arg(1);
        if (!this.vm.bool.isBool(first)) {
            return c.call(this.vm.graph.raiseFormat("op_logand(Bool $thunk): Bool must be bool, but got {}", this.vm.graph.repr(first)));
        }
        if (!(second instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("op_logand(Bool $thunk): $thunk must be fun, but got {}", this.vm.graph.repr(second)));
        }
        return first == this.vm.bool.trueVal ? c.call((FunVal)second) : this.vm.bool.falseVal;
    }

    private HostResult ifFun(CallContext c) {
        Val bool = c.arg(0);
        Val trueCont = c.arg(1);
        if (!this.vm.bool.isBool(bool)) {
            return c.call(IfSupport.condNotBool(this.vm, bool));
        }
        if (!(trueCont instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("if(Bool $true_cont ...[$false_cont={{}}]): $true_cont must be a fun, but got {}", this.vm.graph.repr(trueCont)));
        }
        if (c.argCount() == 2) {
            return bool == this.vm.bool.trueVal ? c.call((FunVal)trueCont) : this.vm.nada;
        }
        Val falseCont = c.arg(2);
        if (!(falseCont instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("if(Bool $true_cont ...[$false_cont={{}}]): $false_cont must be a fun, but got {}", this.vm.graph.repr(falseCont)));
        }
        return c.call((FunVal)(bool == this.vm.bool.trueVal ? trueCont : falseCont));
    }

    private HostResult branchFun(CallContext c) {
        int i;
        int argCount = c.argCount();
        ArrayList<Val> args = new ArrayList<Val>(argCount);
        for (i = 0; i < argCount; ++i) {
            args.add(c.arg(i));
        }
        if (argCount % 2 != 0) {
            return c.call(this.vm.graph.raiseFormat("{}: odd number of args: {}", this.vm.graph.of(this.vm.str.of(BRANCH_DESC)), this.vm.graph.repr(this.vm.num.of(argCount))));
        }
        for (i = 0; i < argCount; i += 2) {
            if (!(args.get(i) instanceof FunVal)) {
                String param = "$cond" + (i / 2 + 1);
                return c.call(this.vm.graph.raiseFormat("{}: {} must be fun, but got {}", this.vm.graph.of(this.vm.str.of(BRANCH_DESC)), this.vm.graph.of(this.vm.str.of(param)), this.vm.graph.repr((Val)args.get(i))));
            }
            if (c.arg(i + 1) instanceof FunVal) continue;
            String param = "$then" + (i / 2 + 1);
            return c.call(this.vm.graph.raiseFormat("{}: {} must be fun, but got {}", this.vm.graph.of(this.vm.str.of(BRANCH_DESC)), this.vm.graph.of(this.vm.str.of(param)), this.vm.graph.repr((Val)args.get(i + 1))));
        }
        return this.branchLoop(c, args, 0);
    }

    private HostResult branchLoop(HostContext c, List<Val> args, int index) {
        if (index >= args.size()) {
            return c.call(BranchSupport.noMatchingCond(this.vm));
        }
        FunVal cond = (FunVal)args.get(index);
        return c.call(cond).on((cc, b) -> {
            if (!this.vm.bool.isBool(b)) {
                return cc.call(BranchSupport.condNotBool(this.vm, index, b));
            }
            if (b.equals(this.vm.bool.trueVal)) {
                FunVal body = (FunVal)args.get(index + 1);
                return cc.call(body);
            }
            return this.branchLoop(cc, args, index + 2);
        });
    }
}

