/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.JavaVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostFunBuilder;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.function.ThrowingFunction0;
import org.kink_lang.kink.internal.function.ThrowingFunction1;
import org.kink_lang.kink.internal.function.ThrowingFunction2;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.function.ThrowingFunction4;
import org.kink_lang.kink.internal.num.NumOperations;

public class JavaHelper {
    private final Vm vm;
    SharedVars sharedVars;
    private int readConfHandle;
    private FunVal invDefSuccessCont;
    private FunVal invDefErrorCont;

    JavaHelper(Vm vm) {
        this.vm = vm;
    }

    public JavaVal of(@Nullable Object object, Class<?> staticType) {
        return new JavaVal(this.vm, object, staticType);
    }

    void init() {
        HashMap<Integer, Val> map = new HashMap<Integer, Val>();
        map.put(this.vm.sym.handleFor("static_type"), this.method0("Java_val.static_type", this::staticTypeFun));
        map.put(this.vm.sym.handleFor("dynamic_type"), this.method0("Java_val.dynamic_type", this::dynamicTypeFun));
        this.addMethod1(map, "Java_val", "typable_as?", "Klass", this::typableAsFun);
        this.addMethod1(map, "Java_val", "as", "Klass", this::asFun);
        this.addMethod1(map, "Java_val", "eq_eq?", "Another", this::eqEqPFun);
        map.put(this.vm.sym.handleFor("null?"), this.method0("Java_val.null?", (c, v) -> this.vm.bool.of(v.objectReference() == null)));
        map.put(this.vm.sym.handleFor("to_kink_str"), this.method0("Java_val.to_kink_str", this::toKinkStrFun));
        map.put(this.vm.sym.handleFor("to_kink_bool"), this.method0("Java_val.to_kink_bool", this::toKinkBoolFun));
        map.put(this.vm.sym.handleFor("to_kink_num"), this.method0("Java_val.to_kink_num", this::toKinkNumFun));
        map.put(this.vm.sym.handleFor("to_kink_bin"), this.method0("Java_val.to_kink_bin", this::toKinkBinFun));
        map.put(this.vm.sym.handleFor("to_kink_exception"), this.method0("Java_val.to_kink_exception", this::toKinkExceptionMethod));
        map.put(this.vm.sym.handleFor("unwrap"), this.method0("Java_val.unwrap", this::unwrapFun));
        map.put(this.vm.sym.handleFor("array_class"), this.method0("Java_val.array_class", this::arrayClassFun));
        this.addMethod1(map, "Java_val", "array_new", "Size", this::arrayNewFun);
        map.put(this.vm.sym.handleFor("array_of"), this.method("Java_val.array_of", this::arrayOfFun));
        map.put(this.vm.sym.handleFor("array_length"), this.method0("Java_val.array_length", this::arrayLengthFun));
        this.addMethod1(map, "Java_val", "array_get", "Ind", this::arrayGetFun);
        map.put(this.vm.sym.handleFor("array_set"), this.method2("Java_val.array_set(Ind Elem)", this::arraySetFun));
        this.addMethod1(map, "Java_val", "get_field", "Field_name", this::getFieldFun);
        map.put(this.vm.sym.handleFor("set_field"), this.method2("Java_val.set_field(Field_name Content)", this::setFieldFun));
        this.addMethod1(map, "Java_val", "get_static", "Field_name", this::getStaticFun);
        map.put(this.vm.sym.handleFor("set_static"), this.method2("Java_val.set_static(Field_name Content)", this::setStaticFun));
        map.put(this.vm.sym.handleFor("call_method"), this.methodMinMax("Java_val.call_method(Method_name Args ...[$config])", 2, 3, this::callMethodFun));
        map.put(this.vm.sym.handleFor("call_static"), this.methodMinMax("Java_val.call_static(Method_name Args ...[$config])", 2, 3, this::callStaticFun));
        map.put(this.vm.sym.handleFor("new"), this.methodMinMax("Java_val.new(Args ...[$config])", 1, 2, this::newFun));
        map.put(this.vm.sym.handleFor("repr"), this.method0("Java_val.repr", this::reprFun));
        this.sharedVars = this.vm.sharedVars.of(map);
        this.readConfHandle = this.vm.sym.handleFor("read_conf");
        this.invDefSuccessCont = this.vm.fun.make().takeMinMax(0, 1).action(this::invDefSuccessCont);
        this.invDefErrorCont = this.vm.fun.make().take(1).action(this::invDefErrorCont);
    }

    private HostResult staticTypeFun(HostContext c, JavaVal jv) {
        return this.vm.java.of(jv.staticType(), Class.class);
    }

    private HostResult dynamicTypeFun(HostContext c, JavaVal jv) {
        Object obj = jv.objectReference();
        if (obj == null) {
            return c.raise("Java_val.dynamic_type: required non-null java_val as \\recv, but got null");
        }
        return this.vm.java.of(obj.getClass(), Class.class);
    }

    private HostResult typableAsFun(String desc, HostContext c, JavaVal jv, Val klassVal) {
        Class<?> klass = this.asClass(klassVal);
        if (klass == null) {
            return c.call(this.vm.graph.raiseFormat("{}: Klass must be a Java class, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(klassVal)));
        }
        return this.vm.bool.of(this.isTypable(jv.objectReference(), klass));
    }

    private HostResult asFun(String desc, HostContext c, JavaVal jv, Val klassVal) {
        Class<?> klass = this.asClass(klassVal);
        if (klass == null) {
            return c.call(this.vm.graph.raiseFormat("{}: Klass must be a Java class, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(klassVal)));
        }
        Object obj = jv.objectReference();
        if (!this.isTypable(obj, klass)) {
            String msg = jv.objectReference() == null ? String.format(Locale.ROOT, "%s: null is not typable as %s", desc, klass.getName()) : String.format(Locale.ROOT, "%s: instance of %s is not typable as %s", desc, obj.getClass().getName(), klass.getName());
            return c.raise(msg);
        }
        return this.vm.java.of(jv.objectReference(), klass);
    }

    private HostResult eqEqPFun(String desc, HostContext c, JavaVal jv, Val arg) {
        if (!(arg instanceof JavaVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: required java_val for Another, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(arg)));
        }
        JavaVal argJval = (JavaVal)arg;
        return this.vm.bool.of(jv.objectReference() == argJval.objectReference());
    }

    private HostResult toKinkStrFun(HostContext c, JavaVal jv) {
        if (!(jv.objectReference() instanceof String)) {
            return c.call(this.vm.graph.raiseFormat("Java_val.to_kink_str: required string java_val as \\recv, but got {}", this.vm.graph.repr(jv)));
        }
        return this.vm.str.of((String)jv.objectReference());
    }

    private HostResult toKinkBoolFun(HostContext c, JavaVal jv) {
        if (!(jv.objectReference() instanceof Boolean)) {
            return c.call(this.vm.graph.raiseFormat("Java_val.to_kink_bool: required boolean java_val as \\recv, but got {}", this.vm.graph.repr(jv)));
        }
        return this.vm.bool.of((Boolean)jv.objectReference());
    }

    private HostResult toKinkNumFun(HostContext c, JavaVal jv) {
        Object obj = jv.objectReference();
        if (obj instanceof Character) {
            return this.vm.num.of(((Character)obj).charValue());
        }
        if (obj instanceof Byte) {
            return this.vm.num.of(((Byte)obj).byteValue());
        }
        if (obj instanceof Short) {
            return this.vm.num.of(((Short)obj).shortValue());
        }
        if (obj instanceof Integer) {
            return this.vm.num.of((Integer)obj);
        }
        if (obj instanceof Long) {
            return this.vm.num.of((Long)obj);
        }
        if (obj instanceof Float) {
            float num = ((Float)obj).floatValue();
            if (!Float.isFinite(num)) {
                return c.raise(String.format(Locale.ROOT, "Java_val.to_kink_num: cannot convert %s to kink num", Float.valueOf(num)));
            }
            return this.vm.num.of(new BigDecimal(num));
        }
        if (obj instanceof Double) {
            double num = (Double)obj;
            if (!Double.isFinite(num)) {
                return c.raise(String.format(Locale.ROOT, "Java_val.to_kink_num: cannot convert %s to kink num", num));
            }
            return this.vm.num.of(new BigDecimal((Double)obj));
        }
        if (obj instanceof BigInteger) {
            return this.vm.num.of((BigInteger)obj);
        }
        if (obj instanceof BigDecimal) {
            return this.vm.num.of((BigDecimal)obj);
        }
        return c.call(this.vm.graph.raiseFormat("Java_val.to_kink_num: required char, byte, short, int, long, finite float, finite double, BigInteger or BigDecimal as \\recv, but got {}", this.vm.graph.repr(jv)));
    }

    private HostResult toKinkBinFun(HostContext c, JavaVal jv) {
        if (!(jv.objectReference() instanceof byte[])) {
            return c.call(this.vm.graph.raiseFormat("Java_val.to_kink_bin: required byte[] java_val as \\recv, but got {}", this.vm.graph.repr(jv)));
        }
        byte[] bytes = (byte[])jv.objectReference();
        return this.vm.bin.of(bytes);
    }

    private HostResult toKinkExceptionMethod(CallContext c, JavaVal recv) {
        String desc = "Java_val.to_kink_exception";
        Object object = recv.objectReference();
        if (!(object instanceof Throwable)) {
            return c.call(this.vm.graph.raiseFormat("{}: Java_val must be java val of Throwable, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(recv)));
        }
        Throwable th = (Throwable)object;
        return this.vm.exception.of(th);
    }

    private HostResult unwrapFun(HostContext c, JavaVal jv) {
        if (!(jv.objectReference() instanceof Val)) {
            return c.call(this.vm.graph.raiseFormat("Java_val.unwrap: required java_val of org.kink_lang.kink.Val as \\recv, but got {}", this.vm.graph.repr(jv)));
        }
        Val val = (Val)jv.objectReference();
        if (val.vm != this.vm) {
            return c.raise("Java_val.unwrap: could not unwrap val from another Kink VM");
        }
        return val;
    }

    private HostResult arrayClassFun(HostContext c, JavaVal klassVal) {
        Object klassObj = klassVal.objectReference();
        Optional<String> errorMsg = this.checkErrorForArrayComponentClass("Java_val.array_class", klassObj);
        return errorMsg.map(c::raise).orElseGet(() -> {
            Object array = Array.newInstance((Class)klassObj, 0);
            return this.vm.java.of(array.getClass(), Class.class);
        });
    }

    private HostResult arrayNewFun(String desc, HostContext c, JavaVal klassVal, Val sizeVal) {
        Object klassObj = klassVal.objectReference();
        Optional<String> errorMsg = this.checkErrorForArrayComponentClass(desc, klassObj);
        if (errorMsg.isPresent()) {
            return c.raise(errorMsg.get());
        }
        int size = NumOperations.getPosIndex(sizeVal, Integer.MAX_VALUE);
        if (size < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Size must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(Integer.MAX_VALUE)), this.vm.graph.repr(sizeVal)));
        }
        Object array = Array.newInstance((Class)klassObj, size);
        return this.vm.java.of(array, array.getClass());
    }

    private HostResult arrayOfFun(CallContext c, JavaVal klassVal) {
        Object klassObj = klassVal.objectReference();
        Optional<String> errorMsg = this.checkErrorForArrayComponentClass("Java_val.array_of", klassObj);
        if (errorMsg.isPresent()) {
            return c.raise(errorMsg.get());
        }
        Class klass = (Class)klassObj;
        Object array = Array.newInstance(klass, c.argCount());
        for (int i = 0; i < c.argCount(); ++i) {
            Val elem = c.arg(i);
            if (!(elem instanceof JavaVal)) {
                return c.call(this.vm.graph.raiseFormat("Java_val.array_of: required java_val as \\{}, but got {}", this.vm.graph.of(this.vm.num.of(i)), this.vm.graph.repr(elem)));
            }
            Object elemObj = ((JavaVal)elem).objectReference();
            if (!this.isTypable(elemObj, klass)) {
                return c.call(this.vm.graph.raiseFormat("Java_val.array_of: required java_val typable as {}, as \\{}, but got {}", this.vm.graph.of(this.vm.str.of(klass.getName())), this.vm.graph.of(this.vm.num.of(i)), this.vm.graph.repr(elem)));
            }
            Array.set(array, i, elemObj);
        }
        return this.vm.java.of(array, array.getClass());
    }

    private HostResult arrayLengthFun(HostContext c, JavaVal jval) {
        Object obj = jval.objectReference();
        return this.checkErrorForArray("Java_val.array_length", obj).map(c::raise).orElseGet(() -> this.vm.num.of(Array.getLength(obj)));
    }

    private HostResult arrayGetFun(String desc, HostContext c, JavaVal jv, Val indexVal) {
        Object arrayObj = jv.objectReference();
        Optional<String> errorMsg = this.checkErrorForArray(desc, arrayObj);
        if (errorMsg.isPresent()) {
            return c.raise(errorMsg.get());
        }
        int size = Array.getLength(arrayObj);
        int index = NumOperations.getElemIndex(indexVal, size);
        if (index < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be an int num in [0, {}), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indexVal)));
        }
        return this.vm.java.of(Array.get(arrayObj, index), arrayObj.getClass().getComponentType());
    }

    private HostResult arraySetFun(HostContext c, JavaVal jv, Val indexVal, Val elemVal) throws Throwable {
        String desc = "Java_val.array_set(Ind Elem)";
        Object arrayObj = jv.objectReference();
        Optional<String> errorMsg = this.checkErrorForArray(desc, arrayObj);
        if (errorMsg.isPresent()) {
            return c.raise(errorMsg.get());
        }
        int size = Array.getLength(arrayObj);
        int index = NumOperations.getElemIndex(indexVal, size);
        if (index < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: Ind must be an int num in [0, {}), but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indexVal)));
        }
        Class<?> componentType = arrayObj.getClass().getComponentType();
        return this.forValOf(componentType, elemVal, () -> c.call(this.vm.graph.raiseFormat("{}: Elem msut be a java_val typable as {}, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(componentType.getName())), this.vm.graph.repr(elemVal))), elem -> {
            Array.set(arrayObj, index, elem);
            return this.vm.nada;
        });
    }

    private HostResult getFieldFun(String desc, HostContext c, JavaVal jv, Val nameVal) throws ReflectiveOperationException {
        if (jv.objectReference() == null) {
            return c.raise(String.format(Locale.ROOT, "%s: required non-null java_val for \\recv, but got null", desc));
        }
        if (!(nameVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Field_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(nameVal)));
        }
        String name = ((StrVal)nameVal).string();
        Field field = jv.staticType().getField(name);
        if (Modifier.isStatic(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: required instance field name, but %s.%s is static field", desc, jv.staticType().getName(), name);
            return c.raise(msg);
        }
        Object fieldVal = field.get(jv.objectReference());
        return this.vm.java.of(fieldVal, field.getType());
    }

    private HostResult setFieldFun(HostContext c, JavaVal jv, Val nameVal, Val content) throws ReflectiveOperationException {
        String desc = "Java_val.set_field(Field_name Content)";
        if (jv.objectReference() == null) {
            return c.raise(String.format(Locale.ROOT, "%s: required non-null java_val as \\recv, but got null", desc));
        }
        if (!(nameVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Field_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(nameVal)));
        }
        String name = ((StrVal)nameVal).string();
        if (!(content instanceof JavaVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Content must be a java_val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(content)));
        }
        Object contentObj = ((JavaVal)content).objectReference();
        Field field = jv.staticType().getField(name);
        if (Modifier.isStatic(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: required instance field name, but %s.%s is static field", desc, jv.staticType().getName(), name);
            return c.raise(msg);
        }
        field.set(jv.objectReference(), contentObj);
        return this.vm.nada;
    }

    private HostResult getStaticFun(String desc, HostContext c, JavaVal jv, Val nameVal) throws ReflectiveOperationException {
        if (jv.objectReference() == null) {
            return c.raise(String.format(Locale.ROOT, "%s: required class as \\recv, but got null", desc));
        }
        if (!(jv.objectReference() instanceof Class)) {
            Class<?> dynamicClass = jv.objectReference().getClass();
            String msg = String.format(Locale.ROOT, "%s: required class as \\recv, but got %s: %s", desc, dynamicClass.getName(), jv.objectReference());
            return c.raise(msg);
        }
        Class klass = (Class)jv.objectReference();
        if (!(nameVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Field_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(nameVal)));
        }
        String name = ((StrVal)nameVal).string();
        Field field = klass.getField(name);
        if (!Modifier.isStatic(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: required static field name, but %s.%s is instance field", desc, klass.getName(), name);
            return c.raise(msg);
        }
        Object fieldVal = field.get(null);
        return this.vm.java.of(fieldVal, field.getType());
    }

    private HostResult setStaticFun(HostContext c, JavaVal jv, Val nameVal, Val content) throws ReflectiveOperationException {
        Class<?> klass = this.asClass(jv);
        String desc = "Java_val.set_static(Field_name Content)";
        if (klass == null) {
            return c.call(this.vm.graph.raiseFormat("{}: required class java_val for \\recv, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(jv)));
        }
        if (!(nameVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Field_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(nameVal)));
        }
        String name = ((StrVal)nameVal).string();
        Field field = klass.getField(name);
        if (!Modifier.isStatic(field.getModifiers())) {
            String msg = String.format(Locale.ROOT, "%s: required static field name, but %s.%s is instance field", desc, klass.getName(), name);
            return c.raise(msg);
        }
        if (!(content instanceof JavaVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Content must be a java_val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(content)));
        }
        Object contentObj = ((JavaVal)content).objectReference();
        field.set(null, contentObj);
        return this.vm.nada;
    }

    private HostResult callMethodFun(CallContext c, JavaVal recv) throws Throwable {
        Method method;
        FunVal config;
        String desc = "Java_val.call_method(Method_name Args ...[$config])";
        if (!(c.arg(0) instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Method_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        String name = ((StrVal)c.arg(0)).string();
        Val argsVecVal = c.arg(1);
        if (!(argsVecVal instanceof VecVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Args must be a vec, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(argsVecVal)));
        }
        if (c.argCount() != 3) {
            config = null;
        } else {
            if (!(c.arg(2) instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: $config must be fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(2))));
            }
            config = (FunVal)c.arg(2);
        }
        List<Val> argList = ((VecVal)argsVecVal).toList();
        int size = argList.size();
        Class[] argTypes = new Class[size];
        Object[] args = new Object[size];
        Optional<GraphNode> argsError = this.retrieveArgs(desc, argList, size, argTypes, args);
        if (argsError.isPresent()) {
            return c.call(argsError.get());
        }
        try {
            method = recv.staticType().getMethod(name, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            return c.raise(String.format(Locale.ROOT, "%s: method not found: %s", desc, nsme.getMessage()));
        }
        if (Modifier.isStatic(method.getModifiers())) {
            return c.raise(String.format(Locale.ROOT, "%s: method %s is a static method", desc, name));
        }
        return this.withConts(c, config, (cc, successCont, errorCont) -> this.invokeMethod((HostContext)cc, method, recv.objectReference(), args, (FunVal)successCont, (FunVal)errorCont));
    }

    private HostResult callStaticFun(CallContext c, JavaVal klassVal) throws Throwable {
        Method method;
        FunVal config;
        Object klassObj = klassVal.objectReference();
        String desc = "Java_val.call_static(Method_name Args ...[$config])";
        if (!(klassObj instanceof Class)) {
            String msg = String.format(Locale.ROOT, "%s: required class as \\recv, but got %s", desc, this.objectDesc(klassObj));
            return c.raise(msg);
        }
        Class klass = (Class)klassObj;
        if (!(c.arg(0) instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Method_name must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        String name = ((StrVal)c.arg(0)).string();
        Val argsVecVal = c.arg(1);
        if (!(argsVecVal instanceof VecVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Args must be a vec, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(argsVecVal)));
        }
        if (c.argCount() != 3) {
            config = null;
        } else {
            if (!(c.arg(2) instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: $config must be fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(2))));
            }
            config = (FunVal)c.arg(2);
        }
        List<Val> argList = ((VecVal)argsVecVal).toList();
        int size = argList.size();
        Class[] argTypes = new Class[size];
        Object[] args = new Object[size];
        Optional<GraphNode> argsError = this.retrieveArgs(desc, argList, size, argTypes, args);
        if (argsError.isPresent()) {
            return c.call(argsError.get());
        }
        try {
            method = klass.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException nsme) {
            return c.raise(String.format(Locale.ROOT, "%s: method not found: %s", desc, nsme.getMessage()));
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            return c.raise(String.format(Locale.ROOT, "%s: method %s is not a static method", desc, name));
        }
        return this.withConts(c, config, (cc, successCont, errorCont) -> this.invokeMethod((HostContext)cc, method, null, args, (FunVal)successCont, (FunVal)errorCont));
    }

    private HostResult newFun(CallContext c, JavaVal klassVal) throws Throwable {
        Constructor ctor;
        FunVal config;
        String desc = "Java_val.new(Args ...[$config])";
        Object klassObj = klassVal.objectReference();
        if (!(klassObj instanceof Class)) {
            return c.raise(String.format(Locale.ROOT, "%s: required class as \\recv, but got %s", desc, this.objectDesc(klassObj)));
        }
        Class klass = (Class)klassObj;
        Val argsVecVal = c.arg(0);
        if (!(argsVecVal instanceof VecVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Args must be a vec, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(argsVecVal)));
        }
        List<Val> argList = ((VecVal)argsVecVal).toList();
        if (c.argCount() == 1) {
            config = null;
        } else if (c.arg(1) instanceof FunVal) {
            config = (FunVal)c.arg(1);
        } else {
            return c.call(this.vm.graph.raiseFormat("{}: $config must be a fun, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(1))));
        }
        int size = argList.size();
        Class[] argTypes = new Class[size];
        Object[] args = new Object[size];
        Optional<GraphNode> argsError = this.retrieveArgs(desc, argList, size, argTypes, args);
        if (argsError.isPresent()) {
            return c.call(argsError.get());
        }
        try {
            ctor = klass.getConstructor(argTypes);
        }
        catch (NoSuchMethodException nsme) {
            return c.raise(String.format(Locale.ROOT, "Java_val.new(A0 A1 ,,,): constructor not found: %s", nsme.getMessage()));
        }
        return this.withConts(c, config, (cc, successCont, errorCont) -> this.invokeConstructor((CallContext)cc, ctor, args, (FunVal)successCont, (FunVal)errorCont));
    }

    private Optional<GraphNode> retrieveArgs(String prefix, List<Val> argList, int size, Class<?>[] argTypes, Object[] args) {
        for (int i = 0; i < size; ++i) {
            Val arg = argList.get(i);
            if (!(arg instanceof JavaVal)) {
                return Optional.of(this.vm.graph.raiseFormat("{}: required java_val for Args#{}, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.of(this.vm.num.of(i)), this.vm.graph.repr(arg)));
            }
            argTypes[i] = ((JavaVal)arg).staticType();
            args[i] = ((JavaVal)arg).objectReference();
        }
        return Optional.empty();
    }

    private HostResult invokeConstructor(CallContext c, Constructor ctor, Object[] args, @Nullable FunVal successCont, @Nullable FunVal errorCont) {
        Object result;
        try {
            result = ctor.newInstance(args);
        }
        catch (ReflectiveOperationException roe) {
            Throwable th = JavaHelper.unwrapReflectionException(roe);
            return errorCont != null ? c.call(errorCont).args((Val)this.vm.java.of(th, Throwable.class)) : c.raise(th);
        }
        JavaVal resultJavaVal = this.vm.java.of(result, ctor.getDeclaringClass());
        return successCont != null ? c.call(successCont).args((Val)resultJavaVal) : resultJavaVal;
    }

    private HostResult invokeMethod(HostContext c, Method method, Object recv, Object[] args, @Nullable FunVal successCont, @Nullable FunVal errorCont) {
        Object result;
        Class<?> returnType = method.getReturnType();
        try {
            result = method.invoke(recv, args);
        }
        catch (ReflectiveOperationException roe) {
            Throwable th = JavaHelper.unwrapReflectionException(roe);
            return errorCont != null ? c.call(errorCont).args((Val)this.vm.java.of(th, Throwable.class)) : c.raise(th);
        }
        if (successCont == null) {
            return returnType.equals(Void.TYPE) ? this.vm.nada : this.vm.java.of(result, returnType);
        }
        if (returnType.equals(Void.TYPE)) {
            return c.call(successCont).args();
        }
        JavaVal resultVal = this.vm.java.of(result, returnType);
        return c.call(successCont).args((Val)resultVal);
    }

    private HostResult withConts(CallContext c, @Nullable FunVal config, ThrowingFunction3<CallContext, FunVal, FunVal, HostResult> invoke) throws Throwable {
        if (config == null) {
            return invoke.apply(c, null, null);
        }
        FunVal cont = this.vm.fun.make().take(2).action(cc -> this.contToInvoke(cc, invoke));
        return c.call("kink/_java/CALL_AUX", this.readConfHandle).args((Val)config, (Val)this.invDefSuccessCont, (Val)this.invDefErrorCont, (Val)cont);
    }

    HostResult contToInvoke(CallContext c, ThrowingFunction3<CallContext, FunVal, FunVal, HostResult> invoke) throws Throwable {
        Val successContVal = c.arg(0);
        if (!(successContVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("(cont-to-invoke($success_cont $error_cont)): $success_cont must be a fun, but got {}", this.vm.graph.repr(successContVal)));
        }
        Val errorContVal = c.arg(1);
        if (!(errorContVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("(cont-to-invoke($success_cont $error_cont)): $error_cont must be a fun, but got {}", this.vm.graph.repr(errorContVal)));
        }
        return invoke.apply(c, (FunVal)successContVal, (FunVal)errorContVal);
    }

    HostResult invDefSuccessCont(CallContext c) {
        return c.argCount() == 0 ? this.vm.nada : c.arg(0);
    }

    HostResult invDefErrorCont(CallContext c) {
        Val exVal = c.arg(0);
        Supplier<HostResult> raise = () -> c.call(this.vm.graph.raiseFormat("(default-error-cont(Exc_java_val)): Exc_java_val must be a java_val of Throwable, but got {}", this.vm.graph.repr(exVal)));
        if (!(exVal instanceof JavaVal)) {
            return raise.get();
        }
        Object thObj = ((JavaVal)exVal).objectReference();
        if (!(thObj instanceof Throwable)) {
            return raise.get();
        }
        return c.raise((Throwable)thObj);
    }

    static Throwable unwrapReflectionException(ReflectiveOperationException roe) {
        Throwable cause;
        if (roe instanceof InvocationTargetException && (cause = roe.getCause()) != null) {
            return cause;
        }
        return roe;
    }

    private HostResult reprFun(HostContext c, JavaVal java) {
        return this.vm.str.of(String.format(Locale.ROOT, "(java_val %s as %s)", java.objectReference(), java.staticType().getName()));
    }

    private HostResult forValOf(Class<?> klass, Val val, ThrowingFunction0<HostResult> onError, ThrowingFunction1<Object, HostResult> onOk) throws Throwable {
        if (!(val instanceof JavaVal)) {
            return onError.apply();
        }
        Object obj = ((JavaVal)val).objectReference();
        if (!this.isTypable(obj, klass)) {
            return onError.apply();
        }
        return onOk.apply(obj);
    }

    private Class<?> asClass(Val klassVal) {
        if (!(klassVal instanceof JavaVal)) {
            return null;
        }
        JavaVal klassJavaVal = (JavaVal)klassVal;
        Object klassObj = klassJavaVal.objectReference();
        if (!(klassObj instanceof Class)) {
            return null;
        }
        return (Class)klassObj;
    }

    private FunVal method(String prefix, ThrowingFunction2<CallContext, JavaVal, HostResult> action) {
        return this.method(prefix, UnaryOperator.identity(), action);
    }

    private FunVal methodMinMax(String prefix, int min, int max, ThrowingFunction2<CallContext, JavaVal, HostResult> action) {
        return this.method(prefix, b -> b.takeMinMax(min, max), action);
    }

    private FunVal method(String prefix, UnaryOperator<HostFunBuilder> configFun, ThrowingFunction2<CallContext, JavaVal, HostResult> action) {
        return ((HostFunBuilder)configFun.apply(this.vm.fun.make(prefix))).action(c -> {
            if (!(c.recv() instanceof JavaVal)) {
                String msg = String.format(Locale.ROOT, "%s: required java_val as \\recv, but was not", prefix);
                return c.raise(msg);
            }
            return (HostResult)action.apply(c, (JavaVal)c.recv());
        });
    }

    private FunVal method0(String prefix, ThrowingFunction2<CallContext, JavaVal, HostResult> action) {
        return this.vm.fun.make(prefix).take(0).action(c -> {
            if (!(c.recv() instanceof JavaVal)) {
                String msg = String.format(Locale.ROOT, "%s: required java_val as \\recv, but was not", prefix);
                return c.raise(msg);
            }
            return (HostResult)action.apply(c, (JavaVal)c.recv());
        });
    }

    private void addMethod1(Map<Integer, Val> mapping, String recvDesc, String name, String arg0Desc, ThrowingFunction4<String, CallContext, JavaVal, Val, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s(%s)", recvDesc, name, arg0Desc);
        FunVal fun = this.vm.fun.make(desc).take(1).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof JavaVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be java val, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(recv)));
            }
            JavaVal recvJavaVal = (JavaVal)recv;
            return (HostResult)action.apply(desc, c, recvJavaVal, c.arg(0));
        });
        mapping.put(this.vm.sym.handleFor(name), fun);
    }

    private FunVal method2(String prefix, ThrowingFunction4<CallContext, JavaVal, Val, Val, HostResult> action) {
        return this.vm.fun.make(prefix).take(2).action(c -> {
            if (!(c.recv() instanceof JavaVal)) {
                String msg = String.format(Locale.ROOT, "%s: required java_val as \\recv, but was not", prefix);
                return c.raise(msg);
            }
            return (HostResult)action.apply(c, (JavaVal)c.recv(), c.arg(0), c.arg(1));
        });
    }

    private Optional<String> checkErrorForArrayComponentClass(String prefix, Object klassObj) {
        if (!(klassObj instanceof Class)) {
            return Optional.of(String.format(Locale.ROOT, "%s: requires class as \\recv, but got %s", prefix, this.objectDesc(klassObj)));
        }
        Class klass = (Class)klassObj;
        if (klass.equals(Void.TYPE)) {
            return Optional.of(String.format(Locale.ROOT, "%s: no array class for void", prefix));
        }
        int dimension = JavaHelper.arrayDimension(klass);
        if (dimension >= 255) {
            return Optional.of(String.format(Locale.ROOT, "%s: too big array dimension: %d", prefix, dimension + 1));
        }
        return Optional.empty();
    }

    private Optional<String> checkErrorForArray(String prefix, Object obj) {
        if (obj == null || !obj.getClass().isArray()) {
            return Optional.of(String.format(Locale.ROOT, "%s: \\recv is not array, but was %s", prefix, this.objectDesc(obj)));
        }
        return Optional.empty();
    }

    private static int arrayDimension(Class<?> klass) {
        int dimension = 0;
        while (klass.isArray()) {
            ++dimension;
            klass = klass.getComponentType();
        }
        return dimension;
    }

    private String objectDesc(@Nullable Object obj) {
        return obj == null ? "null" : String.format(Locale.ROOT, "%s: %s", obj.getClass().getName(), obj);
    }

    public boolean isTypable(@Nullable Object object, Class<?> staticType) {
        return object == null && !staticType.isPrimitive() || staticType.isInstance(object) || object instanceof Boolean && staticType.equals(Boolean.TYPE) || object instanceof Character && staticType.equals(Character.TYPE) || object instanceof Byte && staticType.equals(Byte.TYPE) || object instanceof Short && staticType.equals(Short.TYPE) || object instanceof Integer && staticType.equals(Integer.TYPE) || object instanceof Long && staticType.equals(Long.TYPE) || object instanceof Float && staticType.equals(Float.TYPE) || object instanceof Double && staticType.equals(Double.TYPE);
    }
}

