/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.Locale;
import javax.annotation.Nullable;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;

public class JavaVal
extends Val {
    @Nullable
    private final Object objectReference;
    private final Class<?> staticType;

    JavaVal(Vm vm, @Nullable Object objectReference, Class<?> staticType) {
        super(vm, null);
        if (!vm.java.isTypable(objectReference, staticType)) {
            String msg = String.format(Locale.ROOT, "objectReference (%s) must be able to typed as staticType %s", objectReference, staticType.getName());
            throw new IllegalArgumentException(msg);
        }
        this.objectReference = objectReference;
        this.staticType = staticType;
    }

    @Nullable
    public Object objectReference() {
        return this.objectReference;
    }

    public Class<?> staticType() {
        return this.staticType;
    }

    @Override
    SharedVars sharedVars() {
        return this.vm.java.sharedVars;
    }

    public String toString() {
        return String.format(Locale.ROOT, "JavaVal(%s as %s)", this.objectReference, this.staticType.getName());
    }

    public int hashCode() {
        return 13 + 11 * this.vm.hashCode() + 41 * System.identityHashCode(this.objectReference) + 113 * this.staticType.hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) return true;
        if (!(arg instanceof JavaVal)) return false;
        JavaVal argJava = (JavaVal)arg;
        if (!this.vm.equals(argJava.vm)) return false;
        if (this.objectReference != argJava.objectReference) return false;
        if (!this.staticType.equals(argJava.staticType)) return false;
        return true;
    }
}

