/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Locale;
import java.util.OptionalInt;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction2;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.num.NumOperations;

public class NumHelper {
    private final Vm vm;
    private int newHandle;
    private int showNumHandle;
    SharedVars sharedVars;

    NumHelper(Vm vm) {
        this.vm = vm;
    }

    public NumVal of(BigDecimal bigDecimal) {
        return new NumVal(this.vm, bigDecimal);
    }

    public NumVal of(int intNum) {
        return new NumVal(this.vm, BigDecimal.valueOf(intNum));
    }

    public NumVal of(long longNum) {
        return new NumVal(this.vm, BigDecimal.valueOf(longNum));
    }

    public NumVal of(BigInteger bigInt) {
        return new NumVal(this.vm, new BigDecimal(bigInt));
    }

    void init() {
        this.newHandle = this.vm.sym.handleFor("new");
        this.showNumHandle = this.vm.sym.handleFor("_show_num");
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        vars.put(this.vm.sym.handleFor("mantissa"), this.unaryOp("Num.mantissa", (c, n) -> this.vm.num.of(n.unscaledValue())));
        vars.put(this.vm.sym.handleFor("scale"), this.unaryOp("Num.scale", (c, n) -> this.vm.num.of(n.scale())));
        vars.put(this.vm.sym.handleFor("int?"), this.unaryOp("Num.int?", (c, n) -> this.vm.bool.of(n.scale() == 0)));
        vars.put(this.vm.sym.handleFor("op_add"), this.binaryOp("Num.op_add", (c, x, y) -> this.vm.num.of(x.add((BigDecimal)y))));
        vars.put(this.vm.sym.handleFor("op_sub"), this.binaryOp("Num.op_sub", (c, x, y) -> this.vm.num.of(x.subtract((BigDecimal)y))));
        vars.put(this.vm.sym.handleFor("op_mul"), this.binaryOp("Num.op_mul", (c, x, y) -> this.vm.num.of(x.multiply((BigDecimal)y))));
        vars.put(this.vm.sym.handleFor("op_div"), this.binaryOp("Num.op_div", this::opDivMethod));
        vars.put(this.vm.sym.handleFor("op_intdiv"), this.binaryOp("Num.op_div", this::opIntDivMethod));
        vars.put(this.vm.sym.handleFor("op_rem"), this.binaryOp("Num.op_rem", this::opRemMethod));
        vars.put(this.vm.sym.handleFor("op_minus"), this.unaryOp("Num.op_minus", (c, n) -> this.vm.num.of(n.negate())));
        vars.put(this.vm.sym.handleFor("op_or"), this.binaryIntOp("Num.op_or", (c, x, y) -> this.vm.num.of(x.or((BigInteger)y))));
        vars.put(this.vm.sym.handleFor("op_xor"), this.binaryIntOp("Num.op_xor", (c, x, y) -> this.vm.num.of(x.xor((BigInteger)y))));
        vars.put(this.vm.sym.handleFor("op_and"), this.binaryIntOp("Num.op_and", (c, x, y) -> this.vm.num.of(x.and((BigInteger)y))));
        vars.put(this.vm.sym.handleFor("op_not"), this.unaryIntOp("Num.op_not", (c, x) -> this.vm.num.of(x.not())));
        vars.put(this.vm.sym.handleFor("op_shl"), this.shiftMethod("Num.op_shl", BigInteger::shiftLeft));
        vars.put(this.vm.sym.handleFor("op_shr"), this.shiftMethod("Num.op_shr", BigInteger::shiftRight));
        vars.put(this.vm.sym.handleFor("round"), this.method0("Num.round", this::roundMethod));
        vars.put(this.vm.sym.handleFor("abs"), this.unaryOp("Num.abs", (c, n) -> this.vm.num.of(n.abs())));
        vars.put(this.vm.sym.handleFor("op_eq"), this.binaryOp("Num.op_eq", (c, x, y) -> this.vm.bool.of(x.compareTo((BigDecimal)y) == 0)));
        vars.put(this.vm.sym.handleFor("op_lt"), this.binaryOp("Num.op_lt", (c, x, y) -> this.vm.bool.of(x.compareTo((BigDecimal)y) < 0)));
        vars.put(this.vm.sym.handleFor("times"), this.unaryOp("Num.times", this::timesMethod));
        vars.put(this.vm.sym.handleFor("up"), this.unaryOp("Num.up", this::upMethod));
        vars.put(this.vm.sym.handleFor("down"), this.unaryOp("Num.down", this::downMethod));
        vars.put(this.vm.sym.handleFor("repr"), this.unaryOp("Num.repr", this::reprMethod));
        vars.put(this.vm.sym.handleFor("show"), this.vm.fun.make("Num.show").takeMinMax(0, 1).action(this::showMethod));
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult opDivMethod(CallContext c, BigDecimal dividend, BigDecimal divisor) {
        if (divisor.signum() == 0) {
            return c.raise(String.format(Locale.ROOT, "Num.op_div: zero division: %s is divided by 0", dividend.toPlainString()));
        }
        return c.call("kink/NUM_DIV", this.newHandle).args(c.recv(), c.arg(0));
    }

    private HostResult opIntDivMethod(HostContext c, BigDecimal numer, BigDecimal denom) {
        if (denom.signum() == 0) {
            return c.raise(String.format(Locale.ROOT, "Num.op_intdiv: zero division: %s is divided by 0", numer.toPlainString()));
        }
        RoundingMode mode = denom.signum() < 0 ? RoundingMode.CEILING : RoundingMode.FLOOR;
        return this.vm.num.of(numer.divide(denom, 0, mode));
    }

    private HostResult opRemMethod(HostContext c, BigDecimal numer, BigDecimal denom) {
        if (denom.signum() == 0) {
            return c.raise(String.format(Locale.ROOT, "Num.op_rem: zero division: %s is divided by 0", numer.toPlainString()));
        }
        RoundingMode mode = denom.signum() < 0 ? RoundingMode.CEILING : RoundingMode.FLOOR;
        BigDecimal quot = numer.divide(denom, 0, mode);
        BigDecimal rem = numer.subtract(quot.multiply(denom));
        return this.vm.num.of(rem);
    }

    private HostResult roundMethod(CallContext c, NumVal num) {
        return c.call("kink/NUM_DIV", this.newHandle).args(c.recv(), (Val)this.vm.num.of(1));
    }

    private HostResult timesMethod(HostContext c, BigDecimal count) {
        if (count.scale() != 0 || count.signum() < 0) {
            return c.call(this.vm.graph.raiseFormat("Num.times: required nonnegative int as Num, but got {}", this.vm.graph.of(this.vm.num.of(count))));
        }
        return c.call("kink/iter/ITER", this.newHandle).args((Val)this.timesIfun(BigDecimal.ZERO, count));
    }

    private FunVal timesIfun(BigDecimal ind, BigDecimal count) {
        return this.makeIfun("Num.times-ifun", (c, proc, fin) -> ind.compareTo(count) < 0 ? c.call((FunVal)proc).args((Val)this.vm.num.of(ind), (Val)this.timesIfun(ind.add(BigDecimal.ONE), count)) : c.call((FunVal)fin));
    }

    private HostResult upMethod(HostContext c, BigDecimal start) {
        return c.call("kink/iter/ITER", this.newHandle).args((Val)this.upDownIfun("Num.up-ifun", start, BigDecimal.ONE));
    }

    private HostResult downMethod(HostContext c, BigDecimal start) {
        return c.call("kink/iter/ITER", this.newHandle).args((Val)this.upDownIfun("Num.down-ifun", start, BigDecimal.valueOf(-1L)));
    }

    private FunVal upDownIfun(String prefix, BigDecimal num, BigDecimal delta) {
        return this.makeIfun(prefix, (c, proc, fin) -> c.call((FunVal)proc).args((Val)this.vm.num.of(num), (Val)this.upDownIfun(prefix, num.add(delta), delta)));
    }

    private HostResult reprMethod(HostContext c, BigDecimal num) {
        return this.vm.str.of(num.scale() < 0 ? this.reprWithScale(num) : this.reprBasedOnPlain(num));
    }

    private String reprBasedOnPlain(BigDecimal num) {
        return num.signum() < 0 ? String.format(Locale.ROOT, "(%s)", num.toPlainString()) : num.toPlainString();
    }

    private String reprWithScale(BigDecimal num) {
        BigInteger mantissa = num.unscaledValue();
        int scale = num.scale();
        return String.format(Locale.ROOT, "(num mantissa=%d scale=%d)", mantissa, scale);
    }

    private HostResult showMethod(CallContext c) {
        if (!(c.recv() instanceof NumVal)) {
            return c.raise("Num.show: expected num as \\recv, but got non-num");
        }
        Val config = c.argCount() == 0 ? this.vm.fun.make().take(1).action(cc -> this.vm.nada) : c.arg(0);
        NumVal num = (NumVal)c.recv();
        return c.call("kink/NUM", this.showNumHandle).args((Val)num, config);
    }

    private FunVal unaryOp(String prefix, ThrowingFunction2<CallContext, BigDecimal, HostResult> op) {
        return this.vm.fun.make(prefix).take(0).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof NumVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required num as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)op.apply(c, ((NumVal)recv).bigDecimal());
        });
    }

    private FunVal binaryOp(String prefix, ThrowingFunction3<CallContext, BigDecimal, BigDecimal, HostResult> op) {
        return this.vm.fun.make(prefix).take(1).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof NumVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required num as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            Val a0 = c.arg(0);
            if (!(a0 instanceof NumVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: the arg must be a num, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(a0)));
            }
            return (HostResult)op.apply(c, ((NumVal)recv).bigDecimal(), ((NumVal)a0).bigDecimal());
        });
    }

    private FunVal unaryIntOp(String prefix, ThrowingFunction2<CallContext, BigInteger, HostResult> op) {
        return this.vm.fun.make(prefix).take(0).action(c -> {
            Val recv = c.recv();
            BigInteger recvInt = this.exactBigInt(recv);
            if (recvInt == null) {
                return c.call(this.vm.graph.raiseFormat("{}: required int num as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)op.apply(c, recvInt);
        });
    }

    private FunVal binaryIntOp(String prefix, ThrowingFunction3<CallContext, BigInteger, BigInteger, HostResult> op) {
        return this.vm.fun.make(prefix).take(1).action(c -> {
            Val recv = c.recv();
            BigInteger recvInt = this.exactBigInt(recv);
            if (recvInt == null) {
                return c.call(this.vm.graph.raiseFormat("{}: required int num as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            Val a0 = c.arg(0);
            BigInteger argInt = this.exactBigInt(a0);
            if (argInt == null) {
                return c.call(this.vm.graph.raiseFormat("{}: the arg must be an int num, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(a0)));
            }
            return (HostResult)op.apply(c, recvInt, argInt);
        });
    }

    private FunVal method0(String prefix, ThrowingFunction2<CallContext, NumVal, HostResult> action) {
        return this.vm.fun.make(prefix).take(0).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof NumVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required num as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)action.apply(c, (NumVal)recv);
        });
    }

    private FunVal shiftMethod(String prefix, ThrowingFunction2<BigInteger, Integer, BigInteger> action) {
        return this.vm.fun.make(prefix).take(1).action(c -> {
            Val recv = c.recv();
            BigInteger recvInt = this.exactBigInt(recv);
            if (recvInt == null) {
                return c.call(this.vm.graph.raiseFormat("{}: required int num as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            Val shift = c.arg(0);
            OptionalInt shiftInt = NumOperations.getExactInt(shift);
            if (!shiftInt.isPresent()) {
                return c.call(this.vm.graph.raiseFormat("{}: Bit_count must be an int num between [{}, {}], but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.of(this.vm.num.of(Integer.MIN_VALUE)), this.vm.graph.of(this.vm.num.of(Integer.MAX_VALUE)), this.vm.graph.repr(shift)));
            }
            return this.vm.num.of((BigInteger)action.apply(recvInt, shiftInt.getAsInt()));
        });
    }

    private BigInteger exactBigInt(Val val) {
        if (!(val instanceof NumVal)) {
            return null;
        }
        BigDecimal dec = ((NumVal)val).bigDecimal();
        try {
            return dec.toBigIntegerExact();
        }
        catch (ArithmeticException ex) {
            return null;
        }
    }

    private FunVal makeIfun(String prefix, ThrowingFunction3<CallContext, FunVal, FunVal, HostResult> action) {
        return this.vm.fun.make("Num.times-ifun").take(2).action(c -> {
            Val proc = c.arg(0);
            if (!(proc instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required fun as $proc, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(proc)));
            }
            Val fin = c.arg(1);
            if (!(fin instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required fun as $fin, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(fin)));
            }
            return (HostResult)action.apply(c, (FunVal)proc, (FunVal)fin);
        });
    }
}

