/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.kink_lang.kink.DataStack;
import org.kink_lang.kink.ExceptionVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.GeneratedFunValBase;
import org.kink_lang.kink.HostResultCore;
import org.kink_lang.kink.RaiseMessageResult;
import org.kink_lang.kink.RaiseThrowableResult;
import org.kink_lang.kink.RequireThenInvokeCallFlow;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.TraceVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.CallFlowToArgs;
import org.kink_lang.kink.hostfun.CallFlowToOn;
import org.kink_lang.kink.hostfun.CallFlowToRecv;
import org.kink_lang.kink.hostfun.HostFunReaction;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.callstack.CallStack;
import org.kink_lang.kink.internal.callstack.CallStackSlice;
import org.kink_lang.kink.internal.callstack.HostResumeCse;
import org.kink_lang.kink.internal.callstack.Lnums;
import org.kink_lang.kink.internal.callstack.ResumeCse;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.intrinsicsupport.FunsHolder;

class StackMachine {
    private final Vm vm;
    private final CallStack callStack;
    private final DataStack dataStack;
    private final int raiseHandle;
    private final int callHandle;
    private int argCount;
    private int state = 4;
    @Nullable
    private Object stateTransitionArg;
    private int currentContextIndex = 0;
    private final CallContext[] callContexts = new CallContext[13];
    @Nullable
    private Val recvInFlow;
    @Nullable
    private FunVal funInFlow;
    private int symHandleInFlow;
    final WithFunRecv flowWithFunRecv;
    final WithArgs flowWithArgs;
    private static final CallReaction CALL_REACTION = new CallReaction();

    StackMachine(Vm vm, CallStack callStack, DataStack dataStack) {
        for (int i = 0; i < this.callContexts.length; ++i) {
            this.callContexts[i] = new RoundRobinCallContext(i);
        }
        this.flowWithFunRecv = this.makeFlowWithFunRecv(new WithFunRecv());
        this.flowWithArgs = new WithArgs();
        this.vm = vm;
        this.callStack = callStack;
        this.dataStack = dataStack;
        this.raiseHandle = vm.sym.handleFor("raise");
        this.callHandle = vm.sym.handleFor("call");
    }

    StackMachine(Vm vm) {
        this(vm, new CallStack(100, 50000, 12), new DataStack(vm, 1000, 500000));
    }

    Vm getVm() {
        return this.vm;
    }

    Outcome run(FunVal fun) {
        final Trace trace = Trace.of(this.vm.sym.handleFor("(root)"));
        ResumeCse terminateFrame = new ResumeCse(){

            @Override
            public Trace trace(int programCounter) {
                return trace;
            }
        };
        this.callStack.pushCse(terminateFrame, 0, 0, 0);
        this.dataStack.push(this.vm.nada);
        this.transitionToCall(fun);
        return this.mainLoop();
    }

    CallStack getCallStack() {
        return this.callStack;
    }

    DataStack getDataStack() {
        return this.dataStack;
    }

    void resetArgCount() {
        int recvCount = 1;
        this.argCount = this.dataStack.topOffset() - recvCount;
    }

    private Outcome mainLoop() {
        while (this.state != 3) {
            int stateCopy = this.state;
            this.state = 4;
            Object argCopy = this.stateTransitionArg;
            this.stateTransitionArg = null;
            this.handle(stateCopy, argCopy);
        }
        return (Outcome)this.stateTransitionArg;
    }

    private void transition(int state, Object arg) {
        this.state = state;
        this.stateTransitionArg = arg;
    }

    void handle(int state, Object arg) {
        switch (state) {
            case 0: {
                this.handleCall((FunVal)arg);
                break;
            }
            case 1: {
                this.handleResult((Val)arg);
                break;
            }
            case 2: {
                this.handleHostResult((HostResultCore)arg);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    void transitionToTerminateWithVal(Val stackMachineResult) {
        this.transition(3, new Outcome.Returned(stackMachineResult));
    }

    void transitionToTerminatedWithException(ExceptionVal exc) {
        this.transition(3, new Outcome.Raised(exc));
    }

    void transitionToCall(FunVal fun) {
        this.transition(0, fun);
    }

    private void handleCall(FunVal fun) {
        this.resetArgCount();
        fun.run(this);
    }

    void transitionToResult(Val result) {
        this.transition(1, result);
    }

    void transitionToRaiseOn(String msg, Trace trace) {
        this.transitionToRaiseException(this.vm.exception.of(msg, this.getTracesOn(trace)));
    }

    private List<TraceVal> getTracesOn(Trace trace) {
        ArrayList<TraceVal> traces = new ArrayList<TraceVal>(this.callStack.traces().stream().map(traceCse -> traceCse.toTraceVal(this.vm)).collect(Collectors.toList()));
        traces.add(trace.toTraceVal(this.vm));
        return traces;
    }

    private FunVal makeRaiseFormatFun(List<? extends TraceVal> traces, String template, GraphNode ... args) {
        return this.vm.fun.make("(raise-after-format)").action(c -> {
            FunVal makeMessage = this.vm.fun.make().action(cc -> cc.call(this.vm.graph.format(template, args)));
            return c.call(makeMessage).on((cc, message) -> cc.call(this.exceptionRaiseCaller(message, traces)));
        });
    }

    FunVal exceptionRaiseCaller(Val messageVal, List<? extends TraceVal> traces) {
        return this.vm.fun.make().action(c -> {
            if (!(messageVal instanceof StrVal)) {
                return c.call(this.vm.graph.raiseFormat("Str.format must return str, but got {}", this.vm.graph.repr(messageVal)));
            }
            StrVal messageStr = (StrVal)messageVal;
            ExceptionVal exc = this.vm.exception.of(messageStr.string(), traces);
            return c.call(exc, this.raiseHandle);
        });
    }

    private void transitionToRaiseFormatOn(Trace trace, String template, GraphNode ... args) {
        FunVal fun = this.makeRaiseFormatFun(this.getTracesOn(trace), template, args);
        this.dataStack.removeFromOffset(0);
        this.dataStack.push(this.vm.nada);
        this.transitionToCall(fun);
    }

    void transitionToRaiseThrowable(Throwable th) {
        String message = String.format(Locale.ROOT, "java exception: %s", th);
        ExceptionVal exc = this.vm.exception.of(message, this.getTraces()).chain(this.vm.exception.of(th));
        this.transitionToRaiseException(exc);
    }

    void transitionToRaise(String msg) {
        ExceptionVal exc = this.vm.exception.of(msg, this.getTraces());
        this.transitionToRaiseException(exc);
    }

    void transitionToRaiseException(ExceptionVal exc) {
        if (this.callStack.canAbort(this.vm.escapeKontTag)) {
            CallStackSlice callSlice = this.callStack.abort(this.vm.escapeKontTag);
            int dataStackUsage = callSlice.dataStackUsage();
            this.dataStack.decreaseBp(dataStackUsage);
            this.dataStack.removeFromOffset(0);
            FunVal switchFun = this.vm.fun.make().take(2).action(c -> {
                Val onRaised = c.arg(0);
                if (!(onRaised instanceof FunVal)) {
                    return c.call(this.vm.graph.raiseFormat("expected fun, but got {}", this.vm.graph.repr(onRaised)));
                }
                FunVal onRaisedFun = (FunVal)onRaised;
                return c.call(onRaisedFun).args((Val)exc);
            });
            this.transitionToResult(switchFun);
        } else {
            this.transitionToTerminatedWithException(exc);
        }
    }

    private void handleResult(Val result) {
        ResumeCse frame = this.callStack.popResumer();
        long lnum = this.callStack.poppedLnum();
        this.dataStack.removeFromOffset(0);
        this.dataStack.decreaseBp(Lnums.getDataStackUsage(lnum));
        this.argCount = Lnums.getArgCount(lnum);
        if (frame instanceof GeneratedFunValBase) {
            GeneratedFunValBase fun = (GeneratedFunValBase)frame;
            this.dataStack.pop();
            fun.resume(this, result, Lnums.getProgramCounter(lnum));
        } else if (frame instanceof HostResumeCse) {
            HostResultCore hostResult;
            HostResumeCse f = (HostResumeCse)frame;
            try {
                hostResult = f.handler().reaction(this.nextCallContext(), result).makeHostResultCore();
            }
            catch (Throwable th) {
                this.transitionToRaiseThrowable(th);
                return;
            }
            this.transitionToHostResult(hostResult);
        } else {
            this.transitionToTerminateWithVal(result);
        }
    }

    void transitionToHostResult(HostResultCore hostResult) {
        this.transition(2, hostResult);
    }

    private void handleHostResult(HostResultCore hostResult) {
        hostResult.doTransition(this);
    }

    void transitionToCannotSpread(Trace trace, Val vecExpected) {
        this.transitionToRaiseFormatOn(trace, "cannot spread non-vec val: {}", this.vm.graph.repr(vecExpected));
    }

    void transitionToRaiseNoSuchVar(String sym, Val owner, Trace trace) {
        this.transitionToRaiseFormatOn(trace, "no such var: {} not found in {}", this.vm.graph.of(this.vm.str.of(sym)), this.vm.graph.repr(owner));
    }

    void tailCallFun(Trace trace, int argCountToPass) {
        int argsOffset = this.dataStack.topOffset() - argCountToPass;
        int recvOffset = argsOffset - 1;
        int funOffset = recvOffset - 1;
        FunVal fun = (FunVal)this.dataStack.atOffset(funOffset);
        this.dataStack.removeToOffset(recvOffset);
        this.callStack.pushTailTrace(trace);
        this.transitionToCall(fun);
    }

    void callFun(ResumeCse resumeCse, int resumeProgramCounter, int argCountToPass) {
        int argsOffset = this.dataStack.topOffset() - argCountToPass;
        int recvOffset = argsOffset - 1;
        int funOffset = recvOffset - 1;
        FunVal fun = (FunVal)this.dataStack.atOffset(funOffset);
        this.dataStack.setAtOffset(funOffset, this.vm.nada);
        if (!this.callStack.isModerateSize()) {
            this.transitionToRaise("call stack overflow");
            return;
        }
        this.callStack.pushCse(resumeCse, resumeProgramCounter, this.argCount, recvOffset);
        this.dataStack.increaseBp(recvOffset);
        this.transitionToCall(fun);
    }

    void raiseNotFun(Val funExpected, String sym, Trace errorTrace) {
        this.transitionToRaiseFormatOn(errorTrace, "not a fun: ${} is {}", this.vm.graph.of(this.vm.str.of(sym)), this.vm.graph.repr(funExpected));
    }

    void raiseWrongNumberOfArgs(int paramCount, String paramsRepr, VecVal args) {
        FunVal fun = FunsHolder.wrongNumberOfArgs(this.vm, paramCount, this.vm.graph.of(this.vm.str.of(paramsRepr)), args);
        this.dataStack.removeFromOffset(0);
        this.dataStack.push(this.vm.nada);
        this.transitionToCall(fun);
    }

    void raiseNotVecRhs(Val rhs) {
        FunVal fun = FunsHolder.raiseNotVecRhs(this.vm, rhs);
        this.dataStack.removeFromOffset(0);
        this.dataStack.push(this.vm.nada);
        this.transitionToCall(fun);
    }

    CallContext nextCallContext() {
        this.currentContextIndex = (this.currentContextIndex + 1) % this.callContexts.length;
        return this.callContexts[this.currentContextIndex];
    }

    Val getRecv() {
        return this.dataStack.recv();
    }

    int getArgCount() {
        return this.argCount;
    }

    Val getArg(int argIndex) {
        return this.dataStack.arg(argIndex);
    }

    List<TraceVal> getTraces() {
        return new ArrayList<TraceVal>(this.callStack.traces().stream().map(traceCse -> traceCse.toTraceVal(this.vm)).collect(Collectors.toList()));
    }

    WithFunRecv makeFlowWithFunRecv(WithFunRecv flow) {
        return flow;
    }

    static class State {
        public static final int CALL = 0;
        public static final int CONSUME = 1;
        public static final int HOST_RESULT = 2;
        public static final int TERMINATE = 3;
        public static final int BETWEEN_TRANSITION = 4;

        State() {
            throw new UnsupportedOperationException("should not be instantiated");
        }
    }

    private class RoundRobinCallContext
    implements CallContext {
        private final int index;

        RoundRobinCallContext(int index) {
            this.index = index;
        }

        private void checkContextLeak() {
            Preconds.checkState(this.index == StackMachine.this.currentContextIndex, "context leak: CallContext instance used outside of the make or handler");
        }

        @Override
        public Val recv() {
            this.checkContextLeak();
            return StackMachine.this.getRecv();
        }

        @Override
        public int argCount() {
            this.checkContextLeak();
            return StackMachine.this.getArgCount();
        }

        @Override
        public Val arg(int argIndex) {
            this.checkContextLeak();
            return StackMachine.this.getArg(argIndex);
        }

        @Override
        public List<TraceVal> traces() {
            this.checkContextLeak();
            return StackMachine.this.getTraces();
        }

        @Override
        public HostResult raise(String msg) {
            this.checkContextLeak();
            return new RaiseMessageResult(msg);
        }

        @Override
        public HostResult raise(Throwable throwable) {
            this.checkContextLeak();
            return new RaiseThrowableResult(throwable);
        }

        @Override
        public CallFlowToRecv call(FunVal fun) {
            this.checkContextLeak();
            StackMachine.this.symHandleInFlow = StackMachine.this.callHandle;
            StackMachine.this.funInFlow = fun;
            StackMachine.this.recvInFlow = StackMachine.this.vm.nada;
            return StackMachine.this.flowWithFunRecv;
        }

        @Override
        public CallFlowToRecv call(Val owner, int symHandle) {
            String sym;
            this.checkContextLeak();
            StackMachine.this.symHandleInFlow = symHandle;
            Val funExpected = owner.getVar(symHandle);
            StackMachine.this.funInFlow = funExpected instanceof FunVal ? (FunVal)funExpected : (funExpected == null ? StackMachine.this.makeRaiseFormatFun(this.traces(), "no such var: ${} not found in {}", StackMachine.this.vm.graph.of(StackMachine.this.vm.str.of(StackMachine.this.vm.sym.symFor(symHandle))), StackMachine.this.vm.graph.repr(owner)) : ((sym = StackMachine.this.vm.sym.symFor(symHandle)).equals("repr") ? StackMachine.this.makeRaiseFormatFun(this.traces(), "not a fun: $repr is {}", StackMachine.this.vm.graph.repr(funExpected)) : StackMachine.this.makeRaiseFormatFun(this.traces(), "not a fun: ${} in {} is {}", StackMachine.this.vm.graph.of(StackMachine.this.vm.str.of(StackMachine.this.vm.sym.symFor(symHandle))), StackMachine.this.vm.graph.repr(owner), StackMachine.this.vm.graph.repr(funExpected))));
            StackMachine.this.recvInFlow = owner;
            return StackMachine.this.flowWithFunRecv;
        }

        @Override
        public CallFlowToArgs call(String modName, int symHandle) {
            Val loadedMod = StackMachine.this.vm.mod.getLoaded(modName);
            return loadedMod != null ? this.call(loadedMod, symHandle).recv(StackMachine.this.vm.nada) : new RequireThenInvokeCallFlow(StackMachine.this.vm, this, modName, symHandle, List.of());
        }

        @Override
        public CallFlowToOn call(GraphNode graph) {
            FunVal evaluator = StackMachine.this.vm.fun.make().action(graph::evaluateIn);
            return this.call(evaluator);
        }
    }

    class WithFunRecv
    implements CallFlowToRecv {
        WithFunRecv() {
        }

        @Override
        public CallFlowToArgs recv(Val recv) {
            StackMachine.this.recvInFlow = recv;
            return this;
        }

        @Nullable
        CallFlowToOn prepareArgs(int arity) {
            int recv = 1;
            if (!StackMachine.this.dataStack.ensureCapaSpPlus(recv + arity)) {
                StackMachine.this.funInFlow = null;
                StackMachine.this.recvInFlow = null;
                return new RaiseMessageResult("data stack overflow");
            }
            StackMachine.this.dataStack.push(StackMachine.this.recvInFlow);
            StackMachine.this.recvInFlow = null;
            return null;
        }

        @Override
        public CallFlowToOn args() {
            CallFlowToOn aborted = this.prepareArgs(0);
            if (aborted != null) {
                return aborted;
            }
            return StackMachine.this.flowWithArgs;
        }

        @Override
        public CallFlowToOn args(Val arg0) {
            CallFlowToOn aborted = this.prepareArgs(1);
            if (aborted != null) {
                return aborted;
            }
            StackMachine.this.dataStack.push(arg0);
            return StackMachine.this.flowWithArgs;
        }

        @Override
        public CallFlowToOn args(Val arg0, Val arg1) {
            CallFlowToOn aborted = this.prepareArgs(2);
            if (aborted != null) {
                return aborted;
            }
            StackMachine.this.dataStack.push(arg0);
            StackMachine.this.dataStack.push(arg1);
            return StackMachine.this.flowWithArgs;
        }

        @Override
        public CallFlowToOn args(Val arg0, Val arg1, Val arg2) {
            CallFlowToOn aborted = this.prepareArgs(3);
            if (aborted != null) {
                return aborted;
            }
            StackMachine.this.dataStack.push(arg0);
            StackMachine.this.dataStack.push(arg1);
            StackMachine.this.dataStack.push(arg2);
            return StackMachine.this.flowWithArgs;
        }

        @Override
        public CallFlowToOn args(Val arg0, Val arg1, Val arg2, Val arg3) {
            CallFlowToOn aborted = this.prepareArgs(4);
            if (aborted != null) {
                return aborted;
            }
            StackMachine.this.dataStack.push(arg0);
            StackMachine.this.dataStack.push(arg1);
            StackMachine.this.dataStack.push(arg2);
            StackMachine.this.dataStack.push(arg3);
            return StackMachine.this.flowWithArgs;
        }

        @Override
        public CallFlowToOn args(Val arg0, Val arg1, Val arg2, Val arg3, Val arg4) {
            CallFlowToOn aborted = this.prepareArgs(5);
            if (aborted != null) {
                return aborted;
            }
            StackMachine.this.dataStack.push(arg0);
            StackMachine.this.dataStack.push(arg1);
            StackMachine.this.dataStack.push(arg2);
            StackMachine.this.dataStack.push(arg3);
            StackMachine.this.dataStack.push(arg4);
            return StackMachine.this.flowWithArgs;
        }

        @Override
        public CallFlowToOn args(Val ... args) {
            CallFlowToOn aborted = this.prepareArgs(args.length);
            if (aborted != null) {
                return aborted;
            }
            for (Val arg : args) {
                StackMachine.this.dataStack.push(arg);
            }
            return StackMachine.this.flowWithArgs;
        }

        @Override
        public HostResult on(HostFunReaction retValHandler) {
            return this.args().on(retValHandler);
        }

        @Override
        public HostResultCore makeHostResultCore() {
            return this.args().makeHostResultCore();
        }
    }

    private class WithArgs
    extends HostResultCore
    implements CallFlowToOn,
    HostResult {
        private WithArgs() {
        }

        @Override
        public HostResult on(HostFunReaction handler) {
            if (!StackMachine.this.callStack.isModerateSize()) {
                StackMachine.this.funInFlow = null;
                StackMachine.this.recvInFlow = null;
                return new RaiseMessageResult("call stack overflow");
            }
            HostResumeCse frame = new HostResumeCse(handler, StackMachine.this.symHandleInFlow);
            int dataStackUsage = StackMachine.this.argCount + 1;
            StackMachine.this.callStack.pushCse(frame, 0, StackMachine.this.argCount, dataStackUsage);
            int recvCount = 1;
            StackMachine.this.dataStack.increaseBp(recvCount + StackMachine.this.argCount);
            return CALL_REACTION;
        }

        @Override
        void doTransition(StackMachine stackMachine) {
            int recvCount = 1;
            StackMachine.this.dataStack.removeToOffset(recvCount + StackMachine.this.argCount);
            Trace trace = Trace.ofTail(stackMachine.symHandleInFlow);
            stackMachine.callStack.pushTailTrace(trace);
            CALL_REACTION.doTransition(stackMachine);
        }

        @Override
        public HostResultCore makeHostResultCore() {
            return this;
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    static interface Outcome {

        public record Raised(ExceptionVal exception) implements Outcome
        {
        }

        public record Returned(Val val) implements Outcome
        {
        }
    }

    private static class CallReaction
    extends HostResultCore
    implements HostResult {
        private CallReaction() {
        }

        @Override
        void doTransition(StackMachine stackMachine) {
            FunVal fun = stackMachine.funInFlow;
            stackMachine.funInFlow = null;
            stackMachine.transitionToCall(fun);
        }

        @Override
        public HostResultCore makeHostResultCore() {
            return this;
        }
    }
}

