/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.function.ThrowingFunction4;
import org.kink_lang.kink.internal.num.NumOperations;

public class StrHelper {
    private final Vm vm;
    private int formatHandle;
    private int argHandle;
    int maxLength = Integer.MAX_VALUE;
    SharedVars sharedVars;
    private static final Map<Character, String> CHAR_TO_REPR;

    StrHelper(Vm vm) {
        this.vm = vm;
    }

    public StrVal of(String string) {
        return new StrVal(this.vm, string);
    }

    int getMaxLength() {
        return this.maxLength;
    }

    void init() {
        this.formatHandle = this.vm.sym.handleFor("format");
        this.argHandle = this.vm.sym.handleFor("arg");
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        vars.put(this.vm.sym.handleFor("op_add"), this.method1("Str.op_add(Arg_str)", this::opAddMethod));
        vars.put(this.vm.sym.handleFor("runes"), this.unaryOp("Str.runes", this::runesMethod));
        vars.put(this.vm.sym.handleFor("empty?"), this.unaryOp("Str.empty?", s -> this.vm.bool.of(s.isEmpty())));
        vars.put(this.vm.sym.handleFor("size"), this.unaryOp("Str.size", this::sizeMethod));
        vars.put(this.vm.sym.handleFor("get"), this.method1("Str.get(Rune_index)", this::getMethod));
        vars.put(this.vm.sym.handleFor("slice"), this.method2("Str.slice(From_pos To_pos)", this::sliceMethod));
        vars.put(this.vm.sym.handleFor("take_front"), this.takeDropMethod("Str.take_front(N)", 0, 0, 1, 0));
        vars.put(this.vm.sym.handleFor("take_back"), this.takeDropMethod("Str.take_back(N)", -1, 1, 0, 1));
        vars.put(this.vm.sym.handleFor("drop_front"), this.takeDropMethod("Str.drop_front(N)", 1, 0, 0, 1));
        vars.put(this.vm.sym.handleFor("drop_back"), this.takeDropMethod("Str.drop_back(N)", 0, 0, -1, 1));
        vars.put(this.vm.sym.handleFor("search_slice"), this.method2("Str.search_slice(Min_ind Slice)", this::searchSliceMethod));
        vars.put(this.vm.sym.handleFor("have_prefix?"), this.binaryOp("Str.have_prefix?", (text, pat) -> this.vm.bool.of(text.startsWith((String)pat))));
        vars.put(this.vm.sym.handleFor("have_suffix?"), this.binaryOp("Str.have_suffix?", (text, pat) -> this.vm.bool.of(text.endsWith((String)pat))));
        vars.put(this.vm.sym.handleFor("have_slice?"), this.binaryOp("Str.have_slice?(Slice)", (text, pat) -> this.vm.bool.of(text.contains((CharSequence)pat))));
        vars.put(this.vm.sym.handleFor("trim"), this.unaryOp("Str.trim", s -> this.vm.str.of(s.trim())));
        vars.put(this.vm.sym.handleFor("ascii_upcase"), this.unaryOp("Str.ascii_upcase", this::asciiUpcaseMethod));
        vars.put(this.vm.sym.handleFor("ascii_downcase"), this.unaryOp("Str.ascii_downcase", this::asciiDowncaseMethod));
        vars.put(this.vm.sym.handleFor("format"), this.vm.fun.make("Str.format").action(this::formatMethod));
        vars.put(this.vm.sym.handleFor("op_mul"), this.method1("Str.op_mul(Count)", this::opMulMethod));
        vars.put(this.vm.sym.handleFor("op_lt"), this.binaryOp("Str.op_lt", (x, y) -> this.vm.bool.of(this.lessThanByRunes((String)x, (String)y))));
        vars.put(this.vm.sym.handleFor("op_eq"), this.binaryOp("Str.op_eq", (x, y) -> this.vm.bool.of(x.equals(y))));
        vars.put(this.vm.sym.handleFor("repr"), this.unaryOp("Str.repr", this::reprMethod));
        vars.put(this.vm.sym.handleFor("show"), this.vm.fun.make("Str.show").takeMinMax(0, 1).action(this::showMethod));
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult opAddMethod(HostContext c, StrVal str, Val argStrVal) {
        if (!(argStrVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("Str.op_add(Arg_str): required str as Arg_str, but got {}", this.vm.graph.repr(argStrVal)));
        }
        StrVal argStr = (StrVal)argStrVal;
        if ((long)str.length() + (long)argStr.length() > (long)this.vm.str.getMaxLength()) {
            return c.raise("Str.op_add(Arg_str): too long result");
        }
        return str.concat(argStr);
    }

    private HostResult runesMethod(String str) {
        List runes = str.codePoints().mapToObj(rune -> this.vm.num.of(rune)).collect(Collectors.toList());
        return this.vm.vec.of(runes);
    }

    private HostResult sizeMethod(String str) {
        return this.vm.num.of(str.codePointCount(0, str.length()));
    }

    private HostResult getMethod(HostContext c, StrVal strVal, Val runeIndexVal) {
        String str = strVal.string();
        int runeCount = str.codePointCount(0, str.length());
        int runeIndex = NumOperations.getElemIndex(runeIndexVal, runeCount);
        if (runeIndex < 0) {
            return c.call(this.vm.graph.raiseFormat("Str.get(Rune_index): Rune_index must be an int num in [0, {}), but got {}", this.vm.graph.of(this.vm.num.of(runeCount)), this.vm.graph.repr(runeIndexVal)));
        }
        int index = str.offsetByCodePoints(0, runeIndex);
        int rune = str.codePointAt(index);
        return this.vm.num.of(rune);
    }

    private HostResult sliceMethod(HostContext c, String str, Val fromVal, Val toVal) {
        int runeCount;
        String desc = "Str.slice(From_pos To_pos)";
        if (!(fromVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: From_pos must be a num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(fromVal)));
        }
        BigDecimal fromDec = ((NumVal)fromVal).bigDecimal();
        if (!(toVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: To_pos must be a num, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(toVal)));
        }
        BigDecimal toDec = ((NumVal)toVal).bigDecimal();
        if (!NumOperations.isRangePair(fromDec, toDec, runeCount = str.codePointCount(0, str.length()))) {
            return c.call(this.vm.graph.raiseFormat("{}: required index pair in [0, {}], but got {} and {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(runeCount)), this.vm.graph.repr(fromVal), this.vm.graph.repr(toVal)));
        }
        int fromRuneInd = fromDec.intValueExact();
        int toRuneInd = toDec.intValueExact();
        int fromInd = str.offsetByCodePoints(0, fromRuneInd);
        int toInd = str.offsetByCodePoints(0, toRuneInd);
        return this.vm.str.of(str.substring(fromInd, toInd));
    }

    private FunVal takeDropMethod(String prefix, int fromNumCoef, int fromSizeCoef, int toNumCoef, int toSizeCoef) {
        return this.method1(prefix, (c, strVal, numVal) -> {
            String str = strVal.string();
            int runeCount = str.codePointCount(0, str.length());
            int num = NumOperations.getPosIndex(numVal, runeCount);
            if (num < 0) {
                return c.call(this.vm.graph.raiseFormat("{}: N must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.of(this.vm.num.of(runeCount)), this.vm.graph.repr((Val)numVal)));
            }
            int fromRuneInd = fromNumCoef * num + fromSizeCoef * runeCount;
            int toRuneInd = toNumCoef * num + toSizeCoef * runeCount;
            int fromCharInd = str.offsetByCodePoints(0, fromRuneInd);
            int toCharInd = str.offsetByCodePoints(0, toRuneInd);
            return this.vm.str.of(str.substring(fromCharInd, toCharInd));
        });
    }

    private HostResult searchSliceMethod(CallContext c, String str, Val minIndVal, Val sliceStrVal) {
        String prefix = "Str.search_slice(Min_ind Slice)";
        if (!(sliceStrVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: required str for Slice, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(sliceStrVal)));
        }
        String slice = ((StrVal)sliceStrVal).string();
        int runeCount = str.codePointCount(0, str.length());
        int minRuneInd = NumOperations.getPosIndex(minIndVal, runeCount);
        if (minRuneInd < 0) {
            return c.call(this.vm.graph.raiseFormat("{}: required int num in [0, {}] for Min_ind, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.of(this.vm.num.of(runeCount)), this.vm.graph.repr(minIndVal)));
        }
        int minCharInd = str.offsetByCodePoints(0, minRuneInd);
        int charInd = str.indexOf(slice, minCharInd);
        if (charInd < 0) {
            return this.vm.vec.of();
        }
        int runeInd = str.codePointCount(0, charInd);
        return this.vm.vec.of((Val)this.vm.num.of(runeInd));
    }

    private HostResult asciiUpcaseMethod(String src) {
        StringBuilder sb = new StringBuilder(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            char dest = 'a' <= ch && ch <= 'z' ? (char)(ch + -32) : ch;
            sb.append(dest);
        }
        return this.vm.str.of(sb.toString());
    }

    private HostResult asciiDowncaseMethod(String src) {
        StringBuilder sb = new StringBuilder(src.length());
        for (int i = 0; i < src.length(); ++i) {
            char ch = src.charAt(i);
            char dest = 'A' <= ch && ch <= 'Z' ? (char)(ch + 32) : ch;
            sb.append(dest);
        }
        return this.vm.str.of(sb.toString());
    }

    private HostResult formatMethod(CallContext c) {
        Val template = c.recv();
        if (!(template instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("Str.format(,,,): required a str for Str, but got {}", this.vm.graph.repr(template)));
        }
        if (c.argCount() == 1 && c.arg(0) instanceof FunVal) {
            FunVal config = (FunVal)c.arg(0);
            return c.call("kink/_str/FORMAT", this.formatHandle).args(template, (Val)config);
        }
        List args = IntStream.range(0, c.argCount()).mapToObj(i -> c.arg(i)).collect(Collectors.toList());
        FunVal config = this.vm.fun.make().take(1).action(cc -> this.formatMethodConfigAux(cc, cc.arg(0), args));
        return c.call("kink/_str/FORMAT", this.formatHandle).args(template, (Val)config);
    }

    private HostResult formatMethodConfigAux(HostContext c, Val conf, List<Val> args) {
        if (args.isEmpty()) {
            return this.vm.nada;
        }
        return c.call(conf, this.argHandle).args(args.get(0)).on((cc, r) -> this.formatMethodConfigAux(cc, conf, args.subList(1, args.size())));
    }

    private HostResult opMulMethod(HostContext c, StrVal strVal, Val countVal) {
        String str = strVal.string();
        BigInteger count = NumOperations.getExactBigInteger(countVal);
        if (count == null || count.signum() < 0) {
            return c.call(this.vm.graph.raiseFormat("Str.op_mul(Count): required int num >=0 for Count, but got {}", this.vm.graph.repr(countVal)));
        }
        if (str.isEmpty()) {
            return this.vm.str.of("");
        }
        BigInteger resultLen = count.multiply(BigInteger.valueOf(str.length()));
        if (resultLen.compareTo(BigInteger.valueOf(this.vm.str.getMaxLength())) > 0) {
            return c.raise("Str.op_mul(Count): too long result");
        }
        StringBuilder sb = new StringBuilder();
        int countInt = count.intValueExact();
        for (int i = 0; i < countInt; ++i) {
            sb.append(str);
        }
        return this.vm.str.of(sb.toString());
    }

    private boolean lessThanByRunes(String x, String y) {
        int xi = 0;
        int yi = 0;
        while (yi < y.length()) {
            int yrune;
            if (xi >= x.length()) {
                return true;
            }
            int xrune = x.codePointAt(xi);
            if (xrune < (yrune = y.codePointAt(yi))) {
                return true;
            }
            if (xrune > yrune) {
                return false;
            }
            xi = x.offsetByCodePoints(xi, 1);
            yi = y.offsetByCodePoints(yi, 1);
        }
        return false;
    }

    StrVal reprMethod(String src) {
        StringBuilder sb = new StringBuilder("\"");
        for (char ch : src.toCharArray()) {
            String repr = CHAR_TO_REPR.getOrDefault(Character.valueOf(ch), Character.toString(ch));
            sb.append(repr);
        }
        sb.append('\"');
        return this.vm.str.of(sb.toString());
    }

    private HostResult showMethod(CallContext c) {
        return c.recv();
    }

    private FunVal unaryOp(String prefix, Function<String, HostResult> action) {
        return this.vm.fun.make(prefix).take(0).action(c -> {
            if (!(c.recv() instanceof StrVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required str as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(c.recv())));
            }
            String recv = ((StrVal)c.recv()).string();
            return (HostResult)action.apply(recv);
        });
    }

    private FunVal binaryOp(String prefix, BiFunction<String, String, HostResult> action) {
        return this.vm.fun.make(prefix).take(1).action(c -> {
            if (!(c.recv() instanceof StrVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required str as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(c.recv())));
            }
            String recv = ((StrVal)c.recv()).string();
            Val argVal = c.arg(0);
            if (!(argVal instanceof StrVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: the arg must be a str, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(argVal)));
            }
            String arg = ((StrVal)argVal).string();
            return (HostResult)action.apply(recv, arg);
        });
    }

    private FunVal method1(String prefix, ThrowingFunction3<CallContext, StrVal, Val, HostResult> action) {
        return this.vm.fun.make(prefix).take(1).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof StrVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required str as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)action.apply(c, (StrVal)recv, c.arg(0));
        });
    }

    private FunVal method2(String prefix, ThrowingFunction4<CallContext, String, Val, Val, HostResult> action) {
        return this.vm.fun.make(prefix).take(2).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof StrVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required str as \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)action.apply(c, ((StrVal)recv).string(), c.arg(0), c.arg(1));
        });
    }

    static {
        HashMap<Character, String> map = new HashMap<Character, String>();
        map.put(Character.valueOf('\u0000'), "\\0");
        map.put(Character.valueOf('\u0007'), "\\a");
        map.put(Character.valueOf('\b'), "\\b");
        map.put(Character.valueOf('\t'), "\\t");
        map.put(Character.valueOf('\n'), "\\n");
        map.put(Character.valueOf('\u000b'), "\\v");
        map.put(Character.valueOf('\f'), "\\f");
        map.put(Character.valueOf('\r'), "\\r");
        map.put(Character.valueOf('\u001b'), "\\e");
        map.put(Character.valueOf('\"'), "\\\"");
        map.put(Character.valueOf('\\'), "\\\\");
        map.put(Character.valueOf('\u007f'), "\\x{00007f}");
        for (char ch = '\u0001'; ch <= '\u001f'; ch = (char)(ch + '\u0001')) {
            map.putIfAbsent(Character.valueOf(ch), String.format(Locale.ROOT, "\\x{%06x}", (int)ch));
        }
        CHAR_TO_REPR = Collections.unmodifiableMap(map);
    }
}

