/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.contract.Preconds;

public class StrVal
extends Val {
    private Node node;

    StrVal(Vm vm, String string) {
        this(vm, new Leaf(string));
    }

    private StrVal(Vm vm, Node node) {
        super(vm, null);
        Preconds.checkArg(node.length() <= vm.str.getMaxLength(), "length must not exceed the max");
        this.node = node;
    }

    public String string() {
        Leaf leaf = this.node.asLeaf();
        this.node = leaf;
        return leaf.string();
    }

    int length() {
        return this.node.length();
    }

    public StrVal concat(StrVal tail) {
        Preconds.checkArg((long)this.length() + (long)tail.length() <= (long)this.vm.str.getMaxLength(), "length must not exceed the max");
        if (this.length() == 0) {
            return tail;
        }
        if (tail.length() == 0) {
            return this;
        }
        Node left = this.node;
        Node right = tail.node;
        int leafCountSum = left.leafCount() + right.leafCount();
        Node resultNode = leafCountSum < 512 ? new Tree(left, right) : Leaf.substantiate(List.of(right, left));
        return new StrVal(this.vm, resultNode);
    }

    @Override
    SharedVars sharedVars() {
        return this.vm.str.sharedVars;
    }

    public String toString() {
        return String.format(Locale.ROOT, "StrVal(%s)", this.string());
    }

    private List<Object> properties() {
        return List.of(this.vm, this.string());
    }

    public int hashCode() {
        return this.properties().hashCode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object arg) {
        if (arg == this) return true;
        if (!(arg instanceof StrVal)) return false;
        StrVal argStr = (StrVal)arg;
        if (!this.properties().equals(argStr.properties())) return false;
        return true;
    }

    private static class Leaf
    extends Node {
        private final String string;

        Leaf(String string) {
            this.string = string;
        }

        @Override
        int length() {
            return this.string.length();
        }

        @Override
        int leafCount() {
            return 1;
        }

        @Override
        Leaf asLeaf() {
            return this;
        }

        String string() {
            return this.string;
        }

        static Leaf substantiate(List<Node> initialStack) {
            int length = initialStack.stream().mapToInt(n -> n.length()).sum();
            ArrayList<Node> stack = new ArrayList<Node>(initialStack);
            StringBuilder builder = new StringBuilder(length);
            while (!stack.isEmpty()) {
                Node node = (Node)stack.remove(stack.size() - 1);
                if (node instanceof Leaf) {
                    Leaf leaf = (Leaf)node;
                    builder.append(leaf.string());
                    continue;
                }
                Tree tree = (Tree)node;
                stack.add(tree.right());
                stack.add(tree.left());
            }
            return new Leaf(builder.toString());
        }
    }

    private static abstract class Node {
        private Node() {
        }

        abstract int length();

        abstract int leafCount();

        abstract Leaf asLeaf();
    }

    private static class Tree
    extends Node {
        private final int length;
        private final int leafCount;
        private final Node left;
        private final Node right;

        Tree(Node left, Node right) {
            this.length = left.length() + right.length();
            this.leafCount = left.leafCount() + right.leafCount();
            this.left = left;
            this.right = right;
        }

        Node left() {
            return this.left;
        }

        Node right() {
            return this.right;
        }

        @Override
        int length() {
            return this.length;
        }

        @Override
        int leafCount() {
            return this.leafCount;
        }

        @Override
        Leaf asLeaf() {
            return Leaf.substantiate(List.of(this));
        }
    }
}

