/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VarrefVal;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostFunReaction;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.function.ThrowingFunction2;
import org.kink_lang.kink.internal.function.ThrowingFunction3;
import org.kink_lang.kink.internal.function.ThrowingFunction4;
import org.kink_lang.kink.internal.intrinsicsupport.FunsHolder;
import org.kink_lang.kink.internal.num.NumOperations;
import org.kink_lang.kink.internal.vec.VecInternal;

public class VecHelper {
    private final Vm vm;
    private VecInternal empty;
    private int storeHandle;
    private int passArgHandle;
    private int passNothingHandle;
    private int passRestHandle;
    private int opEqHandle;
    private int opLtHandle;
    private int reprVecHandle;
    private int eachHandle;
    private int sortHandle;
    private int allP;
    private int anyP;
    private int haveP;
    private FunVal defaultPrecedesFun;
    SharedVars sharedVars;

    VecHelper(Vm vm) {
        this.vm = vm;
    }

    void init() {
        this.empty = VecInternal.of(this.vm, new Val[0], 0, 0);
        this.storeHandle = this.vm.sym.handleFor("op_store");
        this.passArgHandle = this.vm.sym.handleFor("pass_arg");
        this.passNothingHandle = this.vm.sym.handleFor("pass_nothing");
        this.passRestHandle = this.vm.sym.handleFor("pass_rest");
        this.opEqHandle = this.vm.sym.handleFor("op_eq");
        this.opLtHandle = this.vm.sym.handleFor("op_lt");
        this.reprVecHandle = this.vm.sym.handleFor("repr_vec");
        this.eachHandle = this.vm.sym.handleFor("each");
        this.sortHandle = this.vm.sym.handleFor("sort");
        this.allP = this.vm.sym.handleFor("all?");
        this.anyP = this.vm.sym.handleFor("any?");
        this.haveP = this.vm.sym.handleFor("have?");
        this.defaultPrecedesFun = this.vm.fun.make("(compare)").take(2).action(c -> c.call(c.arg(0), this.opLtHandle).args(c.arg(1)));
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        vars.put(this.vm.sym.handleFor("size"), this.method0("Vec.size", (c, vec) -> this.vm.num.of(vec.vecInternal().size())));
        vars.put(this.vm.sym.handleFor("empty?"), this.method0("Vec.empty?", (c, vec) -> this.vm.bool.of(vec.vecInternal().size() == 0)));
        vars.put(this.vm.sym.handleFor("get"), this.method1("Vec.get(Ind)", this::getMethod));
        vars.put(this.vm.sym.handleFor("front"), this.method0("Vec.front", this::frontMethod));
        vars.put(this.vm.sym.handleFor("back"), this.method0("Vec.back", this::backMethod));
        vars.put(this.vm.sym.handleFor("set"), this.method2("Vec.set(Ind Elem)", this::setMethod));
        vars.put(this.vm.sym.handleFor("dup"), this.method0("Vec.dup", this::dupMethod));
        vars.put(this.vm.sym.handleFor("rev"), this.method0("Vec.rev", this::revMethod));
        vars.put(this.vm.sym.handleFor("take_front"), this.takeDropMethod("Vec.take_front(N)", 0, 0, 1, 0));
        vars.put(this.vm.sym.handleFor("take_back"), this.takeDropMethod("Vec.take_back(N)", -1, 1, 0, 1));
        vars.put(this.vm.sym.handleFor("drop_front"), this.takeDropMethod("Vec.drop_front(N)", 1, 0, 0, 1));
        vars.put(this.vm.sym.handleFor("drop_back"), this.takeDropMethod("Vec.drop_back(N)", 0, 0, -1, 1));
        vars.put(this.vm.sym.handleFor("slice"), this.method2("Vec.slice(From_pos To_pos)", this::sliceMethod));
        vars.put(this.vm.sym.handleFor("clear"), this.method0("Vec.clear", this::clearMethod));
        vars.put(this.vm.sym.handleFor("clear_slice"), this.method2("Vec.clear_slice(From_pos To_pos)", this::clearSliceMethod));
        vars.put(this.vm.sym.handleFor("push_front"), this.method1("Vec.push_front(Elem)", this::pushFront));
        vars.put(this.vm.sym.handleFor("push_back"), this.method1("Vec.push_back(Elem)", this::pushBack));
        vars.put(this.vm.sym.handleFor("push_at"), this.method2("Vec.push_at(Ind Elem)", this::pushAt));
        vars.put(this.vm.sym.handleFor("push_each_front"), this.method1("Vec.push_each_front(Eacher)", this::pushEachFront));
        vars.put(this.vm.sym.handleFor("push_each_back"), this.method1("Vec.push_each_back(Eacher)", this::pushEachBack));
        vars.put(this.vm.sym.handleFor("push_each_at"), this.method2("Vec.push_each_at(Ind Eacher)", this::pushEachAt));
        vars.put(this.vm.sym.handleFor("pop_front"), this.method0("Vec.pop_front", this::popFrontMethod));
        vars.put(this.vm.sym.handleFor("pop_back"), this.method0("Vec.pop_back", this::popBackMethod));
        vars.put(this.vm.sym.handleFor("pop_at"), this.method1("Vec.pop_at(Ind)", this::popAtMethod));
        vars.put(this.vm.sym.handleFor("concat"), this.method0("Vec.concat", this::concatMethod));
        vars.put(this.vm.sym.handleFor("chunk"), this.method1("Vec.chunk(Chunk_size)", this::chunkMethod));
        vars.put(this.vm.sym.handleFor("just"), this.method0("Vec.just", this::justMethod));
        vars.put(this.vm.sym.handleFor("just_or"), this.method1("Vec.just_or", this::justOrMethod));
        vars.put(this.vm.sym.handleFor("with_just_or"), this.method2("Vec.with_just_or($on_just $on_empty)", this::withJustOrMethod));
        vars.put(this.vm.sym.handleFor("each"), this.method1("Vec.each($on_elem)", this::eachMethod));
        vars.put(this.vm.sym.handleFor("map"), this.method1("Vec.map($trans)", this::mapMethod));
        vars.put(this.vm.sym.handleFor("concat_map"), this.method1("Vec.concat_map($trans_to_vec)", this::concatMapMethod));
        vars.put(this.vm.sym.handleFor("filter"), this.method1("Vec.filter($match?)", this::filterMethod));
        vars.put(this.vm.sym.handleFor("count"), this.method1("Vec.count($match?)", this::countMethod));
        vars.put(this.vm.sym.handleFor("fold"), this.method2("Vec.fold(Init $combine)", this::foldMethod));
        vars.put(this.vm.sym.handleFor("reduce"), this.method1("Vec.reduce", this::reduceMethod));
        vars.put(this.vm.sym.handleFor("scan"), this.method2("Vec.scan(Init $combine)", this::scanMethod));
        vars.put(this.vm.sym.handleFor("scan_inside"), this.method1("Vec.scan_inside($combine)", this::scanInsideMethod));
        vars.put(this.vm.sym.handleFor("take_while"), this.method1("Vec.take_while($match?)", this::takeWhileMethod));
        vars.put(this.vm.sym.handleFor("drop_while"), this.method1("Vec.drop_while($match?)", this::dropWhileMethod));
        vars.put(this.vm.sym.handleFor("all?"), this.method1("Vec.all?($match?)", this::allPMethod));
        vars.put(this.vm.sym.handleFor("any?"), this.method1("Vec.any?($match?)", this::anyPMethod));
        vars.put(this.vm.sym.handleFor("have?"), this.method1("Vec.have?", this::havePMethod));
        vars.put(this.vm.sym.handleFor("have_all?"), this.method1("Vec.have_all?(For_aller)", this::haveAllPMethod));
        vars.put(this.vm.sym.handleFor("have_any?"), this.method1("Vec.have_any??(For_anyer)", this::haveAnyPMethod));
        vars.put(this.vm.sym.handleFor("search"), this.method2("Vec.search(Min_ind $accept?)", this::searchMethod));
        vars.put(this.vm.sym.handleFor("sort"), this.vm.fun.make("Vec.sort($precede?)").takeMinMax(0, 1).action(this::sortMethod));
        vars.put(this.vm.sym.handleFor("iter"), this.method0("Vec.iter", this::iterMethod));
        vars.put(this.vm.sym.handleFor("iter_from"), this.method1("Vec.iter_from(Min_ind)", this::iterFromMethod));
        vars.put(this.vm.sym.handleFor("op_add"), this.binOp("Vec.op_add", this::opAddMethod));
        vars.put(this.storeHandle, this.method1("Vec.op_store(Rhs)", this::opStoreMethod));
        vars.put(this.vm.sym.handleFor("op_mul"), this.method1("Vec.op_mul(Count)", this::opMulMethod));
        vars.put(this.opEqHandle, this.binOp("Vec1.op_eq(Vec2)", this::opEqMethod));
        vars.put(this.vm.sym.handleFor("op_lt"), this.binOp("Vec1.op_lt(Vec2)", this::opLtMethod));
        vars.put(this.vm.sym.handleFor("repr"), this.method0("Vec.repr", this::reprMethod));
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult getMethod(HostContext c, VecVal vec, Val indVal) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getElemIndex(indVal, size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.get(Ind): required int num in [0, {}) for Ind, but got {}", this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indVal)));
        }
        return vecInternal.get(ind);
    }

    private HostResult frontMethod(HostContext c, VecVal vec) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return c.raise("Vec.front: vec is empty");
        }
        return vecInternal.get(0);
    }

    private HostResult backMethod(HostContext c, VecVal vec) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return c.raise("Vec.back: vec is empty");
        }
        return vecInternal.get(size - 1);
    }

    private HostResult setMethod(HostContext c, VecVal vec, Val indVal, Val elem) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getElemIndex(indVal, size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.set(Ind Elem): required int num in [0, {}) for Ind, but got {}", this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indVal)));
        }
        vec.setVecInternal(vecInternal.set(ind, elem));
        return this.vm.nada;
    }

    private HostResult dupMethod(HostContext c, VecVal vec) {
        VecInternal vecInternal = vec.vecInternal();
        return new VecVal(this.vm, vecInternal.copy());
    }

    private HostResult revMethod(HostContext c, VecVal vec) {
        VecInternal src = vec.vecInternal();
        int size = src.size();
        VecInternal dest = VecInternal.ofCapa(this.vm, size);
        for (int i = 0; i < size; ++i) {
            dest = dest.append(src.get(size - i - 1));
        }
        return new VecVal(this.vm, dest);
    }

    private FunVal takeDropMethod(String prefix, int fromNumCoef, int fromSizeCoef, int toNumCoef, int toSizeCoef) {
        return this.vm.fun.make(prefix).take(1).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required vec for \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            VecInternal vecInternal = ((VecVal)recv).vecInternal();
            int size = vecInternal.size();
            Val numVal = c.arg(0);
            int num = NumOperations.getPosIndex(numVal, size);
            if (num < 0) {
                return c.call(this.vm.graph.raiseFormat("{}: N must be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(numVal)));
            }
            int from = fromNumCoef * num + fromSizeCoef * size;
            int to = toNumCoef * num + toSizeCoef * size;
            return new VecVal(this.vm, vecInternal.copyRange(from, to));
        });
    }

    private HostResult sliceMethod(HostContext c, VecVal vec, Val fromVal, Val toVal) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        GraphNode error = this.checkRange("Vec.slice(From_pos To_pos)", size, fromVal, toVal);
        if (error != null) {
            return c.call(error);
        }
        BigDecimal from = ((NumVal)fromVal).bigDecimal();
        BigDecimal to = ((NumVal)toVal).bigDecimal();
        return new VecVal(this.vm, vecInternal.copyRange(from.intValue(), to.intValue()));
    }

    private HostResult clearMethod(HostContext c, VecVal vec) {
        vec.setVecInternal(this.empty);
        return this.vm.nada;
    }

    private HostResult clearSliceMethod(HostContext c, VecVal vec, Val fromVal, Val toVal) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        GraphNode error = this.checkRange("Vec.clear_slice(From_pos To_pos)", size, fromVal, toVal);
        if (error != null) {
            return c.call(error);
        }
        BigDecimal from = ((NumVal)fromVal).bigDecimal();
        BigDecimal to = ((NumVal)toVal).bigDecimal();
        vec.setVecInternal(vecInternal.removeRange(from.intValue(), to.intValue()));
        return this.vm.nada;
    }

    private HostResult pushFront(HostContext c, VecVal vec, Val elem) {
        VecInternal vecInternal = vec.vecInternal();
        vec.setVecInternal(vecInternal.insert(0, elem));
        return this.vm.nada;
    }

    private HostResult pushBack(HostContext c, VecVal vec, Val elem) {
        VecInternal vecInternal = vec.vecInternal();
        vec.setVecInternal(vecInternal.append(elem));
        return this.vm.nada;
    }

    private HostResult pushAt(HostContext c, VecVal vec, Val indVal, Val elem) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getPosIndex(indVal, size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.push_at(Ind Elem): required int num in [0, {}] for Ind, but got {}", this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indVal)));
        }
        vecInternal = vecInternal.insert(ind, elem);
        vec.setVecInternal(vecInternal);
        return this.vm.nada;
    }

    private HostResult pushEachFront(HostContext c, VecVal vec, Val eacherVal) {
        if (eacherVal instanceof VecVal) {
            VecInternal vecInternal = vec.vecInternal();
            VecInternal eacher = ((VecVal)eacherVal).vecInternal();
            vec.setVecInternal(vecInternal.insertAll(0, eacher));
            return this.vm.nada;
        }
        if (eacherVal.hasVar(this.eachHandle)) {
            return c.call(eacherVal, this.eachHandle).args((Val)this.pushEachAtConsume(vec, 0));
        }
        return c.call(this.vm.graph.raiseFormat("Vec.push_each_front(Eacher): required Eacher supporting .each, but got {}", this.vm.graph.repr(eacherVal)));
    }

    private HostResult pushEachBack(HostContext c, VecVal vec, Val eacherVal) {
        if (eacherVal instanceof VecVal) {
            VecInternal vecInternal = vec.vecInternal();
            int size = vecInternal.size();
            VecInternal eacher = ((VecVal)eacherVal).vecInternal();
            vec.setVecInternal(vecInternal.insertAll(size, eacher));
            return this.vm.nada;
        }
        if (eacherVal.hasVar(this.eachHandle)) {
            return c.call(eacherVal, this.eachHandle).args((Val)this.pushEachBackConsume(vec));
        }
        return c.call(this.vm.graph.raiseFormat("Vec.push_each_back(Eacher): required Eacher supporting .each, but got {}", this.vm.graph.repr(eacherVal)));
    }

    private FunVal pushEachBackConsume(VecVal vec) {
        return this.vm.fun.make("Vec.push_each_back-call").take(1).action(c -> {
            VecInternal vecInternal = vec.vecInternal();
            vec.setVecInternal(vecInternal.append(c.arg(0)));
            return this.vm.nada;
        });
    }

    private HostResult pushEachAt(HostContext c, VecVal vec, Val indVal, Val adderVal) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getPosIndex(indVal, size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.push_each_at(Ind Eacher): required int num in [0, {}] for Ind, but got {}", this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indVal)));
        }
        if (adderVal instanceof VecVal) {
            VecInternal adder = ((VecVal)adderVal).vecInternal();
            vec.setVecInternal(vecInternal.insertAll(ind, adder));
            return this.vm.nada;
        }
        if (adderVal.hasVar(this.eachHandle)) {
            return c.call(adderVal, this.eachHandle).args((Val)this.pushEachAtConsume(vec, ind));
        }
        return c.call(this.vm.graph.raiseFormat("Vec.push_each_at(Ind Eacher): required Eacher supporting .each, but got {}", this.vm.graph.repr(adderVal)));
    }

    private FunVal pushEachAtConsume(VecVal vec, int initialInd) {
        AtomicInteger indAtomic = new AtomicInteger(initialInd);
        return this.vm.fun.make("Vec.push_each_at-consume").take(1).action(c -> {
            VecInternal vecInternal;
            int size;
            int ind = indAtomic.getAndIncrement();
            if (ind > (size = (vecInternal = vec.vecInternal()).size())) {
                return c.raise("Vec.push_each_at-consume: vec was modified during loop");
            }
            vec.setVecInternal(vecInternal.insert(ind, c.arg(0)));
            return this.vm.nada;
        });
    }

    private HostResult popFrontMethod(HostContext c, VecVal vec) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return c.raise("Vec.pop_front: could not pop from empty vec");
        }
        Val result = vecInternal.get(0);
        vec.setVecInternal(vecInternal.remove(0));
        return result;
    }

    private HostResult popBackMethod(HostContext c, VecVal vec) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return c.raise("Vec.pop_back: could not pop from empty vec");
        }
        Val result = vecInternal.get(size - 1);
        vec.setVecInternal(vecInternal.remove(size - 1));
        return result;
    }

    private HostResult popAtMethod(HostContext c, VecVal vec, Val indVal) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int ind = NumOperations.getElemIndex(indVal, size);
        if (ind < 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.pop_at(Ind): Ind msut be an int num in [0, {}], but got {}", this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(indVal)));
        }
        Val result = vecInternal.get(ind);
        vec.setVecInternal(vecInternal.remove(ind));
        return result;
    }

    private HostResult concatMethod(HostContext c, VecVal vecs) {
        VecInternal src = vecs.vecInternal();
        int srcSize = src.size();
        VecInternal result = this.empty;
        for (int i = 0; i < srcSize; ++i) {
            Val elem = src.get(i);
            if (!(elem instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("Vec.concat: required vec of vecs for \\recv, but got {} as the #{} elem", this.vm.graph.repr(elem), this.vm.graph.of(this.vm.num.of(i))));
            }
            VecVal vec = (VecVal)elem;
            result = result.insertAll(result.size(), vec.vecInternal());
        }
        return new VecVal(this.vm, result);
    }

    private HostResult chunkMethod(HostContext c, VecVal vec, Val chunkSizeVal) {
        VecInternal vecInternal = vec.vecInternal();
        int vecSize = vecInternal.size();
        if (!(chunkSizeVal instanceof NumVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.chunk(Chunk_size): required int num for Chunk_size, but got {}", this.vm.graph.repr(chunkSizeVal)));
        }
        BigDecimal chunkSizeDec = ((NumVal)chunkSizeVal).bigDecimal();
        if (vecInternal.size() == 0) {
            boolean sizeIsPositiveInt;
            boolean bl = sizeIsPositiveInt = chunkSizeDec.signum() > 0 && chunkSizeDec.remainder(BigDecimal.ONE).signum() == 0;
            if (!sizeIsPositiveInt) {
                return c.call(this.vm.graph.raiseFormat("Vec.chunk(Chunk_size): required positive int num for Chunk_size, but got {}", this.vm.graph.repr(chunkSizeVal)));
            }
            return this.vm.vec.of();
        }
        int chunkSize = NumOperations.getPosIndex(chunkSizeDec, vecSize);
        if (chunkSize < 1 || vecSize % chunkSize != 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.chunk(Chunk_size): required positive divisor of {} for Chunk_size, but got {}", this.vm.graph.of(this.vm.num.of(vecSize)), this.vm.graph.repr(chunkSizeVal)));
        }
        int numChunks = vecSize / chunkSize;
        VecInternal result = VecInternal.ofCapa(this.vm, numChunks);
        for (int i = 0; i < numChunks; ++i) {
            int from = i * chunkSize;
            int to = from + chunkSize;
            VecInternal chunk = vecInternal.copyRange(from, to);
            result = result.append(new VecVal(this.vm, chunk));
        }
        return new VecVal(this.vm, result);
    }

    private HostResult justMethod(HostContext c, VecVal vec) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size != 1) {
            String msg = String.format(Locale.ROOT, "Vec.just: required singleton vec as \\recv, but size was %d", size);
            return c.raise(msg);
        }
        return vecInternal.get(0);
    }

    private HostResult justOrMethod(HostContext c, VecVal vec, Val onEmpty) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        switch (size) {
            case 0: {
                return c.call((FunVal)onEmpty);
            }
            case 1: {
                return vecInternal.get(0);
            }
        }
        String msg = String.format(Locale.ROOT, "Vec.just_or: required empty or singleton vec as \\recv, but size was %d", size);
        return c.raise(msg);
    }

    private HostResult withJustOrMethod(HostContext c, VecVal vec, Val onJustVal, Val onEmptyVal) {
        String desc = "Vec.with_just_or($on_just $on_empty)";
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size > 1) {
            return c.call(this.vm.graph.raiseFormat("{}: required 0 or 1 element for Vec, but it contains {} elements", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.num.of(size))));
        }
        if (!(onJustVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: required fun for $on_just, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(onJustVal)));
        }
        if (!(onEmptyVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: required fun for $on_empty, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(onEmptyVal)));
        }
        return size == 0 ? c.call((FunVal)onEmptyVal) : c.call((FunVal)onJustVal).args(vecInternal.get(0));
    }

    private HostResult eachMethod(HostContext c, VecVal vec, Val onElem) {
        if (!(onElem instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.each($on_elem): $on_elem must be a fun, but got {}", this.vm.graph.repr(onElem)));
        }
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        return size == 0 ? this.vm.nada : this.eachLoop(c, vecInternal, 0, size, (FunVal)onElem);
    }

    private HostResult eachLoop(HostContext c, VecInternal vecInternal, int ind, int size, FunVal onElem) {
        Val elem = vecInternal.get(ind);
        int nextInd = ind + 1;
        if (nextInd < size) {
            return c.call(onElem).args(elem).on((cc, ignored) -> this.eachLoop(cc, vecInternal, nextInd, size, onElem));
        }
        return c.call(onElem).args(elem);
    }

    private HostResult mapMethod(HostContext c, VecVal vec, Val trans) {
        if (!(trans instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.map($trans): $trans must be a fun, but got {}", this.vm.graph.repr(trans)));
        }
        VecInternal src = vec.vecInternal();
        int size = src.size();
        VecInternal dest = VecInternal.ofCapa(this.vm, size);
        return this.mapLoop(c, src, dest, 0, (FunVal)trans);
    }

    private HostResult mapLoop(HostContext c, VecInternal src, VecInternal dest, int index, FunVal trans) {
        if (index >= src.size()) {
            return new VecVal(this.vm, dest);
        }
        return c.call(trans).args(src.get(index)).on((cc, result) -> this.mapLoop(cc, src, dest.append(result), index + 1, trans));
    }

    private HostResult concatMapMethod(HostContext c, VecVal vec, Val trans) {
        if (!(trans instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.concat_map($trans_to_vec): $trans_to_vec must be a fun, but got {}", this.vm.graph.repr(trans)));
        }
        VecInternal src = vec.vecInternal();
        VecInternal dest = this.empty;
        return this.concatMapLoop(c, src, dest, 0, (FunVal)trans);
    }

    private HostResult concatMapLoop(HostContext c, VecInternal src, VecInternal dest, int srcIndex, FunVal trans) {
        if (srcIndex >= src.size()) {
            return new VecVal(this.vm, dest);
        }
        return c.call(trans).args(src.get(srcIndex)).on((cc, resultVal) -> {
            if (!(resultVal instanceof VecVal)) {
                return cc.call(this.vm.graph.raiseFormat("Vec.concat_map: expected vec for fun result, but got {}", this.vm.graph.repr(resultVal)));
            }
            VecVal result = (VecVal)resultVal;
            VecInternal newDest = dest.insertAll(dest.size(), result.vecInternal());
            return this.concatMapLoop(cc, src, newDest, srcIndex + 1, trans);
        });
    }

    private HostResult filterMethod(HostContext c, VecVal vec, Val pred) {
        if (!(pred instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.filter($match?): $match? msut be a fun, but got {}", this.vm.graph.repr(pred)));
        }
        VecInternal src = vec.vecInternal();
        VecInternal dest = this.empty;
        return this.filterLoop(c, src, dest, 0, (FunVal)pred);
    }

    private HostResult filterLoop(HostContext c, VecInternal src, VecInternal dest, int srcIndex, FunVal pred) {
        if (srcIndex >= src.size()) {
            return new VecVal(this.vm, dest);
        }
        Val elem = src.get(srcIndex);
        return c.call(pred).args(elem).on((cc, bool) -> {
            if (!this.vm.bool.isBool(bool)) {
                return cc.call(this.vm.graph.raiseFormat("Vec.filter: expected bool for fun result, but got {}", this.vm.graph.repr(bool)));
            }
            VecInternal newDest = bool == this.vm.bool.trueVal ? dest.append(elem) : dest;
            return this.filterLoop(cc, src, newDest, srcIndex + 1, pred);
        });
    }

    private HostResult countMethod(HostContext c, VecVal vec, Val pred) {
        if (!(pred instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.count($match?): $match? must be a fun, but got {}", this.vm.graph.repr(pred)));
        }
        VecInternal vecInternal = vec.vecInternal();
        return this.countLoop(c, vecInternal, 0, 0, (FunVal)pred);
    }

    private HostResult countLoop(HostContext c, VecInternal vecInternal, int index, int num, FunVal pred) {
        if (index >= vecInternal.size()) {
            return this.vm.num.of(num);
        }
        return c.call(pred).args(vecInternal.get(index)).on((cc, bool) -> {
            if (!this.vm.bool.isBool(bool)) {
                return cc.call(this.vm.graph.raiseFormat("Vec.count: expected bool for fun result, but got {}", this.vm.graph.repr(bool)));
            }
            int newNum = num + (bool == this.vm.bool.trueVal ? 1 : 0);
            return this.countLoop(cc, vecInternal, index + 1, newNum, pred);
        });
    }

    private HostResult foldMethod(HostContext c, VecVal vec, Val init, Val combine) {
        if (!(combine instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.fold(Init $combine): $combine must be a fun, but got {}", this.vm.graph.repr(combine)));
        }
        VecInternal vecInternal = vec.vecInternal();
        return this.foldLoop(c, vecInternal, 0, init, (FunVal)combine);
    }

    private HostResult foldLoop(HostContext c, VecInternal vecInternal, int index, Val accum, FunVal combine) {
        int size = vecInternal.size();
        if (index >= size) {
            return accum;
        }
        Val elem = vecInternal.get(index);
        int nextIndex = index + 1;
        if (nextIndex < size) {
            return c.call(combine).args(accum, elem).on((cc, newAccum) -> this.foldLoop(cc, vecInternal, nextIndex, newAccum, combine));
        }
        return c.call(combine).args(accum, elem);
    }

    private HostResult reduceMethod(HostContext c, VecVal vec, Val combine) {
        if (!(combine instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.reduce($combine): $combine must be a fun, but got {}", this.vm.graph.repr(combine)));
        }
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        if (size == 0) {
            return this.vm.vec.of();
        }
        Val first = vecInternal.get(0);
        return this.reduceLoop(c, vecInternal, 1, first, (FunVal)combine);
    }

    private HostResult reduceLoop(HostContext c, VecInternal vecInternal, int index, Val accum, FunVal combine) {
        if (index >= vecInternal.size()) {
            return this.vm.vec.of(accum);
        }
        return c.call(combine).args(accum, vecInternal.get(index)).on((cc, newAccum) -> this.reduceLoop(cc, vecInternal, index + 1, newAccum, combine));
    }

    private HostResult scanMethod(HostContext c, VecVal vec, Val init, Val combine) {
        if (!(combine instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.scan(Init $combine): $combine must be a fun, but got {}", this.vm.graph.repr(combine)));
        }
        VecInternal src = vec.vecInternal();
        int srcSize = src.size();
        VecInternal dest = VecInternal.ofCapa(this.vm, srcSize + 1);
        dest = dest.insert(0, init);
        return this.scanLoop(c, src, dest, 0, init, (FunVal)combine);
    }

    private HostResult scanInsideMethod(HostContext c, VecVal vec, Val combine) {
        if (!(combine instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.scan_inside($combine): $combine must be a fun, but got {}", this.vm.graph.repr(combine)));
        }
        VecInternal src = vec.vecInternal();
        int srcSize = src.size();
        if (srcSize == 0) {
            return this.vm.vec.of();
        }
        VecInternal dest = VecInternal.ofCapa(this.vm, srcSize);
        Val first = src.get(0);
        dest = dest.insert(0, first);
        return this.scanLoop(c, src, dest, 1, first, (FunVal)combine);
    }

    private HostResult scanLoop(HostContext c, VecInternal src, VecInternal dest, int srcIndex, Val accum, FunVal combine) {
        if (srcIndex >= src.size()) {
            return new VecVal(this.vm, dest);
        }
        return c.call(combine).args(accum, src.get(srcIndex)).on((cc, newAccum) -> {
            VecInternal newDest = dest.append(newAccum);
            return this.scanLoop(cc, src, newDest, srcIndex + 1, newAccum, combine);
        });
    }

    private HostResult takeWhileMethod(HostContext c, VecVal vec, Val pred) {
        if (!(pred instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.take_while($match?): $match? must be a fun, but got {}", this.vm.graph.repr(pred)));
        }
        VecInternal vecInternal = vec.vecInternal();
        return this.takeWhileLoop(c, vecInternal, 0, (FunVal)pred);
    }

    private HostResult takeWhileLoop(HostContext c, VecInternal src, int srcIndex, FunVal pred) {
        int srcSize = src.size();
        if (srcIndex >= srcSize) {
            return new VecVal(this.vm, src.copy());
        }
        Val elem = src.get(srcIndex);
        return c.call(pred).args(elem).on((cc, result) -> {
            if (!this.vm.bool.isBool(result)) {
                return cc.call(this.vm.graph.raiseFormat("Vec.take_while($match?): expected bool for the result of $match?, but got {}", this.vm.graph.repr(result)));
            }
            if (result == this.vm.bool.falseVal) {
                return new VecVal(this.vm, src.copyRange(0, srcIndex));
            }
            return this.takeWhileLoop(cc, src, srcIndex + 1, pred);
        });
    }

    private HostResult dropWhileMethod(HostContext c, VecVal vec, Val pred) {
        if (!(pred instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.drop_while($match?): $match? must be a fun, but got {}", this.vm.graph.repr(pred)));
        }
        VecInternal vecInternal = vec.vecInternal();
        return this.dropWhileLoop(c, vecInternal, 0, vecInternal.size(), (FunVal)pred);
    }

    private HostResult dropWhileLoop(HostContext c, VecInternal src, int srcIndex, int srcSize, FunVal pred) {
        if (srcIndex >= srcSize) {
            return this.vm.vec.of();
        }
        Val elem = src.get(srcIndex);
        return c.call(pred).args(elem).on((cc, result) -> {
            if (!this.vm.bool.isBool(result)) {
                return cc.call(this.vm.graph.raiseFormat("Vec.drop_while($match?): expected bool for the result of $match?, but got {}", this.vm.graph.repr(result)));
            }
            if (result == this.vm.bool.falseVal) {
                return new VecVal(this.vm, src.copyRange(srcIndex, srcSize));
            }
            return this.dropWhileLoop(cc, src, srcIndex + 1, srcSize, pred);
        });
    }

    private HostResult allPMethod(HostContext c, VecVal vec, Val pred) {
        if (!(pred instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.all?($match?): $match? must be a fun, but got {}", this.vm.graph.repr(pred)));
        }
        VecInternal vecInternal = vec.vecInternal();
        return this.allPLoop(c, vecInternal, 0, (FunVal)pred);
    }

    private HostResult allPLoop(HostContext c, VecInternal vecInternal, int index, FunVal pred) {
        int size = vecInternal.size();
        if (index >= size) {
            return this.vm.bool.trueVal;
        }
        Val elem = vecInternal.get(index);
        int nextIndex = index + 1;
        if (nextIndex < size) {
            return c.call(pred).args(elem).on((cc, result) -> {
                if (!this.vm.bool.isBool(result)) {
                    return cc.call(this.vm.graph.raiseFormat("Vec.all?($match?): expected bool for the result of $match?, but got {}", this.vm.graph.repr(result)));
                }
                if (result == this.vm.bool.falseVal) {
                    return this.vm.bool.falseVal;
                }
                return this.allPLoop(cc, vecInternal, nextIndex, pred);
            });
        }
        return c.call(pred).args(elem);
    }

    private HostResult anyPMethod(HostContext c, VecVal vec, Val pred) {
        if (!(pred instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.any?($match?): $match? must be a fun, but got {}", this.vm.graph.repr(pred)));
        }
        VecInternal vecInternal = vec.vecInternal();
        return this.forAnyPLoop(c, vecInternal, 0, (FunVal)pred);
    }

    private HostResult forAnyPLoop(HostContext c, VecInternal vecInternal, int index, FunVal pred) {
        int size = vecInternal.size();
        if (index >= size) {
            return this.vm.bool.falseVal;
        }
        Val elem = vecInternal.get(index);
        int nextIndex = index + 1;
        if (nextIndex < size) {
            return c.call(pred).args(elem).on((cc, result) -> {
                if (!this.vm.bool.isBool(result)) {
                    return cc.call(this.vm.graph.raiseFormat("Vec.any?($match?): expected bool for the result of $match?, but got {}", this.vm.graph.repr(result)));
                }
                if (result == this.vm.bool.trueVal) {
                    return this.vm.bool.trueVal;
                }
                return this.forAnyPLoop(cc, vecInternal, nextIndex, pred);
            });
        }
        return c.call(pred).args(elem);
    }

    private HostResult havePMethod(HostContext c, VecVal vec, Val target) {
        VecInternal vecInternal = vec.vecInternal();
        return this.havePLoop(c, vecInternal, 0, target);
    }

    private HostResult havePLoop(HostContext c, VecInternal vecInternal, int index, Val target) {
        int size = vecInternal.size();
        if (index >= size) {
            return this.vm.bool.falseVal;
        }
        Val elem = vecInternal.get(index);
        int nextIndex = index + 1;
        if (nextIndex < size) {
            return c.call(elem, this.opEqHandle).args(target).on((cc, result) -> {
                if (!this.vm.bool.isBool(result)) {
                    return cc.call(this.vm.graph.raiseFormat("Vec.have?: expected bool for result of .op_eq of elem #{}, but got {}", this.vm.graph.of(this.vm.num.of(index)), this.vm.graph.repr(result)));
                }
                if (result == this.vm.bool.trueVal) {
                    return this.vm.bool.trueVal;
                }
                return this.havePLoop(cc, vecInternal, nextIndex, target);
            });
        }
        return c.call(elem, this.opEqHandle).args(target);
    }

    private HostResult haveAllPMethod(HostContext c, VecVal vec, Val arg) {
        return c.call(arg, this.allP).args((Val)this.vm.fun.make("Vec.have_all?#accept_elem?").take(1).action(cc -> cc.call(vec, this.haveP).args(cc.arg(0))));
    }

    private HostResult haveAnyPMethod(HostContext c, VecVal vec, Val arg) {
        return c.call(arg, this.anyP).args((Val)this.vm.fun.make("Vec.have_any?#accept_elem?").take(1).action(cc -> cc.call(vec, this.haveP).args(cc.arg(0))));
    }

    private HostResult searchMethod(HostContext c, VecVal vec, Val minIndVal, Val acceptsVal) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int minInd = NumOperations.getPosIndex(minIndVal, size);
        if (minInd < 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.search(Min_ind $accept?): required int num in [0, {}] for Min_ind but got {}", this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(minIndVal)));
        }
        if (!(acceptsVal instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("Vec.search(Min_ind $accept?): required fun for $accept?, but got {}", this.vm.graph.repr(acceptsVal)));
        }
        FunVal accepts = (FunVal)acceptsVal;
        return this.searchMethodLoop(c, vecInternal, minInd, accepts, size);
    }

    private HostResult searchMethodLoop(HostContext c, VecInternal vecInternal, int ind, FunVal accepts, int size) {
        if (ind >= size) {
            return this.vm.vec.of();
        }
        Val elem = vecInternal.get(ind);
        return c.call(accepts).args(elem).on((cc, r) -> {
            if (!this.vm.bool.isBool(r)) {
                return cc.call(this.vm.graph.raiseFormat("Vec.search(Min_ind $accept?): expected bool returned from $accept?, but got {}", this.vm.graph.repr(r)));
            }
            if (r.equals(this.vm.bool.trueVal)) {
                return this.vm.vec.of((Val)this.vm.num.of(ind));
            }
            return this.searchMethodLoop(cc, vecInternal, ind + 1, accepts, size);
        });
    }

    private HostResult sortMethod(CallContext c) {
        Val precedes = c.argCount() == 0 ? this.defaultPrecedesFun : c.arg(0);
        return c.call("kink/_vec/SORT_VEC", this.sortHandle).args(c.recv(), precedes);
    }

    private HostResult iterMethod(HostContext c, VecVal vec) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        FunVal ifun = this.forwardIfun("Vec.iter.ifun", vecInternal, 0, size);
        return c.call("kink/iter/ITER", this.vm.sym.handleFor("new")).args((Val)ifun);
    }

    private HostResult iterFromMethod(HostContext c, VecVal vec, Val minIndVal) {
        VecInternal vecInternal = vec.vecInternal();
        int size = vecInternal.size();
        int minInd = NumOperations.getPosIndex(minIndVal, size);
        if (minInd < 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.iter_from(Min_ind): required int in [0, {}] for Min_ind, but got {}", this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(minIndVal)));
        }
        FunVal ifun = this.forwardIfun("Vec.iter_from.ifun", vecInternal, minInd, size);
        return c.call("kink/iter/ITER", this.vm.sym.handleFor("new")).args((Val)ifun);
    }

    private FunVal forwardIfun(String prefix, VecInternal vecInternal, int ind, int size) {
        return this.vm.fun.make(prefix).take(2).action(c -> {
            Val proc = c.arg(0);
            if (!(proc instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required fun for $proc, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(proc)));
            }
            Val fin = c.arg(1);
            if (!(fin instanceof FunVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required fun for $fin, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(fin)));
            }
            if (ind < size) {
                Val head = vecInternal.get(ind);
                FunVal tail = this.forwardIfun(prefix, vecInternal, ind + 1, size);
                return c.call((FunVal)proc).args(head, (Val)tail);
            }
            return c.call((FunVal)fin);
        });
    }

    private HostResult opAddMethod(HostContext c, VecVal left, VecVal right) {
        VecInternal result = left.vecInternal().copy();
        int leftSize = result.size();
        result = result.insertAll(leftSize, right.vecInternal());
        return new VecVal(this.vm, result);
    }

    private HostResult opStoreMethod(HostContext c, VecVal lhs, Val arg) {
        Val restParam;
        if (!(arg instanceof VecVal)) {
            return c.call(FunsHolder.raiseNotVecRhs(this.vm, arg));
        }
        VecVal rhs = (VecVal)arg;
        VecInternal lhsVi = lhs.vecInternal();
        VecInternal rhsVi = rhs.vecInternal();
        int lhsSize = lhsVi.size();
        int rhsSize = rhsVi.size();
        int mandatoryCount = this.getMandatoryParamsCount(lhsSize, lhsVi);
        int optCount = this.getOptParamsCount(lhsSize, lhsVi, mandatoryCount);
        int restInd = mandatoryCount + optCount;
        Val val = restParam = restInd == lhsSize ? null : lhsVi.get(restInd);
        if (restInd < lhsSize - 1 || restInd == lhsSize - 1 && !restParam.hasVar(this.passRestHandle)) {
            return c.call(this.vm.graph.raiseFormat("Vec.op_store(Rhs): unexpected lhs param: {}", this.vm.graph.repr(restParam)));
        }
        if (rhsSize < mandatoryCount || restParam == null && rhsSize > mandatoryCount + optCount) {
            FunVal fun = FunsHolder.wrongNumberOfArgs(this.vm, mandatoryCount, this.vm.graph.repr(lhs), rhs);
            return c.call(fun);
        }
        return this.opStoreMandatoryLoop(c, 0, lhsVi, rhsSize, rhsVi, mandatoryCount, optCount, restParam);
    }

    private int getMandatoryParamsCount(int lhsSize, VecInternal lhsVi) {
        for (int i = 0; i < lhsSize; ++i) {
            Val param = lhsVi.get(i);
            if (param instanceof VarrefVal || param.hasVar(this.storeHandle)) continue;
            return i;
        }
        return lhsSize;
    }

    private int getOptParamsCount(int lhsSize, VecInternal lhsVi, int offset) {
        int i = 0;
        while (offset + i < lhsSize) {
            Val param = lhsVi.get(offset + i);
            if (!param.hasVar(this.passArgHandle)) {
                return i;
            }
            ++i;
        }
        return lhsSize - offset;
    }

    private HostResult opStoreMandatoryLoop(HostContext c, int ind, VecInternal lhs, int rhsSize, VecInternal rhs, int mandatoryCount, int optCount, @Nullable Val restParam) {
        while (ind < mandatoryCount) {
            Val param = lhs.get(ind);
            Val rval = rhs.get(ind);
            if (!(param instanceof VarrefVal)) {
                int nextInd = ind + 1;
                return c.call(param, this.storeHandle).args(rval).on((cc, r) -> this.opStoreMandatoryLoop(cc, nextInd, lhs, rhsSize, rhs, mandatoryCount, optCount, restParam));
            }
            VarrefVal varref = (VarrefVal)param;
            Val owner = varref.owner();
            int handle = varref.symHandle();
            owner.setVar(handle, rval);
            ++ind;
        }
        return this.opStoreOptLoop(c, ind, lhs, rhsSize, rhs, mandatoryCount, optCount, restParam);
    }

    private HostResult opStoreOptLoop(HostContext c, int ind, VecInternal lhs, int rhsSize, VecInternal rhs, int mandatoryCount, int optCount, @Nullable Val restParam) {
        if (ind == mandatoryCount + optCount) {
            return this.opStoreRest(c, ind, rhsSize, rhs, restParam);
        }
        Val param = lhs.get(ind);
        HostFunReaction next = (cc, r) -> this.opStoreOptLoop(cc, ind + 1, lhs, rhsSize, rhs, mandatoryCount, optCount, restParam);
        return (ind < rhsSize ? c.call(param, this.passArgHandle).args(rhs.get(ind)) : c.call(param, this.passNothingHandle)).on(next);
    }

    private HostResult opStoreRest(HostContext c, int ind, int rhsSize, VecInternal rhs, @Nullable Val restParam) {
        if (restParam == null) {
            return this.vm.nada;
        }
        VecInternal restArgs = rhs.copyRange(Math.min(ind, rhsSize), rhsSize);
        VecVal restArgsVec = new VecVal(this.vm, restArgs);
        return c.call(restParam, this.passRestHandle).args((Val)restArgsVec);
    }

    private HostResult opMulMethod(HostContext c, VecVal vec, Val countVal) {
        VecInternal vecInternal = vec.vecInternal();
        BigInteger count = NumOperations.getExactBigInteger(countVal);
        if (count == null || count.signum() < 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.op_mul(Count): required int num >=0 for Count, but got {}", this.vm.graph.repr(countVal)));
        }
        int size = vecInternal.size();
        if (size == 0) {
            return this.vm.vec.of();
        }
        BigInteger resultSizeEstimate = count.multiply(BigInteger.valueOf(size));
        if (resultSizeEstimate.compareTo(BigInteger.valueOf(Integer.MAX_VALUE)) > 0) {
            return c.call(this.vm.graph.raiseFormat("Vec.op_mul(Count): too long result: size {} * Count {} is {}", this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.of(countVal), this.vm.graph.of(this.vm.num.of(resultSizeEstimate))));
        }
        int countInt = count.intValueExact();
        VecInternal dest = VecInternal.ofCapa(this.vm, size * countInt);
        for (int i = 0; i < countInt; ++i) {
            dest = dest.insertAll(dest.size(), vecInternal);
        }
        return new VecVal(this.vm, dest);
    }

    private HostResult opEqMethod(HostContext c, VecVal left, VecVal right) {
        VecInternal lv = left.vecInternal();
        VecInternal rv = right.vecInternal();
        int size = lv.size();
        if (rv.size() != size) {
            return this.vm.bool.falseVal;
        }
        if (size == 0) {
            return this.vm.bool.trueVal;
        }
        return this.eqLoop(c, lv, rv, 0, size);
    }

    private HostResult eqLoop(HostContext c, VecInternal lv, VecInternal rv, int ind, int size) {
        Val lelem = lv.get(ind);
        Val relem = rv.get(ind);
        if (ind + 1 >= size) {
            return c.call(lelem, this.opEqHandle).args(relem);
        }
        return c.call(lelem, this.opEqHandle).args(relem).on((cc, r) -> {
            if (!this.vm.bool.isBool(r)) {
                return cc.call(this.vm.graph.raiseFormat("Vec1.op_eq(Vec2): expected bool result from Elem.op_eq, but got {}", this.vm.graph.repr(r)));
            }
            if (r == this.vm.bool.falseVal) {
                return this.vm.bool.of(false);
            }
            return this.eqLoop(cc, lv, rv, ind + 1, size);
        });
    }

    private HostResult opLtMethod(HostContext c, VecVal left, VecVal right) {
        VecInternal lv = left.vecInternal();
        VecInternal rv = right.vecInternal();
        int lsize = lv.size();
        int rsize = rv.size();
        return lsize == 0 ? this.vm.bool.of(rsize != 0) : (rsize == 0 ? this.vm.bool.falseVal : (lsize == rsize ? this.compareSameSize(c, lv, rv, 0, lsize) : this.compareDifferentSize(c, lv, rv, 0, Math.min(lsize, rsize), lsize < rsize)));
    }

    private HostResult compareDifferentSize(HostContext c, VecInternal lv, VecInternal rv, int ind, int size, boolean atEnd) {
        if (ind == size) {
            return this.vm.bool.of(atEnd);
        }
        Val lelem = lv.get(ind);
        Val relem = rv.get(ind);
        return c.call(lelem, this.opLtHandle).args(relem).on((cc, accept) -> {
            if (!this.vm.bool.isBool(accept)) {
                return cc.call(this.vm.graph.raiseFormat("Vec1.op_lt(Vec2): expected bool result from .op_lt, but got {}", this.vm.graph.repr(accept)));
            }
            if (accept.equals(this.vm.bool.trueVal)) {
                return this.vm.bool.trueVal;
            }
            return cc.call(relem, this.opLtHandle).args(lelem).on((c3, reject) -> {
                if (!this.vm.bool.isBool(reject)) {
                    return c3.call(this.vm.graph.raiseFormat("Vec1.op_lt(Vec2): expected bool result from .op_lt, but got {}", this.vm.graph.repr(reject)));
                }
                if (reject.equals(this.vm.bool.trueVal)) {
                    return this.vm.bool.falseVal;
                }
                return this.compareDifferentSize(c3, lv, rv, ind + 1, size, atEnd);
            });
        });
    }

    private HostResult compareSameSize(HostContext c, VecInternal lv, VecInternal rv, int ind, int size) {
        Val lelem = lv.get(ind);
        Val relem = rv.get(ind);
        if (ind + 1 == size) {
            return c.call(lelem, this.opLtHandle).args(relem);
        }
        return c.call(lelem, this.opLtHandle).args(relem).on((cc, accept) -> {
            if (!this.vm.bool.isBool(accept)) {
                return cc.call(this.vm.graph.raiseFormat("Vec1.op_lt(Vec2): expected bool result from .op_lt, but got {}", this.vm.graph.repr(accept)));
            }
            if (accept.equals(this.vm.bool.trueVal)) {
                return this.vm.bool.trueVal;
            }
            return cc.call(relem, this.opLtHandle).args(lelem).on((c3, reject) -> {
                if (!this.vm.bool.isBool(reject)) {
                    return c3.call(this.vm.graph.raiseFormat("Vec1.op_lt(Vec2): expected bool result from .op_lt, but got {}", this.vm.graph.repr(reject)));
                }
                if (reject.equals(this.vm.bool.trueVal)) {
                    return this.vm.bool.falseVal;
                }
                return this.compareSameSize(c3, lv, rv, ind + 1, size);
            });
        });
    }

    private HostResult reprMethod(HostContext c, VecVal vec) {
        return c.call("kink/_vec/REPR_VEC", this.reprVecHandle).args((Val)vec);
    }

    @Nullable
    private GraphNode checkRange(String prefix, int size, Val fromVal, Val toVal) {
        if (!(fromVal instanceof NumVal)) {
            return this.vm.graph.raiseFormat("{}: From_pos must be a num, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(fromVal));
        }
        BigDecimal fromDecimal = ((NumVal)fromVal).bigDecimal();
        if (!(toVal instanceof NumVal)) {
            return this.vm.graph.raiseFormat("{}: To_pos must be a num, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(toVal));
        }
        BigDecimal toDecimal = ((NumVal)toVal).bigDecimal();
        if (!NumOperations.isRangePair(fromDecimal, toDecimal, size)) {
            return this.vm.graph.raiseFormat("{}: required range pair in [0, {}], but got {} and {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.of(this.vm.num.of(size)), this.vm.graph.repr(fromVal), this.vm.graph.repr(toVal));
        }
        return null;
    }

    private FunVal method0(String prefix, ThrowingFunction2<CallContext, VecVal, HostResult> action) {
        return this.vm.fun.make(prefix).take(0).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required vec for \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)action.apply(c, (VecVal)recv);
        });
    }

    private FunVal method1(String prefix, ThrowingFunction3<CallContext, VecVal, Val, HostResult> action) {
        return this.vm.fun.make(prefix).take(1).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required vec for \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)action.apply(c, (VecVal)recv, c.arg(0));
        });
    }

    private FunVal method2(String prefix, ThrowingFunction4<CallContext, VecVal, Val, Val, HostResult> action) {
        return this.vm.fun.make(prefix).take(2).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: required vec for \\recv, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr(recv)));
            }
            return (HostResult)action.apply(c, (VecVal)recv, c.arg(0), c.arg(1));
        });
    }

    private FunVal binOp(String prefix, ThrowingFunction3<CallContext, VecVal, VecVal, HostResult> action) {
        return this.method1(prefix, (c, vec, arg) -> {
            if (!(arg instanceof VecVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: the arg must be a vec, but got {}", this.vm.graph.of(this.vm.str.of(prefix)), this.vm.graph.repr((Val)arg)));
            }
            return (HostResult)action.apply((CallContext)c, (VecVal)vec, (VecVal)arg);
        });
    }

    public VecVal of(List<? extends Val> elems) {
        return elems.isEmpty() ? this.of() : new VecVal(this.vm, VecInternal.of(this.vm, elems));
    }

    public VecVal of(Val[] vals, int from, int to) {
        Preconds.checkRange(from, to, vals.length);
        return from == to ? this.of() : new VecVal(this.vm, VecInternal.of(this.vm, vals, from, to));
    }

    public VecVal of() {
        return new VecVal(this.vm, this.empty);
    }

    public VecVal of(Val e0) {
        return new VecVal(this.vm, VecInternal.of(this.vm, e0));
    }

    public VecVal of(Val e0, Val e1) {
        return new VecVal(this.vm, VecInternal.of(this.vm, e0, e1));
    }

    public VecVal of(Val e0, Val e1, Val e2) {
        return new VecVal(this.vm, VecInternal.of(this.vm, e0, e1, e2));
    }

    public VecVal of(Val e0, Val e1, Val e2, Val e3) {
        return new VecVal(this.vm, VecInternal.of(this.vm, e0, e1, e2, e3));
    }

    public VecVal of(Val ... elems) {
        return new VecVal(this.vm, VecInternal.of(this.vm, elems, 0, elems.length));
    }
}

