/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.hostfun.graph.impl;

import java.util.ArrayList;
import java.util.List;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.function.ThrowingFunction2;

class ArgsCollector {
    private final Vm vm;
    private final GraphNode[] args;

    ArgsCollector(Vm vm, GraphNode[] args) {
        this.vm = vm;
        this.args = args;
    }

    HostResult collectArgs(HostContext c, ThrowingFunction2<HostContext, Val[], HostResult> handler) {
        return this.collectArgsLoop(c, List.of(), handler);
    }

    private HostResult collectArgsLoop(HostContext c, List<Val> collectedVals, ThrowingFunction2<HostContext, Val[], HostResult> handler) {
        if (collectedVals.size() == this.args.length) {
            Val[] argVals = collectedVals.toArray(new Val[0]);
            FunVal caller = this.vm.fun.make().action(cc -> (HostResult)handler.apply(cc, argVals));
            return c.call(caller);
        }
        GraphNode argGraph = this.args[collectedVals.size()];
        return c.call(argGraph).on((cc, argVal) -> {
            ArrayList<Val> newVals = new ArrayList<Val>(collectedVals.size() + 1);
            newVals.addAll(collectedVals);
            newVals.add(argVal);
            return this.collectArgsLoop(cc, newVals, handler);
        });
    }
}

