/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.hostfun.graph.impl;

import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostFunReaction;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToArgs;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToRecv;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.hostfun.graph.impl.ArgsCollector;
import org.kink_lang.kink.internal.function.ThrowingFunction3;

class MethodCallGraph
implements CallGraphNodeToRecv {
    private final Vm vm;
    private final GraphNode owner;
    private final int symHandle;
    private final ThrowingFunction3<HostContext, Val, HostFunReaction, HostResult> recvEmitter;
    private final GraphNode[] args;

    static MethodCallGraph withOwnerRecv(Vm vm, GraphNode ownerRecv, int symHandle, GraphNode[] args) {
        return new MethodCallGraph(vm, ownerRecv, symHandle, (c, o, handler) -> handler.reaction((HostContext)c, (Val)o), args);
    }

    static MethodCallGraph withDistinctRecv(Vm vm, GraphNode owner, int symHandle, GraphNode recv, GraphNode[] args) {
        return new MethodCallGraph(vm, owner, symHandle, (c, o, handler) -> c.call(recv).on((HostFunReaction)handler), args);
    }

    private MethodCallGraph(Vm vm, GraphNode owner, int symHandle, ThrowingFunction3<HostContext, Val, HostFunReaction, HostResult> recvEmitter, GraphNode[] args) {
        this.vm = vm;
        this.owner = owner;
        this.recvEmitter = recvEmitter;
        this.symHandle = symHandle;
        this.args = args;
    }

    @Override
    public HostResult evaluateIn(HostContext c) {
        return c.call(this.owner).on((cc, ownerVal) -> this.recvEmitter.apply(cc, ownerVal, (c3, recvVal) -> new ArgsCollector(this.vm, this.args).collectArgs(c3, (c4, argVals) -> c4.call(ownerVal, this.symHandle).recv(recvVal).args((Val)argVals))));
    }

    @Override
    public CallGraphNodeToArgs recv(GraphNode recv) {
        return MethodCallGraph.withDistinctRecv(this.vm, this.owner, this.symHandle, recv, this.args);
    }

    @Override
    public GraphNode args(GraphNode ... args) {
        return new MethodCallGraph(this.vm, this.owner, this.symHandle, this.recvEmitter, args);
    }
}

