/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.bootstrap;

import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigDecimal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.bootstrap.NumRegistry;
import org.kink_lang.kink.internal.compile.bootstrap.StrRegistry;
import org.kink_lang.kink.internal.compile.tempval.IntVal;
import org.kink_lang.kink.internal.intrinsicsupport.PreloadedFuns;

public final class ConstBootstrapper {
    private ConstBootstrapper() {
    }

    public static CallSite bootstrapBigDecimal(MethodHandles.Lookup caller, String name, MethodType type, String decimalStr) {
        BigDecimal decimal = ConstBootstrapper.getBigDecimal(decimalStr);
        return new ConstantCallSite(MethodHandles.constant(BigDecimal.class, decimal));
    }

    static BigDecimal getBigDecimal(String decimalStr) {
        BigDecimal decimal = new BigDecimal(decimalStr);
        if (decimal.scale() == 0) {
            try {
                return BigDecimal.valueOf(decimal.longValueExact());
            }
            catch (ArithmeticException ex) {
                return decimal;
            }
        }
        return decimal;
    }

    public static CallSite bootstrapNada(MethodHandles.Lookup caller, String name, MethodType type) throws Throwable {
        return new ConstantCallSite(MethodHandles.constant(Val.class, ConstBootstrapper.getVm((MethodHandles.Lookup)caller).nada));
    }

    public static CallSite bootstrapTrue(MethodHandles.Lookup caller, String name, MethodType type) throws Throwable {
        Val trueVal = ConstBootstrapper.getVm((MethodHandles.Lookup)caller).bool.trueVal;
        MethodHandle mh = MethodHandles.constant(Val.class, trueVal);
        return new ConstantCallSite(mh);
    }

    public static CallSite bootstrapFalse(MethodHandles.Lookup caller, String name, MethodType type) throws Throwable {
        Val falseVal = ConstBootstrapper.getVm((MethodHandles.Lookup)caller).bool.falseVal;
        MethodHandle mh = MethodHandles.constant(Val.class, falseVal);
        return new ConstantCallSite(mh);
    }

    public static CallSite bootstrapStr(MethodHandles.Lookup caller, String name, MethodType type, String string) throws Throwable {
        StrVal strVal = StrRegistry.strVal(ConstBootstrapper.getVm(caller), string);
        MethodHandle mh = MethodHandles.constant(Val.class, strVal);
        return new ConstantCallSite(mh);
    }

    public static CallSite bootstrapNum(MethodHandles.Lookup caller, String name, MethodType type, String decimalStr) throws Throwable {
        NumVal numVal = NumRegistry.numVal(ConstBootstrapper.getVm(caller), new BigDecimal(decimalStr));
        MethodHandle mh = MethodHandles.constant(Val.class, numVal);
        return new ConstantCallSite(mh);
    }

    public static CallSite bootstrapInt(MethodHandles.Lookup caller, String name, MethodType type, int num) throws Throwable {
        IntVal intVal = IntVal.of(ConstBootstrapper.getVm(caller), num);
        MethodHandle mh = MethodHandles.constant(Val.class, intVal);
        return new ConstantCallSite(mh);
    }

    public static CallSite bootstrapPreloaded(MethodHandles.Lookup caller, String name, MethodType type, String sym) throws Throwable {
        Val funVal = PreloadedFuns.preloadedFun(ConstBootstrapper.getVm(caller), sym);
        MethodHandle mh = MethodHandles.constant(Val.class, funVal);
        return new ConstantCallSite(mh);
    }

    private static Vm getVm(MethodHandles.Lookup caller) throws Throwable {
        MethodHandle vmMh = caller.findStaticGetter(caller.lookupClass(), "vmStatic", Vm.class);
        return vmMh.invoke();
    }
}

