/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.LetRecGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.LvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.MakeFastFunGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ResultContext;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LetRecItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class InFastFunLetRecGenerator
implements LetRecGenerator {
    private final LvarAccessGenerator lvarAccGen;
    private final MakeFastFunGenerator makeFunGen;
    static final Type DELEGATING_FUN_TYPE = Type.getType((String)"Lorg/kink_lang/kink/DelegatingFunVal;");
    static final Insn INVOKE_WRAP = new Insn.InvokeVirtual(DELEGATING_FUN_TYPE, new Method("wrap", Type.VOID_TYPE, new Type[]{Type.getType(FunVal.class)}));

    public InFastFunLetRecGenerator(LvarAccessGenerator lvarAccGen, MakeFastFunGenerator makeFunGen) {
        this.lvarAccGen = lvarAccGen;
        this.makeFunGen = makeFunGen;
    }

    @Override
    public List<Insn> letRec(LetRecItree itree, BiFunction<Itree, ResultContext, List<Insn>> generate) {
        LocalVar lvar;
        ArrayList<Insn> insns = new ArrayList<Insn>();
        for (LetRecItree.LvarFunPair pair : itree.lvarFunPairs()) {
            lvar = pair.lvar();
            if (this.lvarAccGen.isUnused(lvar)) continue;
            insns.add(new Insn.NewInstance(DELEGATING_FUN_TYPE));
            insns.add(new Insn.Dup());
            insns.addAll(InsnsGenerator.LOAD_VM);
            insns.add(new Insn.InvokeConstructor(DELEGATING_FUN_TYPE, new Method("<init>", Type.VOID_TYPE, new Type[]{Type.getType(Vm.class)})));
            insns.add(InsnsGenerator.STORE_CONTPARAM);
            insns.addAll(this.lvarAccGen.storeLvar(lvar));
        }
        for (LetRecItree.LvarFunPair pair : itree.lvarFunPairs()) {
            lvar = pair.lvar();
            if (this.lvarAccGen.isUnused(lvar)) continue;
            insns.addAll(this.lvarAccGen.loadLvarAllowNull(lvar));
            insns.add(InsnsGenerator.LOAD_CONTPARAM);
            insns.add(new Insn.CheckCast(DELEGATING_FUN_TYPE));
            insns.addAll(this.makeFunGen.makeFun(pair.fun()));
            insns.add(INVOKE_WRAP);
        }
        return insns;
    }
}

