/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.util.List;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.InsnsGenerator;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
enum ResultContext {
    TAIL{

        @Override
        List<Insn> returnOnTail() {
            return List.of(InsnsGenerator.LOAD_STACKMACHINE, InsnsGenerator.LOAD_CONTPARAM, InsnsGenerator.INVOKE_TRANSITION_TO_RESULT, new Insn.ReturnValue());
        }

        @Override
        List<Insn> returnOnTailOrMark(String labelKey) {
            return this.returnOnTail();
        }

        @Override
        Trace onTailOrNot(Trace trace) {
            return trace.onTail();
        }

        @Override
        ResultContext actAsTail() {
            return TAIL;
        }
    }
    ,
    NON_TAIL{

        @Override
        List<Insn> returnOnTail() {
            return List.of();
        }

        @Override
        List<Insn> returnOnTailOrMark(String labelKey) {
            return List.of(new Insn.Mark(labelKey));
        }

        @Override
        Trace onTailOrNot(Trace trace) {
            return trace;
        }

        @Override
        ResultContext actAsTail() {
            return SYNTHETIC_TAIL;
        }
    }
    ,
    SYNTHETIC_TAIL{

        @Override
        List<Insn> returnOnTail() {
            return List.of();
        }

        @Override
        List<Insn> returnOnTailOrMark(String labelKey) {
            return List.of(new Insn.Mark(labelKey));
        }

        @Override
        Trace onTailOrNot(Trace trace) {
            return trace.onTail();
        }

        @Override
        ResultContext actAsTail() {
            return SYNTHETIC_TAIL;
        }
    };


    abstract List<Insn> returnOnTail();

    abstract List<Insn> returnOnTailOrMark(String var1);

    abstract Trace onTailOrNot(Trace var1);

    abstract ResultContext actAsTail();
}

