/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.tempval;

import java.util.Locale;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;

public class IntVal
extends Val {
    private final int num;

    public IntVal(Vm vm, int num) {
        super(vm);
        this.num = num;
    }

    public static IntVal of(Vm vm, int num) {
        Holder ih = vm.component.get(Holder.class);
        return ih.of(num);
    }

    public int getInt() {
        return this.num;
    }

    public String toString() {
        return String.format(Locale.ROOT, "IntVal(%d)", this.num);
    }

    public int hashCode() {
        return this.num;
    }

    public boolean equals(Object arg) {
        return arg == this || arg instanceof IntVal && this.vm.equals(((IntVal)arg).vm) && this.getInt() == ((IntVal)arg).getInt();
    }

    public static class Holder {
        private final Vm vm;
        private final IntVal[] cache = new IntVal[201];
        private static final int MIN_CACHED = -100;
        private static final int MAX_CACHED = 100;

        public Holder(Vm vm) {
            this.vm = vm;
        }

        public IntVal of(int num) {
            return -100 <= num && num <= 100 ? this.cache[num - -100] : new IntVal(this.vm, num);
        }

        public void init() {
            for (int i = -100; i <= 100; ++i) {
                this.cache[i - -100] = new IntVal(this.vm, i);
            }
        }
    }
}

