/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.intrinsicsupport;

import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.internal.compile.tempval.IntVal;
import org.kink_lang.kink.internal.intrinsicsupport.BranchSupport;

public class FunsHolder {
    private final Vm vm;
    private final FunVal raiseBranchCondNotBool;

    FunsHolder(Vm vm) {
        this.vm = vm;
        this.raiseBranchCondNotBool = vm.fun.make().take(2).action(this::raiseBranchCondNotBool);
    }

    private static FunsHolder instance(Vm vm) {
        return vm.component.getOrRegister(FunsHolder.class, FunsHolder::new);
    }

    public static FunVal wrongNumberOfArgs(Vm vm, int paramCount, GraphNode params, VecVal args) {
        int argsCount = args.toList().size();
        String template = argsCount < paramCount ? "too few args: for {}, got {}" : "too many args: for {}, got {}";
        return vm.fun.make().action(c -> c.call(vm.graph.raiseFormat(template, params, vm.graph.repr(args))));
    }

    public static FunVal raiseNotVecRhs(Vm vm, Val rhs) {
        return vm.fun.make().action(c -> c.call(vm.graph.raiseFormat("Vec.op_store(Rhs): the arg must be a vec, but got {}", vm.graph.repr(rhs))));
    }

    private HostResult raiseBranchCondNotBool(CallContext c) {
        Val indVal = c.arg(0);
        int ind = ((IntVal)indVal).getInt();
        Val actual = c.arg(1);
        return c.call(BranchSupport.condNotBool(this.vm, ind, actual));
    }

    public static FunVal getRaiseBranchCondNotBool(Vm vm) {
        return FunsHolder.instance((Vm)vm).raiseBranchCondNotBool;
    }
}

