/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.mod.java;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostResult;

class ThrowerVal
extends Val {
    private final Throwable thrown;

    private ThrowerVal(Vm vm, SharedVars sharedVars, Throwable thrown) {
        super(vm, sharedVars);
        this.thrown = thrown;
    }

    static ThrowerVal of(Vm vm, Throwable thrown) {
        ThrowerHelper helper = ThrowerHelper.of(vm);
        return new ThrowerVal(vm, helper.sharedVars, thrown);
    }

    Throwable getThrown() {
        return this.thrown;
    }

    public String toString() {
        return String.format(Locale.ROOT, "ThrowerVal(%s)", this.thrown);
    }

    private List<Object> getProperties() {
        return List.of(this.vm, this.thrown);
    }

    public int hashCode() {
        return this.getProperties().hashCode();
    }

    public boolean equals(Object arg) {
        return arg == this || arg instanceof ThrowerVal && this.getProperties().equals(((ThrowerVal)arg).getProperties());
    }

    static class ThrowerHelper {
        private final Vm vm;
        final SharedVars sharedVars;

        private ThrowerHelper(Vm vm) {
            this.vm = vm;
            this.sharedVars = this.makeSharedVars();
        }

        static ThrowerHelper of(Vm vm) {
            return vm.component.getOrRegister(ThrowerHelper.class, ThrowerHelper::new);
        }

        private SharedVars makeSharedVars() {
            HashMap<Integer, Val> map = new HashMap<Integer, Val>();
            map.put(this.vm.sym.handleFor("thrown"), this.vm.fun.make("Thrower.thrown").take(0).action(this::thrownMethod));
            map.put(this.vm.sym.handleFor("repr"), this.vm.fun.make("Thrower.repr").take(0).action(this::reprMethod));
            return this.vm.sharedVars.of(map);
        }

        private HostResult thrownMethod(CallContext c) {
            Val recv = c.recv();
            if (!(recv instanceof ThrowerVal)) {
                return c.call(this.vm.graph.raiseFormat("Thrower.thrown: recv must be a thrower, but got {}", this.vm.graph.repr(recv)));
            }
            ThrowerVal thrower = (ThrowerVal)recv;
            return this.vm.java.of(thrower.getThrown(), Throwable.class);
        }

        private HostResult reprMethod(CallContext c) {
            Val recv = c.recv();
            if (!(recv instanceof ThrowerVal)) {
                return c.call(this.vm.graph.raiseFormat("Thrower.repr: recv must be a thrower, but got {}", this.vm.graph.repr(recv)));
            }
            ThrowerVal thrower = (ThrowerVal)recv;
            return this.vm.str.of(String.format(Locale.ROOT, "Thrower(%s)", thrower.getThrown()));
        }
    }
}

