/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.mod.random;

import java.util.Arrays;
import java.util.Random;
import org.kink_lang.kink.internal.contract.Preconds;

public class Xoshiro256StarStar
extends Random {
    private final long[] s = new long[4];
    private static final long serialVersionUID = 7026018537194797769L;

    public Xoshiro256StarStar(long s0, long s1, long s2, long s3) {
        Preconds.checkArg(s0 != 0L || s1 != 0L || s2 != 0L || s3 != 0L, "state must not be all zero");
        this.s[0] = s0;
        this.s[1] = s1;
        this.s[2] = s2;
        this.s[3] = s3;
    }

    long[] getState() {
        return Arrays.copyOf(this.s, this.s.length);
    }

    @Override
    public long nextLong() {
        long result = Long.rotateLeft(this.s[1] * 5L, 7) * 9L;
        long t = this.s[1] << 17;
        this.s[2] = this.s[2] ^ this.s[0];
        this.s[3] = this.s[3] ^ this.s[1];
        this.s[1] = this.s[1] ^ this.s[2];
        this.s[0] = this.s[0] ^ this.s[3];
        this.s[2] = this.s[2] ^ t;
        this.s[3] = Long.rotateLeft(this.s[3], 45);
        return result;
    }

    @Override
    public boolean nextBoolean() {
        return this.nextLong() < 0L;
    }

    @Override
    public int next(int bits) {
        return (int)(this.nextLong() >>> 64 - bits);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        for (int i = 0; i < bytes.length; i += 8) {
            int remainingBytes = bytes.length - i;
            long random = this.nextLong();
            for (int j = 0; j < Math.min(8, remainingBytes); ++j) {
                int discardedBits = (8 - (j + 1)) * 8;
                bytes[i + j] = (byte)(random >>> discardedBits);
            }
        }
    }
}

