/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.kink_lang.kink.internal.program.itree.ArgVecItree;
import org.kink_lang.kink.internal.program.itree.BindingItree;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.LderefItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.NadaItree;
import org.kink_lang.kink.internal.program.itree.NumItree;
import org.kink_lang.kink.internal.program.itree.RecvItree;
import org.kink_lang.kink.internal.program.itree.SeqItree;
import org.kink_lang.kink.internal.program.itree.SkeltonItreeVisitor;
import org.kink_lang.kink.internal.program.itree.SlowFunItree;
import org.kink_lang.kink.internal.program.itree.StrItree;
import org.kink_lang.kink.internal.program.itree.VarrefItree;
import org.kink_lang.kink.internal.program.itree.VecItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;

public class EliminateUnusedOptimizer
extends BaseOptimizer {
    @Override
    public Itree visit(SeqItree seq) {
        List<Itree> steps = seq.steps();
        List<Itree> stepsButLast = steps.subList(0, steps.size() - 1);
        Itree last = steps.get(steps.size() - 1);
        ArrayList<Itree> resultSteps = new ArrayList<Itree>(stepsButLast.stream().flatMap(itree -> itree.accept(new Eliminator()).stream()).collect(Collectors.toList()));
        resultSteps.add(last);
        return new SeqItree(resultSteps, seq.pos());
    }

    private static class Eliminator
    extends SkeltonItreeVisitor<List<Itree>> {
        Eliminator() {
            super(itree -> List.of(itree));
        }

        @Override
        public List<Itree> visit(NadaItree itree) {
            return List.of();
        }

        @Override
        public List<Itree> visit(StrItree itree) {
            return List.of();
        }

        @Override
        public List<Itree> visit(NumItree itree) {
            return List.of();
        }

        @Override
        public List<Itree> visit(BindingItree itree) {
            return List.of();
        }

        @Override
        public List<Itree> visit(RecvItree itree) {
            return List.of();
        }

        @Override
        public List<Itree> visit(ArgVecItree itree) {
            return List.of();
        }

        @Override
        public List<Itree> visit(SlowFunItree itree) {
            return List.of();
        }

        @Override
        public List<Itree> visit(FastFunItree itree) {
            return List.of();
        }

        @Override
        public List<Itree> visit(VarrefItree itree) {
            return List.of(itree.owner());
        }

        @Override
        public List<Itree> visit(VecItree itree) {
            return itree.elems().stream().map(ItreeElem::expr).collect(Collectors.toList());
        }

        @Override
        public List<Itree> visit(LderefItree itree) {
            return itree.lvar() instanceof LocalVar.Original ? List.of(itree) : List.of();
        }
    }
}

