/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.LetRecItree;
import org.kink_lang.kink.internal.program.itree.SeqItree;
import org.kink_lang.kink.internal.program.itreeoptimize.BaseOptimizer;
import org.kink_lang.kink.internal.program.itreeoptimize.Operations;

public class LetRecChainer
extends BaseOptimizer {
    @Override
    public Itree visit(SeqItree seq) {
        ArrayList<Itree> resultSteps = new ArrayList<Itree>();
        ArrayList<LetRecItree> consequent = new ArrayList<LetRecItree>();
        Supplier<Void> addChainIfAny = () -> {
            if (!consequent.isEmpty()) {
                resultSteps.add(this.chain(consequent));
                consequent.clear();
            }
            return null;
        };
        for (Itree step : Operations.toSteps(seq)) {
            if (step instanceof LetRecItree) {
                consequent.add((LetRecItree)step);
                continue;
            }
            addChainIfAny.get();
            resultSteps.add(step);
        }
        addChainIfAny.get();
        return new SeqItree(resultSteps, seq.pos());
    }

    private LetRecItree chain(List<LetRecItree> consequent) {
        int pos = consequent.get(0).pos();
        List<LetRecItree.LvarFunPair> pairs = consequent.stream().flatMap(letrec -> letrec.lvarFunPairs().stream()).toList();
        return new LetRecItree(pairs, pos);
    }
}

