/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.str;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;

public class Encoder {
    private final CharsetEncoder csEncoder;
    private final CharBuffer charBuffer;
    private final ByteBuffer byteBuffer;
    private boolean isTerminated;

    Encoder(CharsetEncoder csEncoder, CharBuffer charBuffer, ByteBuffer byteBuffer) {
        this.csEncoder = csEncoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.charBuffer = charBuffer;
        this.byteBuffer = byteBuffer;
    }

    public static Encoder of(CharsetEncoder csEncoder) {
        CharBuffer charBuffer = CharBuffer.wrap(new char[1024]);
        int bbSize = charBuffer.capacity() * (int)Math.ceil(csEncoder.maxBytesPerChar());
        ByteBuffer byteBuffer = ByteBuffer.allocate(bbSize);
        return new Encoder(csEncoder, charBuffer, byteBuffer);
    }

    public byte[] encode(String str) {
        byte[] bytes = new byte[]{};
        CharSequence seq = str;
        while (seq.length() > 0) {
            int size = Math.min(seq.length(), this.charBuffer.remaining());
            this.charBuffer.append(seq.subSequence(0, size));
            this.charBuffer.flip();
            this.csEncoder.encode(this.charBuffer, this.byteBuffer, false);
            this.charBuffer.compact();
            this.byteBuffer.flip();
            byte[] newBytes = new byte[bytes.length + this.byteBuffer.limit()];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            this.byteBuffer.get(newBytes, bytes.length, this.byteBuffer.limit());
            this.byteBuffer.clear();
            bytes = newBytes;
            seq = seq.subSequence(size, seq.length());
        }
        return bytes;
    }

    public byte[] terminate() {
        this.isTerminated = true;
        this.csEncoder.encode(CharBuffer.wrap(new char[0]), this.byteBuffer, true);
        this.csEncoder.flush(this.byteBuffer);
        this.byteBuffer.flip();
        byte[] bytes = new byte[this.byteBuffer.limit()];
        this.byteBuffer.get(bytes);
        this.byteBuffer.clear();
        return bytes;
    }

    boolean isTerminated() {
        return this.isTerminated;
    }
}

