/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.sym;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.kink_lang.kink.SymRegistry;
import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.intrinsicsupport.PreloadedFuns;

public class SymRegistryImpl
implements SymRegistry {
    private final int maxSymHandle;
    private final AtomicReference<Mapping> mappingRef;
    private static final int MAX_SYM_HANDLE = 0x3FFFFFFF;
    public static final int MAX_PRELOADED_CONTROL = PreloadedFuns.controlSyms().size();
    public static final int REPR = MAX_PRELOADED_CONTROL + 1;

    public SymRegistryImpl() {
        this(0x3FFFFFFF);
    }

    SymRegistryImpl(int maxSymHandle) {
        this.maxSymHandle = maxSymHandle;
        Mapping mapping = new Mapping();
        mapping = mapping.add("");
        for (String controlSym : PreloadedFuns.controlSyms()) {
            mapping = mapping.add(controlSym);
        }
        mapping = mapping.add("repr");
        this.mappingRef = new AtomicReference<Mapping>(mapping);
    }

    @Override
    public int handleFor(String sym) {
        Mapping mapping;
        Integer handle;
        while ((handle = (mapping = this.mappingRef.get()).getHandle(sym)) == null) {
            Preconds.checkState(mapping.getLastSymHandle() < this.maxSymHandle, "cannot register any more syms");
            Mapping newMapping = mapping.add(sym);
            this.mappingRef.compareAndSet(mapping, newMapping);
        }
        return handle;
    }

    @Override
    public String symFor(int handle) {
        Mapping mapping = this.mappingRef.get();
        Preconds.checkArg(mapping.isValidHandle(handle), "unregistred handle");
        return mapping.getSym(handle);
    }

    @Override
    public boolean isValidHandle(int handle) {
        Mapping mapping = this.mappingRef.get();
        return mapping.isValidHandle(handle);
    }

    int getLastSymHandle() {
        Mapping mapping = this.mappingRef.get();
        return mapping.getLastSymHandle();
    }

    public static boolean isPreloaded(int handle) {
        return 1 <= handle && handle <= MAX_PRELOADED_CONTROL;
    }

    private static class Mapping {
        private final Map<String, Integer> symToHandle;
        private final String[] handleM1ToSym;

        Mapping() {
            this(Collections.emptyMap(), new String[0]);
        }

        Mapping(Map<String, Integer> symToHandle, String[] handleM1ToSym) {
            this.symToHandle = symToHandle;
            this.handleM1ToSym = handleM1ToSym;
        }

        Mapping add(String sym) {
            String internedSym = sym.intern();
            int newHandle = this.handleM1ToSym.length;
            HashMap<String, Integer> newMap = new HashMap<String, Integer>(this.symToHandle);
            Integer old = newMap.put(internedSym, newHandle);
            assert (old == null);
            String[] newArray = new String[this.handleM1ToSym.length + 1];
            System.arraycopy(this.handleM1ToSym, 0, newArray, 0, this.handleM1ToSym.length);
            newArray[newHandle] = internedSym;
            return new Mapping(newMap, newArray);
        }

        @Nullable
        Integer getHandle(String sym) {
            return this.symToHandle.get(sym);
        }

        String getSym(int handle) {
            return this.handleM1ToSym[handle];
        }

        boolean isValidHandle(int handle) {
            return 0 <= handle && handle <= this.getLastSymHandle();
        }

        int getLastSymHandle() {
            return this.handleM1ToSym.length - 1;
        }
    }
}

