/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VarrefVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction3;

public class VarrefHelper {
    private final Vm vm;
    private int passArgHandle;
    private int passNothingHandle;
    private int passRestHandle;
    private int reprHandle;
    SharedVars sharedVars;

    VarrefHelper(Vm vm) {
        this.vm = vm;
    }

    public VarrefVal of(Val owner, int symHandle) {
        return new VarrefVal(owner, symHandle);
    }

    public VarrefVal of(Val owner, String sym) {
        return new VarrefVal(owner, this.vm.sym.handleFor(sym));
    }

    void init() {
        this.passArgHandle = this.vm.sym.handleFor("pass_arg");
        this.passNothingHandle = this.vm.sym.handleFor("pass_nothing");
        this.passRestHandle = this.vm.sym.handleFor("pass_rest");
        this.reprHandle = this.vm.sym.handleFor("repr");
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        this.addMethod(vars, "Varref", "owner", "", 0, (c, desc, varref) -> varref.owner());
        this.addMethod(vars, "Varref", "sym", "", 0, (c, desc, varref) -> this.vm.str.of(varref.sym()));
        this.addMethod(vars, "Varref", "op_store", "(Target)", 1, this::opStoreMethod);
        this.addMethod(vars, "Varref", "load", "", 0, this::loadMethod);
        this.addMethod(vars, "Varref", "empty?", "", 0, this::emptyPMethod);
        this.addMethod(vars, "Varref", "require_from", "(Prefix)", 1, this::requireFromMethod);
        this.addMethod(vars, "Varref", "rest", "", 0, this::restMethod);
        this.addMethod(vars, "Varref", "opt", "", 0, this::optMethod);
        this.addMethod(vars, "Varref", "repr", "", 0, this::reprMethod);
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult opStoreMethod(CallContext c, String desc, VarrefVal varref) {
        varref.owner().setVar(varref.symHandle(), c.arg(0));
        return this.vm.nada;
    }

    private HostResult loadMethod(HostContext c, String desc, VarrefVal varref) {
        Val target = varref.owner().getVar(varref.symHandle());
        return target != null ? target : c.raise(String.format(Locale.ROOT, "%s: :%s is empty", desc, varref.sym()));
    }

    private HostResult emptyPMethod(HostContext c, String desc, VarrefVal varref) {
        Val owner = varref.owner();
        int symHandle = varref.symHandle();
        return this.vm.bool.of(!owner.hasVar(symHandle));
    }

    private HostResult requireFromMethod(CallContext c, String desc, VarrefVal varref) throws Throwable {
        Val val = c.arg(0);
        if (!(val instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("{}: Prefix must be a str, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.repr(c.arg(0))));
        }
        StrVal prefix = (StrVal)val;
        String modName = prefix.string() + varref.sym();
        FunVal successCont = this.vm.fun.make().take(1).action(cc -> {
            Val mod = cc.arg(0);
            varref.owner().setVar(varref.symHandle(), mod);
            return this.vm.nada;
        });
        return this.vm.mod.require(c, modName, successCont, null, null);
    }

    private HostResult restMethod(HostContext c, String desc, VarrefVal varref) {
        return this.makeRestParam(varref.owner(), varref.symHandle());
    }

    private Val makeRestParam(Val owner, int symHandle) {
        Val param = this.vm.newVal();
        String prefix = "Rest_param.pass_rest(Rest_args)";
        param.setVar(this.passRestHandle, this.vm.fun.make(prefix).take(1).action(c -> {
            owner.setVar(symHandle, c.arg(0));
            return this.vm.nada;
        }));
        param.setVar(this.reprHandle, this.vm.fun.make("Rest_param.repr").take(0).action(c -> this.vm.str.of(String.format(Locale.ROOT, ":%s.rest", this.vm.sym.symFor(symHandle)))));
        return param;
    }

    private HostResult optMethod(HostContext c, String desc, VarrefVal varref) {
        return this.makeOptParam(varref.owner(), varref.symHandle());
    }

    private Val makeOptParam(Val owner, int symHandle) {
        Val param = this.vm.newVal();
        param.setVar(this.passArgHandle, this.vm.fun.make("Opt_param.pass_arg(Arg)").take(1).action(c -> {
            owner.setVar(symHandle, this.vm.vec.of(c.arg(0)));
            return this.vm.nada;
        }));
        param.setVar(this.passNothingHandle, this.vm.fun.make("Opt_param.pass_nothing").take(0).action(c -> {
            owner.setVar(symHandle, this.vm.vec.of());
            return this.vm.nada;
        }));
        param.setVar(this.reprHandle, this.vm.fun.make("Opt_param.repr").take(0).action(c -> this.vm.str.of(String.format(Locale.ROOT, ":%s.opt", this.vm.sym.symFor(symHandle)))));
        return param;
    }

    private HostResult reprMethod(HostContext c, String desc, VarrefVal varref) {
        return this.vm.str.of(":" + varref.sym());
    }

    private void addMethod(Map<Integer, Val> vars, String recvDesc, String sym, String argsDesc, int arity, ThrowingFunction3<CallContext, String, VarrefVal, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s%s", recvDesc, sym, argsDesc);
        FunVal fun = this.vm.fun.make(desc).take(arity).action(c -> {
            Val patt6921$temp = c.recv();
            if (!(patt6921$temp instanceof VarrefVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be varref, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(c.recv())));
            }
            VarrefVal recv = (VarrefVal)patt6921$temp;
            return (HostResult)action.apply(c, desc, recv);
        });
        vars.put(this.vm.sym.handleFor(sym), fun);
    }
}

