/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.compile.javaclassir;

import java.lang.invoke.CallSite;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.NumHelper;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.VarrefHelper;
import org.kink_lang.kink.VarrefVal;
import org.kink_lang.kink.VecHelper;
import org.kink_lang.kink.VecVal;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.internal.callstack.CallStack;
import org.kink_lang.kink.internal.callstack.Cse;
import org.kink_lang.kink.internal.callstack.FakeCallTraceCse;
import org.kink_lang.kink.internal.callstack.Location;
import org.kink_lang.kink.internal.callstack.ResumeCse;
import org.kink_lang.kink.internal.callstack.Trace;
import org.kink_lang.kink.internal.compile.bootstrap.ConstBootstrapper;
import org.kink_lang.kink.internal.compile.bootstrap.TraceBootstrapper;
import org.kink_lang.kink.internal.compile.javaclassir.BindingGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ChildJcirAccumulator;
import org.kink_lang.kink.internal.compile.javaclassir.ControlGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.Insn;
import org.kink_lang.kink.internal.compile.javaclassir.JavaClassIr;
import org.kink_lang.kink.internal.compile.javaclassir.KeyStrSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.LetRecGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.LvarAccessGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.MakeFastFunGenerator;
import org.kink_lang.kink.internal.compile.javaclassir.ProgramCounterSupplier;
import org.kink_lang.kink.internal.compile.javaclassir.ResultContext;
import org.kink_lang.kink.internal.compile.javaclassir.SlowFunCompiler;
import org.kink_lang.kink.internal.compile.javaclassir.TraceAccumulator;
import org.kink_lang.kink.internal.program.itree.ArgVecItree;
import org.kink_lang.kink.internal.program.itree.ArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.AssignmentItree;
import org.kink_lang.kink.internal.program.itree.BiArithmeticItree;
import org.kink_lang.kink.internal.program.itree.BindingItree;
import org.kink_lang.kink.internal.program.itree.BranchItree;
import org.kink_lang.kink.internal.program.itree.BranchWithElseItree;
import org.kink_lang.kink.internal.program.itree.DerefItree;
import org.kink_lang.kink.internal.program.itree.FastFunItree;
import org.kink_lang.kink.internal.program.itree.GenericVar;
import org.kink_lang.kink.internal.program.itree.IfItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.ItreeVisitor;
import org.kink_lang.kink.internal.program.itree.LderefItree;
import org.kink_lang.kink.internal.program.itree.LetRecItree;
import org.kink_lang.kink.internal.program.itree.LocalVar;
import org.kink_lang.kink.internal.program.itree.LstoreItree;
import org.kink_lang.kink.internal.program.itree.McallItree;
import org.kink_lang.kink.internal.program.itree.NadaItree;
import org.kink_lang.kink.internal.program.itree.NestedArgsPassingItree;
import org.kink_lang.kink.internal.program.itree.NestedParam;
import org.kink_lang.kink.internal.program.itree.NestedVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.NoTraitNewValItree;
import org.kink_lang.kink.internal.program.itree.NumItree;
import org.kink_lang.kink.internal.program.itree.OptRestVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.OptVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.RecvItree;
import org.kink_lang.kink.internal.program.itree.RestVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.SeqItree;
import org.kink_lang.kink.internal.program.itree.SlowFunItree;
import org.kink_lang.kink.internal.program.itree.StoreItree;
import org.kink_lang.kink.internal.program.itree.StrItree;
import org.kink_lang.kink.internal.program.itree.SymcallItree;
import org.kink_lang.kink.internal.program.itree.TraitNewValItree;
import org.kink_lang.kink.internal.program.itree.VarrefItree;
import org.kink_lang.kink.internal.program.itree.VarrefParam;
import org.kink_lang.kink.internal.program.itree.VarrefVecAssignmentItree;
import org.kink_lang.kink.internal.program.itree.VecItree;
import org.kink_lang.kink.internal.vec.VecInternal;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class InsnsGenerator {
    private final Vm vm;
    private final String programName;
    private final String programText;
    private final BindingGenerator bindingGen;
    private final LvarAccessGenerator lvarAccGen;
    private final LetRecGenerator letRecGen;
    private final ControlGenerator controlGen;
    private final KeyStrSupplier keySup;
    private final MakeFastFunGenerator makeFastFunGen;
    private final TraceAccumulator traceAccum;
    private final ProgramCounterSupplier pcSup;
    private final ChildJcirAccumulator jcirAccum;
    static final Type STACKMACHINE_TYPE = Type.getType((String)"Lorg/kink_lang/kink/StackMachine;");
    static final Type DATASTACK_TYPE = Type.getType((String)"Lorg/kink_lang/kink/DataStack;");
    static final String PROGRAMCOUNTER_KEY = "pc";
    static final Insn PRODUCE_NADA = new Insn.InvokeDynamic(MethodType.methodType(Val.class), new Handle(6, Type.getType(ConstBootstrapper.class).getInternalName(), "bootstrapNada", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class).descriptorString(), false), List.of());
    static final Insn LOAD_STACKMACHINE = new Insn.LoadArg(0);
    static final Insn STORE_CONTPARAM = new Insn.StoreArg(1);
    static final Insn LOAD_CONTPARAM = new Insn.LoadArg(1);
    static final Insn LOAD_CALLSTACK = new Insn.LoadArg(3);
    static final Insn LOAD_DATASTACK = new Insn.LoadArg(4);
    static final Insn LOAD_ARGCOUNT = new Insn.LoadArg(5);
    static final Insn INVOKE_BIG_DECIMAL = new Insn.InvokeVirtual(Type.getType(NumVal.class), new Method("bigDecimal", Type.getType(BigDecimal.class), new Type[0]));
    static final Insn INVOKE_INT_VALUE = new Insn.InvokeVirtual(Type.getType(BigDecimal.class), new Method("intValue", Type.INT_TYPE, new Type[0]));
    static final Insn INVOKE_TOP_OFFSET = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("topOffset", Type.INT_TYPE, new Type[0]));
    static final Insn INVOKE_PUSH_TO_DATASTACK = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("push", Type.VOID_TYPE, new Type[]{Type.getType(Val.class)}));
    static final Insn INVOKE_POP_FROM_DATASTACK = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("pop", Type.getType(Val.class), new Type[0]));
    static final Insn INVOKE_AT_OFFSET = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("atOffset", Type.getType(Val.class), new Type[]{Type.INT_TYPE}));
    static final Insn INVOKE_SET_AT_OFFSET = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("setAtOffset", Type.VOID_TYPE, new Type[]{Type.getType(Integer.TYPE), Type.getType(Val.class)}));
    static final Insn INVOKE_RECV = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("recv", Type.getType(Val.class), new Type[0]));
    static final Insn INVOKE_ARG = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("arg", Type.getType(Val.class), new Type[]{Type.INT_TYPE}));
    static final Insn INVOKE_ARG_VEC = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("argVec", Type.getType(VecVal.class), new Type[]{Type.INT_TYPE}));
    static final Insn INVOKE_PUSH_CSE = new Insn.InvokeVirtual(Type.getType(CallStack.class), new Method("pushCse", Type.VOID_TYPE, new Type[]{Type.getType(Cse.class), Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE}));
    static final Insn INVOKE_NUM_OF_INT = new Insn.InvokeVirtual(Type.getType(NumHelper.class), new Method("of", Type.getType(NumVal.class), new Type[]{Type.INT_TYPE}));
    static final Insn INVOKE_REMOVE_FROM_OFFSET = new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("removeFromOffset", Type.VOID_TYPE, new Type[]{Type.INT_TYPE}));
    static final Insn INVOKE_TRANSITION_TO_CALL = new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("transitionToCall", Type.VOID_TYPE, new Type[]{Type.getType(FunVal.class)}));
    static final Insn INVOKE_TRANSITION_TO_RESULT = new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("transitionToResult", Type.VOID_TYPE, new Type[]{Type.getType(Val.class)}));
    static final Insn INVOKE_CALL_FUN = new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("callFun", Type.VOID_TYPE, new Type[]{Type.getType(ResumeCse.class), Type.INT_TYPE, Type.INT_TYPE}));
    static final Insn INVOKE_RAISE_WRONG_NUMBER_OF_ARGS = new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("raiseWrongNumberOfArgs", Type.VOID_TYPE, new Type[]{Type.INT_TYPE, Type.getType(String.class), Type.getType(VecVal.class)}));
    static final Insn INVOKE_RAISE_NOT_VEC_RHS = new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("raiseNotVecRhs", Type.VOID_TYPE, new Type[]{Type.getType(Val.class)}));
    static final Insn INVOKE_RAISE_NOT_FUN = new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("raiseNotFun", Type.VOID_TYPE, new Type[]{Type.getType(Val.class), Type.getType(String.class), Type.getType(Trace.class)}));
    static final Insn INVOKE_VEC_INTERNAL = new Insn.InvokeVirtual(Type.getType(VecVal.class), new Method("vecInternal", Type.getType(VecInternal.class), new Type[0]));
    static final Insn INVOKE_VEC_INTERNAL_GET = new Insn.InvokeVirtual(Type.getType(VecInternal.class), new Method("get", Type.getType(Val.class), new Type[]{Type.INT_TYPE}));
    static final Insn INVOKE_VEC_INTERNAL_SIZE = new Insn.InvokeVirtual(Type.getType(VecInternal.class), new Method("size", Type.INT_TYPE, new Type[0]));
    static final Insn INVOKE_VEC_OF_EMPTY = new Insn.InvokeVirtual(Type.getType(VecHelper.class), new Method("of", Type.getType(VecVal.class), new Type[0]));
    static final Insn INVOKE_VEC_OF_SINGLE = new Insn.InvokeVirtual(Type.getType(VecHelper.class), new Method("of", Type.getType(VecVal.class), new Type[]{Type.getType(Val.class)}));
    static final Insn INVOKE_VEC_CONSTRUCTOR = new Insn.InvokeConstructor(Type.getType(VecVal.class), new Method("<init>", Type.VOID_TYPE, new Type[]{Type.getType(Vm.class), Type.getType(VecInternal.class)}));
    static final List<Insn> LOAD_VM = List.of(new Insn.LoadThis(), new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)));
    static final Insn LOAD_VEC_HELPER = new Insn.GetField(Type.getType(Vm.class), "vec", Type.getType(VecHelper.class));
    static final Handle BOOTSTRAP_TRACE_HANDLE = new Handle(6, Type.getType(TraceBootstrapper.class).getInternalName(), "bootstrapTrace", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE).descriptorString(), false);
    static final Handle BOOTSTRAP_FAKE_CALL_CSE = new Handle(6, Type.getType(TraceBootstrapper.class).getInternalName(), "bootstrapFakeCallCse", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE).descriptorString(), false);
    static final Handle BOOTSTRAP_STR_HANDLE = new Handle(6, Type.getType(ConstBootstrapper.class).getInternalName(), "bootstrapStr", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class).descriptorString(), false);
    static final Handle BOOTSTRAP_NUM_HANDLE = new Handle(6, Type.getType(ConstBootstrapper.class).getInternalName(), "bootstrapNum", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class).descriptorString(), false);
    static final Handle BOOTSTRAP_BIGDECIMAL_HANDLE = new Handle(6, Type.getType(ConstBootstrapper.class).getInternalName(), "bootstrapBigDecimal", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class).descriptorString(), false);
    static final Handle BOOTSTRAP_GET_VAR_HANDLE = new Handle(6, "org/kink_lang/kink/GetVarBootstrapper", "bootstrapGetVar", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE).descriptorString(), false);
    static final Handle BOOTSTRAP_SET_VAR_HANDLE = new Handle(6, "org/kink_lang/kink/SetVarBootstrapper", "bootstrapSetVar", MethodType.methodType(CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE).descriptorString(), false);
    private static final List<Insn> MAKE_EMPTY_VEC = List.of(new Insn.LoadThis(), new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class)), LOAD_VEC_HELPER, INVOKE_VEC_OF_EMPTY, STORE_CONTPARAM);

    public InsnsGenerator(Vm vm, String programName, String programText, BindingGenerator bindingGen, LvarAccessGenerator lvarAccGen, MakeFastFunGenerator makeFastFunGen, LetRecGenerator letRecGen, ControlGenerator controlGen, KeyStrSupplier keySup, TraceAccumulator traceAccum, ProgramCounterSupplier pcSup, ChildJcirAccumulator jcirAccum) {
        this.vm = vm;
        this.programName = programName;
        this.programText = programText;
        this.bindingGen = bindingGen;
        this.lvarAccGen = lvarAccGen;
        this.makeFastFunGen = makeFastFunGen;
        this.letRecGen = letRecGen;
        this.controlGen = controlGen;
        this.keySup = keySup;
        this.traceAccum = traceAccum;
        this.pcSup = pcSup;
        this.jcirAccum = jcirAccum;
    }

    public List<Insn> generate(Itree itree, ResultContext resultCtx) {
        Visitor visitor = new Visitor(resultCtx);
        return List.copyOf((Collection)itree.accept(visitor));
    }

    private Insn produceTrace(Trace trace) {
        int traceKey = this.traceAccum.add(trace);
        return new Insn.InvokeDynamic(MethodType.methodType(Trace.class), BOOTSTRAP_TRACE_HANDLE, List.of(Integer.valueOf(traceKey)));
    }

    private List<Insn> deref(String ownerKey, String sym, int pos) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        insns.add(new Insn.LoadLocal(ownerKey));
        insns.add(new Insn.InvokeDynamic(MethodType.methodType(Val.class, Val.class), BOOTSTRAP_GET_VAR_HANDLE, List.of(Integer.valueOf(this.vm.sym.handleFor(sym)))));
        insns.add(STORE_CONTPARAM);
        if (sym.equals("repr")) {
            return insns;
        }
        insns.add(LOAD_CONTPARAM);
        String derefNonnull = this.keySup.newKeyStr("deref-nonnull");
        insns.add(new Insn.IfNonNull(derefNonnull));
        insns.add(LOAD_STACKMACHINE);
        insns.add(new Insn.PushString(sym));
        insns.add(new Insn.LoadLocal(ownerKey));
        insns.add(this.produceTrace(Trace.of(new Location(this.programName, this.programText, pos))));
        insns.add(new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("transitionToRaiseNoSuchVar", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Val.class), Type.getType(Trace.class)})));
        insns.add(new Insn.ReturnValue());
        insns.add(new Insn.Mark(derefNonnull));
        return insns;
    }

    static List<Insn> pushFakeCall(int traceKey) {
        return List.of(LOAD_CALLSTACK, new Insn.InvokeDynamic(MethodType.methodType(FakeCallTraceCse.class), BOOTSTRAP_FAKE_CALL_CSE, List.of(Integer.valueOf(traceKey))), new Insn.PushInt(0), new Insn.PushInt(0), new Insn.PushInt(0), INVOKE_PUSH_CSE);
    }

    private List<Insn> loadCurElemCount(String countKey) {
        return List.of(LOAD_DATASTACK, new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("pop", Type.getType(Val.class), new Type[0])), new Insn.CheckCast(Type.getType(NumVal.class)), INVOKE_BIG_DECIMAL, INVOKE_INT_VALUE, new Insn.StoreNewLocal(countKey, Type.INT_TYPE));
    }

    private List<Insn> spreadElems(ItreeElem.Spread spread) {
        ArrayList<Insn> insns = new ArrayList<Insn>(this.generate(spread.expr(), ResultContext.NON_TAIL));
        insns.add(LOAD_CONTPARAM);
        insns.add(new Insn.InstanceOf(Type.getType(VecVal.class)));
        String isVecLabel = this.keySup.newKeyStr("is-vec");
        insns.add(new Insn.IfNonZero(isVecLabel));
        insns.add(LOAD_STACKMACHINE);
        Insn traceInsn = this.produceTrace(Trace.of(new Location(this.programName, this.programText, spread.pos())));
        insns.add(traceInsn);
        insns.add(LOAD_CONTPARAM);
        insns.add(new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("transitionToCannotSpread", Type.VOID_TYPE, new Type[]{Type.getType(Trace.class), Type.getType(Val.class)})));
        insns.add(new Insn.ReturnValue());
        insns.add(new Insn.Mark(isVecLabel));
        insns.add(LOAD_CONTPARAM);
        insns.add(new Insn.CheckCast(Type.getType(VecVal.class)));
        insns.add(INVOKE_VEC_INTERNAL);
        String viKey = this.keySup.newKeyStr("vi");
        insns.add(new Insn.StoreNewLocal(viKey, Type.getType(VecInternal.class)));
        insns.add(new Insn.LoadLocal(viKey));
        insns.add(INVOKE_VEC_INTERNAL_SIZE);
        String spreadSize = this.keySup.newKeyStr("spreadSize");
        insns.add(new Insn.StoreNewLocal(spreadSize, Type.INT_TYPE));
        insns.add(LOAD_DATASTACK);
        insns.add(new Insn.LoadThis());
        insns.add(new Insn.InvokeVirtual(JavaClassIr.TYPE_BASE, new Method("dataStackUsageUpperBound", Type.INT_TYPE, new Type[0])));
        insns.add(new Insn.LoadLocal(spreadSize));
        insns.add(new Insn.AddInt());
        insns.add(new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("ensureCapaSpPlus", Type.BOOLEAN_TYPE, new Type[]{Type.INT_TYPE})));
        String ensuredLabel = this.keySup.newKeyStr("ensured");
        insns.add(new Insn.IfNonZero(ensuredLabel));
        insns.add(LOAD_STACKMACHINE);
        insns.add(new Insn.PushString("data stack overflow"));
        insns.add(traceInsn);
        insns.add(new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("transitionToRaiseOn", Type.VOID_TYPE, new Type[]{Type.getType(String.class), Type.getType(Trace.class)})));
        insns.add(new Insn.ReturnValue());
        insns.add(new Insn.Mark(ensuredLabel));
        String countKey = this.keySup.newKeyStr("count");
        insns.addAll(this.loadCurElemCount(countKey));
        insns.add(LOAD_DATASTACK);
        insns.add(new Insn.LoadLocal(viKey));
        insns.add(new Insn.LoadLocal(spreadSize));
        insns.add(new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("pushAll", Type.VOID_TYPE, new Type[]{Type.getType(VecInternal.class), Type.INT_TYPE})));
        insns.add(LOAD_DATASTACK);
        insns.addAll(LOAD_VM);
        insns.add(new Insn.GetField(Type.getType(Vm.class), "num", Type.getType(NumHelper.class)));
        insns.add(new Insn.LoadLocal(countKey));
        insns.add(new Insn.LoadLocal(spreadSize));
        insns.add(new Insn.AddInt());
        insns.add(INVOKE_NUM_OF_INT);
        insns.add(INVOKE_PUSH_TO_DATASTACK);
        return insns;
    }

    private List<Insn> pushSingle(Itree itree) {
        ArrayList<Insn> insns = new ArrayList<Insn>(this.generate(itree, ResultContext.NON_TAIL));
        String countKey = this.keySup.newKeyStr("count");
        insns.addAll(this.loadCurElemCount(countKey));
        insns.add(LOAD_DATASTACK);
        insns.add(LOAD_CONTPARAM);
        insns.add(INVOKE_PUSH_TO_DATASTACK);
        insns.add(LOAD_DATASTACK);
        insns.addAll(LOAD_VM);
        insns.add(new Insn.GetField(Type.getType(Vm.class), "num", Type.getType(NumHelper.class)));
        insns.add(new Insn.LoadLocal(countKey));
        insns.add(new Insn.PushInt(1));
        insns.add(new Insn.AddInt());
        insns.add(INVOKE_NUM_OF_INT);
        insns.add(INVOKE_PUSH_TO_DATASTACK);
        return insns;
    }

    private List<Insn> pushElemsWithSpread(List<ItreeElem> elems, String elemCountKey) {
        ArrayList<Insn> insns = new ArrayList<Insn>(List.of(LOAD_DATASTACK, new Insn.InvokeDynamic(MethodType.methodType(Val.class), BOOTSTRAP_NUM_HANDLE, List.of("0")), INVOKE_PUSH_TO_DATASTACK));
        for (ItreeElem elem : elems) {
            List<Insn> list;
            if (elem instanceof ItreeElem.Spread) {
                ItreeElem.Spread spread = (ItreeElem.Spread)elem;
                list = this.spreadElems(spread);
            } else {
                list = this.pushSingle((Itree)elem);
            }
            insns.addAll(list);
        }
        insns.add(LOAD_DATASTACK);
        insns.add(INVOKE_POP_FROM_DATASTACK);
        insns.add(new Insn.CheckCast(Type.getType(NumVal.class)));
        insns.add(INVOKE_BIG_DECIMAL);
        insns.add(INVOKE_INT_VALUE);
        insns.add(new Insn.StoreNewLocal(elemCountKey, Type.INT_TYPE));
        return insns;
    }

    private List<Insn> pushElemsAllSingle(List<Itree> elems, String elemCountKey) {
        ArrayList<Insn> insns = new ArrayList<Insn>();
        for (Itree elem : elems) {
            insns.addAll(this.generate(elem, ResultContext.NON_TAIL));
            insns.add(LOAD_DATASTACK);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_PUSH_TO_DATASTACK);
        }
        insns.add(new Insn.PushInt(elems.size()));
        insns.add(new Insn.StoreNewLocal(elemCountKey, Type.INT_TYPE));
        return insns;
    }

    private List<Insn> pushElems(List<ItreeElem> elems, String elemCountKey) {
        boolean allSingle = elems.stream().allMatch(e -> e instanceof Itree);
        return allSingle ? this.pushElemsAllSingle(elems.stream().map(e -> (Itree)e).toList(), elemCountKey) : this.pushElemsWithSpread(elems, elemCountKey);
    }

    private boolean isSingleton(List<ItreeElem> elems) {
        return elems.size() == 1 && elems.get(0) instanceof Itree;
    }

    private List<Insn> makeSingletonVec(Itree elem) {
        ArrayList<Insn> insns = new ArrayList<Insn>(this.generate(elem, ResultContext.NON_TAIL));
        insns.addAll(LOAD_VM);
        insns.add(LOAD_VEC_HELPER);
        insns.add(LOAD_CONTPARAM);
        insns.add(INVOKE_VEC_OF_SINGLE);
        insns.add(STORE_CONTPARAM);
        return insns;
    }

    private List<Insn> makeVecOnDataStack(List<ItreeElem> elems) {
        String elemCountKey = this.keySup.newKeyStr("elemCount");
        ArrayList<Insn> insns = new ArrayList<Insn>(this.pushElems(elems, elemCountKey));
        insns.add(LOAD_DATASTACK);
        insns.add(INVOKE_TOP_OFFSET);
        insns.add(new Insn.LoadLocal(elemCountKey));
        insns.add(new Insn.SubInt());
        String elemsOffsetKey = this.keySup.newKeyStr("elemsOffset");
        insns.add(new Insn.StoreNewLocal(elemsOffsetKey, Type.INT_TYPE));
        insns.add(LOAD_DATASTACK);
        insns.add(new Insn.LoadLocal(elemsOffsetKey));
        insns.add(new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("makeVecFromOffset", Type.getType(VecVal.class), new Type[]{Type.INT_TYPE})));
        insns.add(STORE_CONTPARAM);
        insns.add(LOAD_DATASTACK);
        insns.add(new Insn.LoadLocal(elemsOffsetKey));
        insns.add(INVOKE_REMOVE_FROM_OFFSET);
        return insns;
    }

    private final class Visitor
    implements ItreeVisitor<List<Insn>> {
        private final ResultContext resultCtx;
        private static final Map<BiArithmeticItree.Op, MethodNames> BI_ARITHMETIC_MAP = Map.of(BiArithmeticItree.Op.ADD, new MethodNames("op_add", "add"), BiArithmeticItree.Op.SUB, new MethodNames("op_sub", "subtract"), BiArithmeticItree.Op.MUL, new MethodNames("op_mul", "multiply"));

        Visitor(ResultContext resultCtx) {
            this.resultCtx = resultCtx;
        }

        private Trace makeCallTrace(String sym, int pos) {
            int symHandle = InsnsGenerator.this.vm.sym.handleFor(sym);
            Location location = new Location(InsnsGenerator.this.programName, InsnsGenerator.this.programText, pos);
            return this.resultCtx.onTailOrNot(Trace.of(symHandle, location));
        }

        private List<Insn> pushArgsAndCall(List<ItreeElem> args, Trace trace, List<Insn> callFunEpilogue) {
            String argCount = InsnsGenerator.this.keySup.newKeyStr("argCount");
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.pushElems(args, argCount));
            insns.addAll(this.doCall(trace, callFunEpilogue, argCount));
            return insns;
        }

        private List<Insn> doCall(Trace trace, List<Insn> callFunEpilogue, String argCount) {
            if (this.resultCtx.equals((Object)ResultContext.TAIL)) {
                return List.of(LOAD_STACKMACHINE, InsnsGenerator.this.produceTrace(trace), new Insn.LoadLocal(argCount), new Insn.InvokeVirtual(STACKMACHINE_TYPE, new Method("tailCallFun", Type.VOID_TYPE, new Type[]{Type.getType(Trace.class), Type.INT_TYPE})), new Insn.ReturnValue());
            }
            ArrayList<Insn> insns = new ArrayList<Insn>(10);
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.LoadThis());
            int resumePc = InsnsGenerator.this.pcSup.newProgramCounter(trace);
            insns.add(new Insn.PushInt(resumePc));
            insns.add(new Insn.LoadLocal(argCount));
            insns.add(INVOKE_CALL_FUN);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Case(InsnsGenerator.PROGRAMCOUNTER_KEY, resumePc));
            insns.addAll(callFunEpilogue);
            return insns;
        }

        @Override
        public List<Insn> visit(NadaItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(List.of(PRODUCE_NADA, STORE_CONTPARAM));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(StrItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(List.of(new Insn.InvokeDynamic(MethodType.methodType(Val.class), BOOTSTRAP_STR_HANDLE, List.of(itree.str())), STORE_CONTPARAM));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(NumItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(List.of(new Insn.InvokeDynamic(MethodType.methodType(Val.class), BOOTSTRAP_NUM_HANDLE, List.of(itree.num().toString())), STORE_CONTPARAM));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(RecvItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(List.of(LOAD_DATASTACK, INVOKE_RECV, STORE_CONTPARAM));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(ArgVecItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(List.of(LOAD_DATASTACK, LOAD_ARGCOUNT, INVOKE_ARG_VEC, STORE_CONTPARAM));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(BindingItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.bindingGen.generateBinding());
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(FastFunItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.makeFastFunGen.makeFun(itree));
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(SlowFunItree itree) {
            SlowFunCompiler compiler = new SlowFunCompiler(InsnsGenerator.this.vm, InsnsGenerator.this.programName, InsnsGenerator.this.programText);
            int jcirInd = InsnsGenerator.this.jcirAccum.add(() -> compiler.compile(itree));
            ArrayList<Insn> insns = new ArrayList<Insn>(List.of(new Insn.LoadThis(), new Insn.GetField(JavaClassIr.TYPE_BASE, "vm", Type.getType(Vm.class))));
            insns.addAll(InsnsGenerator.this.bindingGen.generateBinding());
            insns.add((Insn.GetField)MakeFastFunGenerator.invokeMakeFun(1, jcirInd));
            insns.add((Insn.GetField)STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(LderefItree itree) {
            Location location = new Location(InsnsGenerator.this.programName, InsnsGenerator.this.programText, itree.pos());
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.lvarAccGen.loadLvar(itree.lvar(), location));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(LstoreItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            if (itree.rhs() instanceof RecvItree) {
                insns.addAll(InsnsGenerator.this.lvarAccGen.passRecv(itree.lvar()));
            } else {
                insns.addAll(InsnsGenerator.this.generate(itree.rhs(), ResultContext.NON_TAIL));
                if (!InsnsGenerator.this.lvarAccGen.isUnused(itree.lvar())) {
                    insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(itree.lvar()));
                }
            }
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(DerefItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.owner(), ResultContext.NON_TAIL));
            insns.add(LOAD_CONTPARAM);
            String ownerVar = InsnsGenerator.this.keySup.newKeyStr("derefOwner");
            insns.add(new Insn.StoreNewLocal(ownerVar, Type.getType(Val.class)));
            insns.addAll(InsnsGenerator.this.deref(ownerVar, itree.sym(), itree.pos()));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(StoreItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.owner(), ResultContext.NON_TAIL));
            insns.add(LOAD_DATASTACK);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_PUSH_TO_DATASTACK);
            insns.addAll(InsnsGenerator.this.generate(itree.rhs(), ResultContext.NON_TAIL));
            insns.add(LOAD_DATASTACK);
            insns.add(new Insn.InvokeVirtual(DATASTACK_TYPE, new Method("pop", Type.getType(Val.class), new Type[0])));
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.InvokeDynamic(MethodType.methodType(Void.TYPE, Val.class, Val.class), BOOTSTRAP_SET_VAR_HANDLE, List.of(Integer.valueOf(InsnsGenerator.this.vm.sym.handleFor(itree.sym())))));
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(VarrefItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.owner(), ResultContext.NON_TAIL));
            insns.addAll(LOAD_VM);
            insns.add(new Insn.GetField(Type.getType(Vm.class), "varref", Type.getType(VarrefHelper.class)));
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.PushInt(InsnsGenerator.this.vm.sym.handleFor(itree.sym())));
            insns.add(new Insn.InvokeVirtual(Type.getType(VarrefHelper.class), new Method("of", Type.getType(VarrefVal.class), new Type[]{Type.getType(Val.class), Type.INT_TYPE})));
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(LetRecItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.letRecGen.letRec(itree, InsnsGenerator.this::generate));
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(SeqItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            itree.getLeadingSteps().stream().map(step -> InsnsGenerator.this.generate((Itree)step, ResultContext.NON_TAIL)).forEach(insns::addAll);
            insns.addAll(InsnsGenerator.this.generate(itree.getLastStep(), this.resultCtx));
            return insns;
        }

        private List<Insn> loadRhsVecWithSize(int callTrace, String rhsVec, String vecInternal, String size) {
            ArrayList<Insn> insns = new ArrayList<Insn>(20);
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.InstanceOf(Type.getType(VecVal.class)));
            String isVec = InsnsGenerator.this.keySup.newKeyStr("is-vec");
            insns.add(new Insn.IfNonZero(isVec));
            insns.addAll(InsnsGenerator.pushFakeCall(callTrace));
            insns.add(LOAD_STACKMACHINE);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_RAISE_NOT_VEC_RHS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(isVec));
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.CheckCast(Type.getType(VecVal.class)));
            insns.add(new Insn.StoreNewLocal(rhsVec, Type.getType(VecVal.class)));
            insns.add(new Insn.LoadLocal(rhsVec));
            insns.add(INVOKE_VEC_INTERNAL);
            insns.add(new Insn.StoreNewLocal(vecInternal, Type.getType(VecInternal.class)));
            insns.add(new Insn.LoadLocal(vecInternal));
            insns.add(INVOKE_VEC_INTERNAL_SIZE);
            insns.add(new Insn.StoreNewLocal(size, Type.INT_TYPE));
            return insns;
        }

        private List<Insn> passMandatoryArgs(List<LocalVar> lvars, String vecInternal) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            for (int mandatoryInd = 0; mandatoryInd < lvars.size(); ++mandatoryInd) {
                LocalVar lvar = lvars.get(mandatoryInd);
                if (InsnsGenerator.this.lvarAccGen.isUnused(lvar)) continue;
                insns.add(new Insn.LoadLocal(vecInternal));
                insns.add(new Insn.PushInt(mandatoryInd));
                insns.add(INVOKE_VEC_INTERNAL_GET);
                insns.add(STORE_CONTPARAM);
                insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(lvar));
            }
            return insns;
        }

        @Override
        public List<Insn> visit(OptVecAssignmentItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.rhs(), ResultContext.NON_TAIL));
            int callTrace = InsnsGenerator.this.traceAccum.add(this.makeCallTrace("op_store", itree.pos()));
            String rhsVec = InsnsGenerator.this.keySup.newKeyStr("rhsVec");
            String vecInternal = InsnsGenerator.this.keySup.newKeyStr("vecInternal");
            String size = InsnsGenerator.this.keySup.newKeyStr("size");
            insns.addAll(this.loadRhsVecWithSize(callTrace, rhsVec, vecInternal, size));
            insns.add(new Insn.LoadLocal(size));
            insns.add(new Insn.PushInt(itree.mandatory().size()));
            String wrongArity = InsnsGenerator.this.keySup.newKeyStr("wrong-arity");
            insns.add(new Insn.IfLtInt(wrongArity));
            insns.add(new Insn.LoadLocal(size));
            insns.add(new Insn.PushInt(itree.mandatory().size() + itree.opt().size()));
            insns.add(new Insn.IfGtInt(wrongArity));
            String validArity = InsnsGenerator.this.keySup.newKeyStr("valid-arity");
            insns.add(new Insn.GoTo(validArity));
            insns.add(new Insn.Mark(wrongArity));
            insns.addAll(InsnsGenerator.pushFakeCall(callTrace));
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.PushInt(itree.mandatory().size()));
            insns.add(new Insn.PushString(itree.lhsRepr()));
            insns.add(new Insn.LoadLocal(rhsVec));
            insns.add(INVOKE_RAISE_WRONG_NUMBER_OF_ARGS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(validArity));
            insns.addAll(this.passMandatoryArgs(itree.mandatory(), vecInternal));
            for (int optInd = 0; optInd < itree.opt().size(); ++optInd) {
                LocalVar lvar = itree.opt().get(optInd);
                int argInd = optInd + itree.mandatory().size();
                if (InsnsGenerator.this.lvarAccGen.isUnused(lvar)) continue;
                insns.add(new Insn.LoadLocal(size));
                insns.add(new Insn.PushInt(argInd));
                String optGiven = InsnsGenerator.this.keySup.newKeyStr("opt-given-" + argInd);
                insns.add(new Insn.IfGtInt(optGiven));
                insns.addAll(LOAD_VM);
                insns.add(LOAD_VEC_HELPER);
                insns.add(INVOKE_VEC_OF_EMPTY);
                String endifOpt = InsnsGenerator.this.keySup.newKeyStr("endif-opt-" + argInd);
                insns.add(new Insn.GoTo(endifOpt));
                insns.add(new Insn.Mark(optGiven));
                insns.addAll(LOAD_VM);
                insns.add(LOAD_VEC_HELPER);
                insns.add(new Insn.LoadLocal(vecInternal));
                insns.add(new Insn.PushInt(argInd));
                insns.add(INVOKE_VEC_INTERNAL_GET);
                insns.add(INVOKE_VEC_OF_SINGLE);
                insns.add(new Insn.Mark(endifOpt));
                insns.add(STORE_CONTPARAM);
                insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(lvar));
            }
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(OptRestVecAssignmentItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.rhs(), ResultContext.NON_TAIL));
            int callTrace = InsnsGenerator.this.traceAccum.add(this.makeCallTrace("op_store", itree.pos()));
            String rhsVec = InsnsGenerator.this.keySup.newKeyStr("rhsVec");
            String vecInternal = InsnsGenerator.this.keySup.newKeyStr("vecInternal");
            String size = InsnsGenerator.this.keySup.newKeyStr("size");
            insns.addAll(this.loadRhsVecWithSize(callTrace, rhsVec, vecInternal, size));
            insns.add(new Insn.LoadLocal(size));
            insns.add(new Insn.PushInt(itree.mandatory().size()));
            String validArity = InsnsGenerator.this.keySup.newKeyStr("valid-arity");
            insns.add(new Insn.IfGeInt(validArity));
            insns.addAll(InsnsGenerator.pushFakeCall(callTrace));
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.PushInt(itree.mandatory().size()));
            insns.add(new Insn.PushString(itree.lhsRepr()));
            insns.add(new Insn.LoadLocal(rhsVec));
            insns.add(INVOKE_RAISE_WRONG_NUMBER_OF_ARGS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(validArity));
            insns.addAll(this.passMandatoryArgs(itree.mandatory(), vecInternal));
            for (int optInd = 0; optInd < itree.opt().size(); ++optInd) {
                LocalVar lvar = itree.opt().get(optInd);
                int argInd = optInd + itree.mandatory().size();
                if (InsnsGenerator.this.lvarAccGen.isUnused(lvar)) continue;
                insns.add(new Insn.LoadLocal(size));
                insns.add(new Insn.PushInt(argInd));
                String optGiven = InsnsGenerator.this.keySup.newKeyStr("opt-given-" + argInd);
                insns.add(new Insn.IfGtInt(optGiven));
                insns.addAll(LOAD_VM);
                insns.add(LOAD_VEC_HELPER);
                insns.add(INVOKE_VEC_OF_EMPTY);
                String endifOpt = InsnsGenerator.this.keySup.newKeyStr("endif-opt-" + argInd);
                insns.add(new Insn.GoTo(endifOpt));
                insns.add(new Insn.Mark(optGiven));
                insns.addAll(LOAD_VM);
                insns.add(LOAD_VEC_HELPER);
                insns.add(new Insn.LoadLocal(vecInternal));
                insns.add(new Insn.PushInt(argInd));
                insns.add(INVOKE_VEC_INTERNAL_GET);
                insns.add(INVOKE_VEC_OF_SINGLE);
                insns.add(new Insn.Mark(endifOpt));
                insns.add(STORE_CONTPARAM);
                insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(lvar));
            }
            if (!InsnsGenerator.this.lvarAccGen.isUnused(itree.rest())) {
                insns.add(new Insn.LoadLocal(size));
                insns.add(new Insn.PushInt(itree.mandatory().size() + itree.opt().size()));
                String restGiven = InsnsGenerator.this.keySup.newKeyStr("rest-given");
                insns.add(new Insn.IfGtInt(restGiven));
                insns.addAll(LOAD_VM);
                insns.add(LOAD_VEC_HELPER);
                insns.add(INVOKE_VEC_OF_EMPTY);
                String endifRest = InsnsGenerator.this.keySup.newKeyStr("endif-rest");
                insns.add(new Insn.GoTo(endifRest));
                insns.add(new Insn.Mark(restGiven));
                insns.add(new Insn.NewInstance(Type.getType(VecVal.class)));
                insns.add(new Insn.Dup());
                insns.addAll(LOAD_VM);
                insns.add(new Insn.LoadLocal(vecInternal));
                insns.add(new Insn.PushInt(itree.mandatory().size() + itree.opt().size()));
                insns.add(new Insn.LoadLocal(size));
                insns.add(new Insn.InvokeVirtual(Type.getType(VecInternal.class), new Method("copyRange", Type.getType(VecInternal.class), new Type[]{Type.INT_TYPE, Type.INT_TYPE})));
                insns.add(INVOKE_VEC_CONSTRUCTOR);
                insns.add(new Insn.Mark(endifRest));
                insns.add(STORE_CONTPARAM);
                insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(itree.rest()));
            }
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(RestVecAssignmentItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.rhs(), ResultContext.NON_TAIL));
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.InstanceOf(Type.getType(VecVal.class)));
            String isVec = InsnsGenerator.this.keySup.newKeyStr("is-vec");
            insns.add(new Insn.IfNonZero(isVec));
            insns.addAll(InsnsGenerator.pushFakeCall(InsnsGenerator.this.traceAccum.add(this.makeCallTrace("op_store", itree.pos()))));
            insns.add(LOAD_STACKMACHINE);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_RAISE_NOT_VEC_RHS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(isVec));
            if (!InsnsGenerator.this.lvarAccGen.isUnused(itree.lvar())) {
                insns.add(new Insn.NewInstance(Type.getType(VecVal.class)));
                insns.add(new Insn.Dup());
                insns.addAll(LOAD_VM);
                insns.add(LOAD_CONTPARAM);
                insns.add(new Insn.CheckCast(Type.getType(VecVal.class)));
                insns.add(INVOKE_VEC_INTERNAL);
                insns.add(new Insn.InvokeVirtual(Type.getType(VecInternal.class), new Method("copy", Type.getType(VecInternal.class), new Type[0])));
                insns.add(INVOKE_VEC_CONSTRUCTOR);
                insns.add(STORE_CONTPARAM);
                insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(itree.lvar()));
            }
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(NestedVecAssignmentItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.rhs(), ResultContext.NON_TAIL));
            insns.add(LOAD_CONTPARAM);
            String rhs = InsnsGenerator.this.keySup.newKeyStr("rhs");
            insns.add(new Insn.StoreNewLocal(rhs, Type.getType(Val.class)));
            insns.add(new Insn.LoadLocal(rhs));
            insns.add(new Insn.InstanceOf(Type.getType(VecVal.class)));
            String isVecRhs = InsnsGenerator.this.keySup.newKeyStr("is-vec-rhs");
            insns.add(new Insn.IfNonZero(isVecRhs));
            int callTraceKey = InsnsGenerator.this.traceAccum.add(this.makeCallTrace("op_store", itree.pos()));
            insns.addAll(InsnsGenerator.pushFakeCall(callTraceKey));
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.LoadLocal(rhs));
            insns.add(INVOKE_RAISE_NOT_VEC_RHS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(isVecRhs));
            insns.add(new Insn.LoadLocal(rhs));
            insns.add(new Insn.CheckCast(Type.getType(VecVal.class)));
            String rhsVec = InsnsGenerator.this.keySup.newKeyStr("rhsVec");
            insns.add(new Insn.StoreNewLocal(rhsVec, Type.getType(VecVal.class)));
            insns.add(new Insn.LoadLocal(rhsVec));
            insns.add(INVOKE_VEC_INTERNAL);
            String rhsInternal = InsnsGenerator.this.keySup.newKeyStr("rhsInternal");
            insns.add(new Insn.StoreNewLocal(rhsInternal, Type.getType(VecInternal.class)));
            insns.add(new Insn.LoadLocal(rhsInternal));
            insns.add(INVOKE_VEC_INTERNAL_SIZE);
            insns.add(new Insn.PushInt(itree.params().size()));
            String rightSizedRhs = InsnsGenerator.this.keySup.newKeyStr("right-sized-rhs");
            insns.add(new Insn.IfEqInt(rightSizedRhs));
            insns.addAll(InsnsGenerator.pushFakeCall(callTraceKey));
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.PushInt(itree.params().size()));
            insns.add(new Insn.PushString(itree.lhsRepr()));
            insns.add(new Insn.LoadLocal(rhsVec));
            insns.add(INVOKE_RAISE_WRONG_NUMBER_OF_ARGS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(rightSizedRhs));
            for (int i = 0; i < itree.params().size(); ++i) {
                List<Insn> list;
                NestedParam param = itree.params().get(i);
                if (param instanceof LocalVar) {
                    LocalVar lvar = (LocalVar)param;
                    list = this.storeVecElem(lvar, rhsInternal, i);
                } else {
                    list = this.passTupleVecElem((NestedParam.Tuple)param, rhsInternal, i, callTraceKey);
                }
                insns.addAll(list);
            }
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        private List<Insn> storeVecElem(LocalVar lvar, String vecInternal, int i) {
            if (InsnsGenerator.this.lvarAccGen.isUnused(lvar)) {
                return List.of();
            }
            ArrayList<Insn> insns = new ArrayList<Insn>(10);
            insns.add(new Insn.LoadLocal(vecInternal));
            insns.add(new Insn.PushInt(i));
            insns.add(INVOKE_VEC_INTERNAL_GET);
            insns.add(STORE_CONTPARAM);
            insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(lvar));
            return insns;
        }

        private List<Insn> passTupleVecElem(NestedParam.Tuple tupleParam, String vecInternal, int i, int callTraceKey) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            insns.add(new Insn.LoadLocal(vecInternal));
            insns.add(new Insn.PushInt(i));
            insns.add(INVOKE_VEC_INTERNAL_GET);
            String tupleExpected = InsnsGenerator.this.keySup.newKeyStr("tupleExpected");
            insns.add(new Insn.StoreNewLocal(tupleExpected, Type.getType(Val.class)));
            insns.addAll(this.passTuple(tupleParam, tupleExpected, callTraceKey));
            return insns;
        }

        @Override
        public List<Insn> visit(VarrefVecAssignmentItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            itree.params().stream().filter(p -> p instanceof GenericVar).map(p -> (GenericVar)p).forEach(gvar -> {
                insns.addAll(InsnsGenerator.this.generate(gvar.owner(), ResultContext.NON_TAIL));
                insns.add(LOAD_DATASTACK);
                insns.add(LOAD_CONTPARAM);
                insns.add(INVOKE_PUSH_TO_DATASTACK);
            });
            insns.addAll(InsnsGenerator.this.generate(itree.rhs(), ResultContext.NON_TAIL));
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.InstanceOf(Type.getType(VecVal.class)));
            String isVec = InsnsGenerator.this.keySup.newKeyStr("is-vec");
            insns.add(new Insn.IfNonZero(isVec));
            int callTraceKey = InsnsGenerator.this.traceAccum.add(this.makeCallTrace("op_store", itree.pos()));
            insns.addAll(InsnsGenerator.pushFakeCall(callTraceKey));
            insns.add(LOAD_STACKMACHINE);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_RAISE_NOT_VEC_RHS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(isVec));
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.CheckCast(Type.getType(VecVal.class)));
            String rhsVec = InsnsGenerator.this.keySup.newKeyStr("rhsVec");
            insns.add(new Insn.StoreNewLocal(rhsVec, Type.getType(VecVal.class)));
            insns.add(new Insn.LoadLocal(rhsVec));
            insns.add(INVOKE_VEC_INTERNAL);
            String vecInternal = InsnsGenerator.this.keySup.newKeyStr("vecInternal");
            insns.add(new Insn.StoreNewLocal(vecInternal, Type.getType(VecInternal.class)));
            insns.add(new Insn.LoadLocal(vecInternal));
            insns.add(INVOKE_VEC_INTERNAL_SIZE);
            insns.add(new Insn.PushInt(itree.params().size()));
            String valid = InsnsGenerator.this.keySup.newKeyStr("valid");
            insns.add(new Insn.IfEqInt(valid));
            insns.addAll(InsnsGenerator.pushFakeCall(callTraceKey));
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.PushInt(itree.params().size()));
            insns.add(new Insn.PushString(itree.lhsRepr()));
            insns.add(new Insn.LoadLocal(rhsVec));
            insns.add(INVOKE_RAISE_WRONG_NUMBER_OF_ARGS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(valid));
            insns.add(LOAD_DATASTACK);
            insns.add(INVOKE_TOP_OFFSET);
            String topOffset = InsnsGenerator.this.keySup.newKeyStr("topOffset");
            insns.add(new Insn.StoreNewLocal(topOffset, Type.INT_TYPE));
            int gvarCount = (int)itree.params().stream().filter(p -> p instanceof GenericVar).count();
            int storedGvars = 0;
            for (int i = 0; i < itree.params().size(); ++i) {
                VarrefParam param = itree.params().get(i);
                if (param instanceof GenericVar) {
                    GenericVar gvar2 = (GenericVar)param;
                    insns.add(LOAD_DATASTACK);
                    insns.add(new Insn.LoadLocal(topOffset));
                    insns.add(new Insn.PushInt(gvarCount - storedGvars));
                    insns.add(new Insn.SubInt());
                    insns.add(INVOKE_AT_OFFSET);
                    insns.add(new Insn.LoadLocal(vecInternal));
                    insns.add(new Insn.PushInt(i));
                    insns.add(INVOKE_VEC_INTERNAL_GET);
                    insns.add(new Insn.InvokeDynamic(MethodType.methodType(Void.TYPE, Val.class, Val.class), BOOTSTRAP_SET_VAR_HANDLE, List.of(Integer.valueOf(InsnsGenerator.this.vm.sym.handleFor(gvar2.name())))));
                    ++storedGvars;
                    continue;
                }
                LocalVar lvar = (LocalVar)param;
                if (InsnsGenerator.this.lvarAccGen.isUnused(lvar)) continue;
                insns.add(new Insn.LoadLocal(vecInternal));
                insns.add(new Insn.PushInt(i));
                insns.add(INVOKE_VEC_INTERNAL_GET);
                insns.add(STORE_CONTPARAM);
                insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(lvar));
            }
            insns.add(LOAD_DATASTACK);
            insns.add(new Insn.LoadLocal(topOffset));
            insns.add(new Insn.PushInt(gvarCount));
            insns.add(new Insn.SubInt());
            insns.add(INVOKE_REMOVE_FROM_OFFSET);
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(ArgsPassingItree itree) {
            String validCount = InsnsGenerator.this.keySup.newKeyStr("args-passing-valid-count");
            int paramCount = itree.lvars().size();
            ArrayList<Insn> insns = new ArrayList<Insn>(List.of(LOAD_ARGCOUNT, new Insn.PushInt(paramCount), new Insn.IfEqInt(validCount)));
            insns.addAll(InsnsGenerator.pushFakeCall(InsnsGenerator.this.traceAccum.add(this.makeCallTrace("op_store", itree.pos()))));
            insns.addAll(List.of(LOAD_STACKMACHINE, new Insn.PushInt(paramCount), new Insn.PushString(itree.lhsRepr()), LOAD_DATASTACK, LOAD_ARGCOUNT, INVOKE_ARG_VEC, INVOKE_RAISE_WRONG_NUMBER_OF_ARGS, new Insn.ReturnValue(), new Insn.Mark(validCount)));
            for (int i = 0; i < itree.lvars().size(); ++i) {
                LocalVar lvar = itree.lvars().get(i);
                insns.addAll(InsnsGenerator.this.lvarAccGen.passArg(lvar, i));
            }
            insns.add((Insn.IfEqInt)PRODUCE_NADA);
            insns.add((Insn.IfEqInt)STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(NestedArgsPassingItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            insns.add(LOAD_ARGCOUNT);
            insns.add(new Insn.PushInt(itree.params().size()));
            String validCount = InsnsGenerator.this.keySup.newKeyStr("valid-count");
            insns.add(new Insn.IfEqInt(validCount));
            int callTraceKey = InsnsGenerator.this.traceAccum.add(this.makeCallTrace("op_store", itree.pos()));
            insns.addAll(InsnsGenerator.pushFakeCall(callTraceKey));
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.PushInt(itree.params().size()));
            insns.add(new Insn.PushString(itree.lhsRepr()));
            insns.add(LOAD_DATASTACK);
            insns.add(LOAD_ARGCOUNT);
            insns.add(INVOKE_ARG_VEC);
            insns.add(INVOKE_RAISE_WRONG_NUMBER_OF_ARGS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(validCount));
            for (int i = 0; i < itree.params().size(); ++i) {
                List<Insn> list;
                NestedParam param = itree.params().get(i);
                if (param instanceof LocalVar) {
                    LocalVar lvar = (LocalVar)param;
                    list = InsnsGenerator.this.lvarAccGen.passArg(lvar, i);
                } else {
                    list = this.passTupleArg((NestedParam.Tuple)param, i, callTraceKey);
                }
                insns.addAll(list);
            }
            insns.add(PRODUCE_NADA);
            insns.add(STORE_CONTPARAM);
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        private List<Insn> passTupleArg(NestedParam.Tuple param, int argInd, int outerTraceKey) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            insns.add(LOAD_DATASTACK);
            insns.add(new Insn.PushInt(argInd));
            insns.add(INVOKE_ARG);
            String tupleExpected = InsnsGenerator.this.keySup.newKeyStr("tupleExpected");
            insns.add(new Insn.StoreNewLocal(tupleExpected, Type.getType(Val.class)));
            insns.addAll(this.passTuple(param, tupleExpected, outerTraceKey));
            return insns;
        }

        private List<Insn> passTuple(NestedParam.Tuple param, String tupleExpected, int outerTraceKey) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            insns.add(new Insn.LoadLocal(tupleExpected));
            insns.add(new Insn.InstanceOf(Type.getType(VecVal.class)));
            String isTuple = InsnsGenerator.this.keySup.newKeyStr("is-tuple");
            insns.add(new Insn.IfNonZero(isTuple));
            insns.addAll(InsnsGenerator.pushFakeCall(outerTraceKey));
            int innerTraceKey = InsnsGenerator.this.traceAccum.add(Trace.of(InsnsGenerator.this.vm.sym.handleFor("op_store")));
            insns.addAll(InsnsGenerator.pushFakeCall(innerTraceKey));
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.LoadLocal(tupleExpected));
            insns.add(INVOKE_RAISE_NOT_VEC_RHS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(isTuple));
            insns.add(new Insn.LoadLocal(tupleExpected));
            insns.add(new Insn.CheckCast(Type.getType(VecVal.class)));
            String tuple = InsnsGenerator.this.keySup.newKeyStr("tuple");
            insns.add(new Insn.StoreNewLocal(tuple, Type.getType(VecVal.class)));
            insns.add(new Insn.LoadLocal(tuple));
            insns.add(INVOKE_VEC_INTERNAL);
            String vecInternal = InsnsGenerator.this.keySup.newKeyStr("vecInternal");
            insns.add(new Insn.StoreNewLocal(vecInternal, Type.getType(VecInternal.class)));
            insns.add(new Insn.LoadLocal(vecInternal));
            insns.add(INVOKE_VEC_INTERNAL_SIZE);
            insns.add(new Insn.PushInt(param.lvars().size()));
            String rightSizedTuple = InsnsGenerator.this.keySup.newKeyStr("right-sized-tuple");
            insns.add(new Insn.IfEqInt(rightSizedTuple));
            insns.addAll(InsnsGenerator.pushFakeCall(outerTraceKey));
            insns.addAll(InsnsGenerator.pushFakeCall(innerTraceKey));
            insns.add(LOAD_STACKMACHINE);
            insns.add(new Insn.PushInt(param.lvars().size()));
            insns.add(new Insn.PushString(param.lhsRepr()));
            insns.add(new Insn.LoadLocal(tuple));
            insns.add(INVOKE_RAISE_WRONG_NUMBER_OF_ARGS);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(rightSizedTuple));
            for (int i = 0; i < param.lvars().size(); ++i) {
                LocalVar lvar = param.lvars().get(i);
                if (InsnsGenerator.this.lvarAccGen.isUnused(lvar)) continue;
                insns.add(new Insn.LoadLocal(vecInternal));
                insns.add(new Insn.PushInt(i));
                insns.add(INVOKE_VEC_INTERNAL_GET);
                insns.add(STORE_CONTPARAM);
                insns.addAll(InsnsGenerator.this.lvarAccGen.storeLvar(lvar));
            }
            return insns;
        }

        @Override
        public List<Insn> visit(VecItree itree) {
            List<ItreeElem> elems = itree.elems();
            ArrayList<Insn> insns = new ArrayList<Insn>(elems.isEmpty() ? MAKE_EMPTY_VEC : (InsnsGenerator.this.isSingleton(elems) ? InsnsGenerator.this.makeSingletonVec((Itree)elems.get(0)) : InsnsGenerator.this.makeVecOnDataStack(elems)));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        private List<Insn> checkFun(String sym, int pos) {
            ArrayList<Insn> insns = new ArrayList<Insn>();
            String isFun = InsnsGenerator.this.keySup.newKeyStr("is-fun");
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.InstanceOf(Type.getType(FunVal.class)));
            insns.add(new Insn.IfNonZero(isFun));
            insns.add(LOAD_STACKMACHINE);
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.PushString(sym));
            insns.add(InsnsGenerator.this.produceTrace(Trace.of(new Location(InsnsGenerator.this.programName, InsnsGenerator.this.programText, pos))));
            insns.add(INVOKE_RAISE_NOT_FUN);
            insns.add(new Insn.ReturnValue());
            insns.add(new Insn.Mark(isFun));
            return insns;
        }

        @Override
        public List<Insn> visit(McallItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.ownerRecv(), ResultContext.NON_TAIL));
            insns.add(LOAD_CONTPARAM);
            String recv = InsnsGenerator.this.keySup.newKeyStr("recv");
            insns.add(new Insn.StoreNewLocal(recv, Type.getType(Val.class)));
            insns.addAll(InsnsGenerator.this.deref(recv, itree.sym(), itree.pos()));
            insns.addAll(this.checkFun(itree.sym(), itree.pos()));
            insns.add(LOAD_DATASTACK);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_PUSH_TO_DATASTACK);
            insns.add(LOAD_DATASTACK);
            insns.add(new Insn.LoadLocal(recv));
            insns.add(INVOKE_PUSH_TO_DATASTACK);
            Trace trace = this.makeCallTrace(itree.sym(), itree.pos());
            insns.addAll(this.pushArgsAndCall(itree.args(), trace, List.of()));
            return insns;
        }

        @Override
        public List<Insn> visit(SymcallItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.fun(), ResultContext.NON_TAIL));
            insns.addAll(this.checkFun(itree.sym(), itree.pos()));
            insns.add(LOAD_DATASTACK);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_PUSH_TO_DATASTACK);
            insns.addAll(InsnsGenerator.this.generate(itree.recv(), ResultContext.NON_TAIL));
            insns.add(LOAD_DATASTACK);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_PUSH_TO_DATASTACK);
            Trace trace = this.makeCallTrace(itree.sym(), itree.pos());
            insns.addAll(this.pushArgsAndCall(itree.args(), trace, List.of()));
            return insns;
        }

        @Override
        public List<Insn> visit(AssignmentItree itree) {
            McallItree mcall = new McallItree(itree.lhs(), "op_store", List.of(itree.rhs()), itree.pos());
            return InsnsGenerator.this.generate(mcall, this.resultCtx);
        }

        @Override
        public List<Insn> visit(BiArithmeticItree itree) {
            ArrayList<Insn> insns = new ArrayList<Insn>(InsnsGenerator.this.generate(itree.recv(), ResultContext.NON_TAIL));
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.InvokeStatic(Type.getType(NumVal.class), new Method("isPlainNum", Type.BOOLEAN_TYPE, new Type[]{Type.getType(Val.class)})));
            String plainNum = InsnsGenerator.this.keySup.newKeyStr("plain-num");
            insns.add(new Insn.IfNonZero(plainNum));
            String leftOperand = InsnsGenerator.this.keySup.newKeyStr("leftOperand");
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.StoreNewLocal(leftOperand, Type.getType(Val.class)));
            MethodNames mnames = BI_ARITHMETIC_MAP.get((Object)itree.op());
            insns.addAll(InsnsGenerator.this.deref(leftOperand, mnames.kinkMethod(), itree.pos()));
            insns.addAll(this.checkFun(mnames.kinkMethod(), itree.pos()));
            insns.add(LOAD_DATASTACK);
            insns.add(LOAD_CONTPARAM);
            insns.add(INVOKE_PUSH_TO_DATASTACK);
            insns.add(LOAD_DATASTACK);
            insns.add(new Insn.LoadLocal(leftOperand));
            insns.add(INVOKE_PUSH_TO_DATASTACK);
            insns.add(LOAD_DATASTACK);
            insns.add(new Insn.InvokeDynamic(MethodType.methodType(Val.class), BOOTSTRAP_NUM_HANDLE, List.of(itree.arg().toString())));
            insns.add(INVOKE_PUSH_TO_DATASTACK);
            String one = InsnsGenerator.this.keySup.newKeyStr("one");
            insns.add(new Insn.PushInt(1));
            insns.add(new Insn.StoreNewLocal(one, Type.INT_TYPE));
            Trace trace = this.makeCallTrace(mnames.kinkMethod(), itree.pos());
            String afterArithmetic = InsnsGenerator.this.keySup.newKeyStr("after-arithmetic");
            insns.addAll(this.doCall(trace, List.of(new Insn.GoTo(afterArithmetic)), one));
            insns.add(new Insn.Mark(plainNum));
            insns.addAll(LOAD_VM);
            insns.add(new Insn.GetField(Type.getType(Vm.class), "num", Type.getType(NumHelper.class)));
            insns.add(LOAD_CONTPARAM);
            insns.add(new Insn.CheckCast(Type.getType(NumVal.class)));
            insns.add(new Insn.InvokeVirtual(Type.getType(NumVal.class), new Method("bigDecimal", Type.getType(BigDecimal.class), new Type[0])));
            insns.add(new Insn.InvokeDynamic(MethodType.methodType(BigDecimal.class), BOOTSTRAP_BIGDECIMAL_HANDLE, List.of(itree.arg().toString())));
            insns.add(new Insn.InvokeVirtual(Type.getType(BigDecimal.class), new Method(mnames.javaMethod(), Type.getType(BigDecimal.class), new Type[]{Type.getType(BigDecimal.class)})));
            insns.add(new Insn.InvokeVirtual(Type.getType(NumHelper.class), new Method("of", Type.getType(NumVal.class), new Type[]{Type.getType(BigDecimal.class)})));
            insns.add(STORE_CONTPARAM);
            insns.add(new Insn.Mark(afterArithmetic));
            insns.addAll(this.resultCtx.returnOnTail());
            return insns;
        }

        @Override
        public List<Insn> visit(IfItree itree) {
            return InsnsGenerator.this.controlGen.preloadedIf(itree, InsnsGenerator.this::generate, this.resultCtx);
        }

        @Override
        public List<Insn> visit(BranchItree itree) {
            return InsnsGenerator.this.controlGen.branch(itree, InsnsGenerator.this::generate, this.resultCtx);
        }

        @Override
        public List<Insn> visit(BranchWithElseItree itree) {
            return InsnsGenerator.this.controlGen.branchWithElse(itree, InsnsGenerator.this::generate, this.resultCtx);
        }

        @Override
        public List<Insn> visit(TraitNewValItree itree) {
            return InsnsGenerator.this.controlGen.traitNewVal(itree, InsnsGenerator.this::generate, this.resultCtx);
        }

        @Override
        public List<Insn> visit(NoTraitNewValItree itree) {
            return InsnsGenerator.this.controlGen.noTraitNewVal(itree, InsnsGenerator.this::generate, this.resultCtx);
        }

        private record MethodNames(String kinkMethod, String javaMethod) {
        }
    }
}

