/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.mod.random;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import javax.annotation.Nullable;
import org.kink_lang.kink.BinVal;
import org.kink_lang.kink.NumVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;

final class RandomNumbers {
    RandomNumbers() {
        throw new UnsupportedOperationException("should not be instantiated");
    }

    @Nullable
    static NumVal produceIntNum(Vm vm, Random rng, Val upperBound) {
        if (!(upperBound instanceof NumVal)) {
            return null;
        }
        BigDecimal upperBoundDec = ((NumVal)upperBound).bigDecimal();
        if (upperBoundDec.scale() != 0 || upperBoundDec.signum() <= 0) {
            return null;
        }
        long upperBoundLong = RandomNumbers.extractLong(upperBoundDec);
        return upperBoundLong >= 2L ? RandomNumbers.genLongRandom(vm, rng, upperBoundLong) : RandomNumbers.genBigRandom(vm, rng, upperBoundDec.toBigInteger());
    }

    private static long extractLong(BigDecimal dec) {
        try {
            return dec.longValueExact();
        }
        catch (ArithmeticException ex) {
            return -1L;
        }
    }

    private static NumVal genLongRandom(Vm vm, Random rng, long upperBound) {
        long candidate;
        long max = upperBound - 1L;
        long mask = (Long.highestOneBit(max) << 1) - 1L;
        int leadingZeroBits = Long.numberOfLeadingZeros(max);
        int rightShift = leadingZeroBits / 8 * 8;
        while ((candidate = rng.nextLong() >>> rightShift & mask) > max) {
        }
        return vm.num.of(candidate);
    }

    private static NumVal genBigRandom(Vm vm, Random rng, BigInteger upperBound) {
        BigInteger candidate;
        BigInteger max = upperBound.subtract(BigInteger.ONE);
        int numBits = max.bitLength();
        while ((candidate = new BigInteger(numBits, rng)).compareTo(max) > 0) {
        }
        return vm.num.of(candidate);
    }

    static BinVal produceBin(Vm vm, Random rng, Val size) {
        if (!(size instanceof NumVal)) {
            return null;
        }
        BigDecimal sizeDec = ((NumVal)size).bigDecimal();
        if (sizeDec.scale() != 0 || sizeDec.signum() < 0) {
            return null;
        }
        int sizeInt = RandomNumbers.extractInt(sizeDec);
        if (sizeInt < 0) {
            return null;
        }
        byte[] bytes = new byte[sizeInt];
        rng.nextBytes(bytes);
        return vm.bin.of(bytes);
    }

    private static int extractInt(BigDecimal dec) {
        try {
            return dec.intValueExact();
        }
        catch (ArithmeticException ex) {
            return -1;
        }
    }
}

