/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.internal.program.itreeoptimize;

import org.kink_lang.kink.internal.contract.Preconds;
import org.kink_lang.kink.internal.program.itree.BindingItree;
import org.kink_lang.kink.internal.program.itree.Itree;
import org.kink_lang.kink.internal.program.itree.ItreeElem;
import org.kink_lang.kink.internal.program.itree.McallItree;
import org.kink_lang.kink.internal.program.itree.VarrefItree;

final class Params {
    Params() {
        throw new UnsupportedOperationException("should not be instantiated");
    }

    static boolean isMandatoryParam(ItreeElem elem) {
        return elem.isSingle() && Params.isLocalVarref(elem.expr());
    }

    static String getMandatoryParamSym(ItreeElem elem) {
        Preconds.checkArg(Params.isMandatoryParam(elem), "elem must be a mandatory param");
        VarrefItree varref = (VarrefItree)elem.expr();
        return varref.sym();
    }

    static boolean isOptParam(ItreeElem elem) {
        if (!elem.isSingle()) {
            return false;
        }
        Itree itree = elem.expr();
        if (!(itree instanceof McallItree)) {
            return false;
        }
        McallItree mcall = (McallItree)itree;
        return Params.isLocalVarref(mcall.ownerRecv()) && mcall.sym().equals("opt") && mcall.args().isEmpty();
    }

    static String getOptParamSym(ItreeElem elem) {
        Preconds.checkArg(Params.isOptParam(elem), "elem must be an opt param");
        McallItree mcall = (McallItree)elem.expr();
        VarrefItree varref = (VarrefItree)mcall.ownerRecv();
        return varref.sym();
    }

    static boolean isRestParam(ItreeElem elem) {
        if (!elem.isSingle()) {
            return false;
        }
        Itree itree = elem.expr();
        if (!(itree instanceof McallItree)) {
            return false;
        }
        McallItree mcall = (McallItree)itree;
        return Params.isLocalVarref(mcall.ownerRecv()) && mcall.sym().equals("rest") && mcall.args().isEmpty();
    }

    static String getRestParamSym(ItreeElem elem) {
        Preconds.checkArg(Params.isRestParam(elem), "elem must be a rest param");
        McallItree mcall = (McallItree)elem.expr();
        VarrefItree varref = (VarrefItree)mcall.ownerRecv();
        return varref.sym();
    }

    private static boolean isLocalVarref(Itree itree) {
        return itree instanceof VarrefItree && ((VarrefItree)itree).owner() instanceof BindingItree;
    }
}

