/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.List;
import java.util.Random;
import org.kink_lang.kink.BinVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.JavaVal;
import org.kink_lang.kink.StrVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.mod.random.PrngVal;
import org.kink_lang.kink.internal.mod.random.RngVal;
import org.kink_lang.kink.internal.mod.random.Xoshiro256StarStar;
import org.kink_lang.kink.internal.str.Decoder;
import org.kink_lang.kink.internal.str.Encoder;

class InternalMod {
    private final Vm vm;
    private final int fromEachHandle;

    InternalMod(Vm vm) {
        this.vm = vm;
        this.fromEachHandle = vm.sym.handleFor("from_each");
    }

    Val makeMod() {
        Val mod = this.vm.newVal();
        mod.setVar(this.vm.sym.handleFor("new_prng"), this.vm.fun.make("_INTERNAL.new_prng(S0 S1 S2 S3)").take(4).action(this::newPrngFun));
        mod.setVar(this.vm.sym.handleFor("prng?"), this.vm.fun.make("_INTERNAL.prng?(Val)").take(1).action(this::isPrngFun));
        mod.setVar(this.vm.sym.handleFor("new_rng"), this.vm.fun.make("_INTERNAL.new_rng?(Random Type_tag)").take(2).action(this::newRngFun));
        mod.setVar(this.vm.sym.handleFor("new_encoder_pair"), this.vm.fun.make("_INTERNAL.new_encoder_pair(Cs_encoder)").take(1).action(this::newEncoderPair));
        mod.setVar(this.vm.sym.handleFor("new_decoder_triple"), this.vm.fun.make("_INTERNAL.new_decoder_triple(Charset)").take(1).action(this::newDecoderTriple));
        mod.setVar(this.vm.sym.handleFor("val_id"), this.vm.fun.make("VAL.val_id(Val)").take(1).action(c -> this.vm.num.of(c.arg(0).identityDecimal())));
        mod.setVar(this.vm.sym.handleFor("var_syms"), this.vm.fun.make("VAL.var_syms(Val)").take(1).action(this::varSyms));
        mod.setVar(this.vm.sym.handleFor("current_traces"), this.vm.fun.make("TRACE.current_traces").take(0).action(c -> this.vm.vec.of(c.traces())));
        mod.setVar(this.vm.sym.handleFor("require"), this.vm.fun.make("MOD.require(Mod_name ...[$config])").takeMinMax(1, 2).action(this::requireFun));
        return mod;
    }

    private HostResult newPrngFun(CallContext c) {
        long s0 = (Long)((JavaVal)c.arg(0)).objectReference();
        long s1 = (Long)((JavaVal)c.arg(1)).objectReference();
        long s2 = (Long)((JavaVal)c.arg(2)).objectReference();
        long s3 = (Long)((JavaVal)c.arg(3)).objectReference();
        Xoshiro256StarStar random = new Xoshiro256StarStar(s0, s1, s2, s3);
        return PrngVal.of(this.vm, random);
    }

    private HostResult isPrngFun(CallContext c) {
        return this.vm.bool.of(c.arg(0) instanceof PrngVal);
    }

    private HostResult newRngFun(CallContext c) {
        Random random = (Random)((JavaVal)c.arg(0)).objectReference();
        String typeTag = ((StrVal)c.arg(1)).string();
        return RngVal.of(this.vm, random, typeTag);
    }

    private HostResult newEncoderPair(CallContext c) {
        CharsetEncoder csEncoder = (CharsetEncoder)((JavaVal)c.arg(0)).objectReference();
        Encoder encoder = Encoder.of(csEncoder);
        FunVal encode = this.vm.fun.make().take(1).action(cc -> {
            String str = ((StrVal)cc.arg(0)).string();
            return this.vm.bin.of(encoder.encode(str));
        });
        FunVal terminate = this.vm.fun.make().take(0).action(cc -> this.vm.bin.of(encoder.terminate()));
        return this.vm.vec.of((Val)encode, (Val)terminate);
    }

    private HostResult newDecoderTriple(CallContext c) {
        Charset charset = (Charset)((JavaVal)c.arg(0)).objectReference();
        Decoder decoder = Decoder.of(charset);
        FunVal consume = this.vm.fun.make().take(1).action(cc -> {
            BinVal bin = (BinVal)cc.arg(0);
            decoder.consume(bin.bytes());
            return this.vm.nada;
        });
        FunVal terminate = this.vm.fun.make().take(0).action(cc -> {
            decoder.terminate();
            return this.vm.nada;
        });
        FunVal emitText = this.vm.fun.make().take(0).action(cc -> this.vm.str.of(decoder.emitText()));
        return this.vm.vec.of((Val)consume, (Val)terminate, (Val)emitText);
    }

    private HostResult varSyms(CallContext c) {
        Val val = c.arg(0);
        List<StrVal> syms = val.getVarSymHandleSet().stream().map(handle -> this.vm.str.of(this.vm.sym.symFor((int)handle))).toList();
        return c.call("kink/container/FLAT_SET", this.fromEachHandle).args((Val)this.vm.vec.of(syms));
    }

    private HostResult requireFun(CallContext c) throws Throwable {
        Val modNameVal = c.arg(0);
        if (!(modNameVal instanceof StrVal)) {
            return c.call(this.vm.graph.raiseFormat("require(Mod_name ...[$config]): Mod_name must be a str, but got {}", this.vm.graph.repr(modNameVal)));
        }
        String modName = ((StrVal)modNameVal).string();
        if (c.argCount() == 1) {
            return this.vm.mod.require(c, modName, null, null, null);
        }
        Val config = c.arg(1);
        FunVal cont = this.vm.fun.make().take(3).action(cc -> this.requireWithConts(cc, modName, cc.arg(0), cc.arg(1), cc.arg(2)));
        int readConf = this.vm.sym.handleFor("read_conf");
        return c.call("kink/_mod/REQUIRE_AUX", readConf).args(modNameVal, config, (Val)cont);
    }

    HostResult requireWithConts(HostContext c, String modName, Val successCont, Val notFoundCont, Val compileErrorCont) throws Throwable {
        if (!(successCont instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("require(Mod_name ...[$config]): success cont is not a fun but {}", this.vm.graph.repr(successCont)));
        }
        if (!(notFoundCont instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("require(Mod_name ...[$config]): not found cont is not a fun but {}", this.vm.graph.repr(notFoundCont)));
        }
        if (!(compileErrorCont instanceof FunVal)) {
            return c.call(this.vm.graph.raiseFormat("require(Mod_name ...[$config]): compile error cont is not a fun but {}", this.vm.graph.repr(compileErrorCont)));
        }
        return this.vm.mod.require(c, modName, (FunVal)successCont, (FunVal)notFoundCont, (FunVal)compileErrorCont);
    }
}

