/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.internal.contract.Preconds;

public class SharedVars {
    private final long[] bucketRanges;
    private final int[] symHandles;
    private final Val[] vals;
    private final long uniqueId;
    private static final AtomicLong UNIQUE_ID_GENERATOR = new AtomicLong(0L);

    private SharedVars(long[] bucketRanges, int[] symHandles, Val[] vals, long uniqueId) {
        this.bucketRanges = bucketRanges;
        this.symHandles = symHandles;
        this.vals = vals;
        this.uniqueId = uniqueId;
    }

    static SharedVars of(Map<Integer, Val> map) {
        Preconds.checkArg(!map.isEmpty(), "map must not be empty");
        return SharedVars.build(map, map.size());
    }

    private static SharedVars build(Map<Integer, Val> map, int bucketCount) {
        int[] symHandles = SharedVars.makeSymHandles(map.keySet(), bucketCount);
        Val[] vals = SharedVars.makeVals(map, symHandles);
        long[] bucketRanges = SharedVars.makeBucketRanges(symHandles, bucketCount);
        long uniqueId = UNIQUE_ID_GENERATOR.getAndIncrement();
        return new SharedVars(bucketRanges, symHandles, vals, uniqueId);
    }

    private static int[] makeSymHandles(Set<Integer> symHandleSet, int bucketCount) {
        Comparator compare = (x, y) -> {
            int yHash;
            int xHash = SharedVars.hash(x, bucketCount);
            return xHash == (yHash = SharedVars.hash(y, bucketCount)) ? Integer.compare(x, y) : Integer.compare(xHash, yHash);
        };
        return symHandleSet.stream().sorted(compare).mapToInt(i -> i).toArray();
    }

    private static Val[] makeVals(Map<Integer, Val> map, int[] symHandles) {
        Val[] vals = new Val[symHandles.length];
        Arrays.setAll(vals, i -> (Val)map.get(symHandles[i]));
        return vals;
    }

    private static long[] makeBucketRanges(int[] symHandles, int bucketCount) {
        long[] bucketRanges = new long[bucketCount];
        int prevHash = -1;
        int prevFrom = -1;
        for (int i = 0; i < symHandles.length; ++i) {
            int hash = SharedVars.hash(symHandles[i], bucketCount);
            int from = hash == prevHash ? prevFrom : i;
            int to = i + 1;
            bucketRanges[hash] = SharedVars.makeRange(from, to);
            prevHash = hash;
            prevFrom = from;
        }
        return bucketRanges;
    }

    private static long makeRange(int from, int to) {
        return (long)from << 32 | (long)to;
    }

    private static int extractFromIndex(long range) {
        return (int)(range >>> 32);
    }

    private static int extractToIndex(long range) {
        return (int)range;
    }

    long getUniqueId() {
        return this.uniqueId;
    }

    int getIndex(int symHandle) {
        long range = this.bucketRanges[this.hash(symHandle)];
        int from = SharedVars.extractFromIndex(range);
        int to = SharedVars.extractToIndex(range);
        return Arrays.binarySearch(this.symHandles, from, to, symHandle);
    }

    private int hash(int symHandle) {
        return SharedVars.hash(symHandle, this.bucketRanges.length);
    }

    private static int hash(int symHandle, int bucketCount) {
        return Integer.remainderUnsigned(symHandle, bucketCount);
    }

    @Nullable
    Val get(int symHandle) {
        int index = this.getIndex(symHandle);
        return index < 0 ? null : this.getAtIndex(index);
    }

    Val getAtIndex(int index) {
        return this.vals[index];
    }

    boolean has(int symHandle) {
        return this.getIndex(symHandle) >= 0;
    }

    Set<Integer> symHandleSet() {
        return Arrays.stream(this.symHandles).mapToObj(i -> i).collect(Collectors.toUnmodifiableSet());
    }
}

