/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.kink_lang.kink.LocationVal;
import org.kink_lang.kink.SharedVars;
import org.kink_lang.kink.TraceVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.CallContext;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.internal.function.ThrowingFunction2;

public final class TraceHelper {
    private final Vm vm;
    private TraceVal snip;
    private TraceVal empty;
    SharedVars sharedVars;

    TraceHelper(Vm vm) {
        this.vm = vm;
    }

    public TraceVal of(String sym) {
        return new TraceVal(this.vm, sym, this.vm.location.of("", "", 0), false);
    }

    public TraceVal of(LocationVal loc) {
        return new TraceVal(this.vm, "", loc, false);
    }

    public TraceVal of(String sym, LocationVal loc) {
        return new TraceVal(this.vm, sym, loc, false);
    }

    public TraceVal snip() {
        return this.snip;
    }

    public TraceVal empty() {
        return this.empty;
    }

    void init() {
        this.snip = new TraceVal(this.vm, "", this.vm.location.of("", "", 0), true);
        this.empty = new TraceVal(this.vm, "", this.vm.location.of("", "", 0), false);
        HashMap<Integer, Val> vars = new HashMap<Integer, Val>();
        this.addUnaryOp(vars, "Trace", "snip?", (c, t) -> this.vm.bool.of(t.isSnip()));
        this.addUnaryOp(vars, "Trace", "sym", this::symMethod);
        this.addUnaryOp(vars, "Trace", "location", this::locationMethod);
        this.addUnaryOp(vars, "Trace", "tail?", (c, trace) -> this.vm.bool.of(trace.isTail()));
        this.addUnaryOp(vars, "Trace", "on_tail", this::onTailMethod);
        vars.put(this.vm.sym.handleFor("op_eq"), this.vm.fun.make("Trace.op_eq").take(1).action(c -> this.vm.bool.of(c.recv().equals(c.arg(0)))));
        this.addUnaryOp(vars, "Trace", "repr", this::reprMethod);
        this.addUnaryOp(vars, "Trace", "desc", (c, trace) -> this.vm.str.of(trace.desc()));
        this.sharedVars = this.vm.sharedVars.of(vars);
    }

    private HostResult symMethod(HostContext c, TraceVal trace) {
        return trace.emptySym() ? this.vm.str.of("") : this.vm.str.of(trace.sym());
    }

    private HostResult locationMethod(HostContext c, TraceVal trace) {
        return trace.emptyLoc() ? this.vm.location.of("", "", 0) : trace.location();
    }

    private HostResult onTailMethod(HostContext c, TraceVal trace) {
        return trace.onTail();
    }

    private HostResult reprMethod(HostContext c, TraceVal trace) {
        return c.call(this.vm.graph.format("(trace sym={} {} tail?={})", this.vm.graph.of(this.vm.str.of(trace.sym())), this.vm.graph.repr(trace.location()), this.vm.graph.of(this.vm.str.of(Boolean.toString(trace.isTail())))));
    }

    private void addUnaryOp(Map<Integer, Val> vars, String recvDesc, String name, ThrowingFunction2<CallContext, TraceVal, HostResult> action) {
        String desc = String.format(Locale.ROOT, "%s.%s", recvDesc, name);
        vars.put(this.vm.sym.handleFor(name), this.vm.fun.make(desc).take(0).action(c -> {
            Val recv = c.recv();
            if (!(recv instanceof TraceVal)) {
                return c.call(this.vm.graph.raiseFormat("{}: {} must be trace, but got {}", this.vm.graph.of(this.vm.str.of(desc)), this.vm.graph.of(this.vm.str.of(recvDesc)), this.vm.graph.repr(recv)));
            }
            TraceVal trace = (TraceVal)recv;
            return (HostResult)action.apply(c, trace);
        }));
    }
}

