/*
 * Decompiled with CFR 0.152.
 */
package org.kink_lang.kink.hostfun.graph.impl;

import org.kink_lang.kink.BindingVal;
import org.kink_lang.kink.FunVal;
import org.kink_lang.kink.Val;
import org.kink_lang.kink.Vm;
import org.kink_lang.kink.hostfun.HostContext;
import org.kink_lang.kink.hostfun.HostResult;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToArgs;
import org.kink_lang.kink.hostfun.graph.CallGraphNodeToRecv;
import org.kink_lang.kink.hostfun.graph.GraphFacade;
import org.kink_lang.kink.hostfun.graph.GraphNode;
import org.kink_lang.kink.hostfun.graph.impl.DirectCallGraph;
import org.kink_lang.kink.hostfun.graph.impl.MethodCallGraph;
import org.kink_lang.kink.hostfun.graph.impl.ModCallGraph;
import org.kink_lang.kink.hostfun.graph.impl.ValGraphNode;

public class GraphFacadeImpl
implements GraphFacade {
    private final Vm vm;
    private int formatHandle;
    private int reprHandle;
    private int raiseHandle;

    public GraphFacadeImpl(Vm vm) {
        this.vm = vm;
    }

    public void init() {
        this.formatHandle = this.vm.sym.handleFor("format");
        this.reprHandle = this.vm.sym.handleFor("repr");
        this.raiseHandle = this.vm.sym.handleFor("raise");
    }

    @Override
    public GraphNode of(Val val) {
        return new ValGraphNode(val);
    }

    @Override
    public CallGraphNodeToRecv call(FunVal fun) {
        return new DirectCallGraph(this.vm, fun, this.vm.graph.of(this.vm.nada), new GraphNode[0]);
    }

    @Override
    public CallGraphNodeToRecv call(GraphNode owner, int symHandle) {
        return MethodCallGraph.withOwnerRecv(this.vm, owner, symHandle, new GraphNode[0]);
    }

    @Override
    public CallGraphNodeToArgs call(String modName, int symHandle) {
        return new ModCallGraph(this.vm, modName, symHandle, new GraphNode[0]);
    }

    @Override
    public GraphNode repr(Val val) {
        return this.call(this.of(val), this.reprHandle);
    }

    @Override
    public GraphNode format(String template, GraphNode ... args) {
        GraphNode templateGraph = this.of(this.vm.str.of(template));
        return this.call(templateGraph, this.formatHandle).args(args);
    }

    @Override
    public GraphNode raiseFormat(String template, GraphNode ... args) {
        GraphNode msgGraph = this.format(template, args);
        BindingVal binding = this.vm.binding.newBinding();
        return this.call(this.of(binding), this.raiseHandle).args(msgGraph);
    }

    static HostResult id(HostContext c, Val r) {
        return r;
    }
}

